/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.exception.ChromosomeScaffoldException;
import jannovar.exception.VCFParseException;
import jannovar.exome.Variant;
import jannovar.genotype.GenotypeCall;
import jannovar.genotype.GenotypeFactoryA;

public class VCFLine {
    private String vcf_line = null;
    private byte chromosome;
    private int position;
    private String ref = null;
    private String alt = null;
    private float phredScore;
    private static GenotypeFactoryA genofactory = null;
    private GenotypeCall gtype = null;
    private static boolean storeVCFlines = false;

    public byte get_chromosome() {
        return this.chromosome;
    }

    public int get_position() {
        return this.position;
    }

    public String get_reference_sequence() {
        return this.ref;
    }

    public String get_alternate_sequence() {
        return this.alt;
    }

    public GenotypeCall getGenotype() {
        return this.gtype;
    }

    public float getVariantPhredScore() {
        return this.phredScore;
    }

    public static void setStoreVCFLines() {
        storeVCFlines = true;
    }

    public static void unsetStoreVCFLines() {
        storeVCFlines = false;
    }

    public static void setGenotypeFactory(GenotypeFactoryA fac) {
        genofactory = fac;
    }

    public VCFLine(String line) throws VCFParseException {
        if (storeVCFlines) {
            this.vcf_line = line;
        }
        this.parse_line(line);
    }

    private void parse_line(String line) throws ChromosomeScaffoldException, VCFParseException {
        String[] A = line.split("\t");
        if (A.length < 10) {
            throw new VCFParseException("Less than 10 fields in VCF line:" + line);
        }
        this.ref = A[3];
        if (this.ref.equals(".") || this.ref.length() < 1) {
            throw new VCFParseException("Could not parse ref field: \"" + this.ref + "\"\n" + line);
        }
        this.alt = A[4];
        if (this.alt.length() < 1) {
            throw new VCFParseException("Could not parse alt field:\"" + this.alt + "\"\n" + line);
        }
        this.phredScore = this.parseVariantQuality(A[5]);
        this.chromosome = this.convertChromosomeStringToByteValue(A[0]);
        try {
            Integer pos = Integer.parseInt(A[1]);
            this.position = pos;
        }
        catch (NumberFormatException e) {
            String error = "Number format exception while parsing the position field: \"" + A[1] + "\" in VCF line " + line;
            throw new VCFParseException(error);
        }
        try {
            this.gtype = genofactory.createGenotype(A);
        }
        catch (VCFParseException e) {
            String err = e.toString() + " on line: \n" + line;
            throw new VCFParseException(err);
        }
        this.convertToAnnovar();
    }

    public Variant toVariant() {
        Variant v = new Variant(this.get_chromosome(), this.get_position(), this.get_reference_sequence(), this.get_alternate_sequence(), this.getGenotype(), this.getVariantPhredScore());
        return v;
    }

    private float parseVariantQuality(String q) {
        if (q.equals(".")) {
            return 0.0f;
        }
        try {
            Float fQ = Float.valueOf(Float.parseFloat(q));
            return fQ.floatValue();
        }
        catch (NumberFormatException e) {
            System.err.println("[VCFLine] Warning: Unable to parse Phred score: \"" + q + "\"");
            return 0.0f;
        }
    }

    public void convertToAnnovar() throws VCFParseException {
        this.ref = this.ref.toUpperCase();
        this.alt = this.alt.toUpperCase();
        int idx = this.alt.indexOf(",");
        if (idx > 0) {
            this.alt = this.alt.substring(0, idx);
        }
        if (this.ref.length() == 1 && this.alt.length() == 1) {
            return;
        }
        if (this.ref.length() > this.alt.length()) {
            String head = this.ref.substring(0, this.alt.length());
            if (head.equals(this.alt)) {
                String r;
                int pos2;
                this.position = pos2 = this.position + head.length();
                this.ref = r = this.ref.substring(this.alt.length());
                this.alt = "-";
                return;
            }
            return;
        }
        if (this.alt.length() >= this.ref.length()) {
            String head = this.alt.substring(0, this.ref.length());
            if (head.equals(this.ref)) {
                int pos2;
                this.position = pos2 = this.position + this.ref.length() - 1;
                String mut = this.alt.substring(this.ref.length());
                this.ref = "-";
                this.alt = mut;
            } else {
                return;
            }
        }
    }

    public byte convertChromosomeStringToByteValue(String c) throws ChromosomeScaffoldException {
        if (c.startsWith("chr")) {
            c = c.substring(3);
        }
        if (c.equals("X")) {
            return 23;
        }
        if (c.equals("23")) {
            return 23;
        }
        if (c.equals("Y")) {
            return 24;
        }
        if (c.equals("24")) {
            return 24;
        }
        if (c.equals("M")) {
            return 25;
        }
        if (c.equals("MT")) {
            return 25;
        }
        if (c.equals("25")) {
            return 25;
        }
        Byte i = null;
        try {
            i = Byte.parseByte(c);
        }
        catch (NumberFormatException e) {
            ChromosomeScaffoldException cpe = new ChromosomeScaffoldException(c);
            throw cpe;
        }
        return i;
    }

    public String getOriginalVCFLine() {
        return this.vcf_line;
    }

    private void dump_VCF_line_for_debug() {
        System.err.println(this.vcf_line);
        System.err.println("chromosome: " + this.get_chromosome());
        System.err.println("position: " + this.get_position());
        System.err.println("reference sequence:" + this.get_reference_sequence());
        System.err.println("alt sequence:" + this.get_alternate_sequence());
    }
}

