/*
 * Decompiled with CFR 0.152.
 */
package jannovar.genotype;

import jannovar.common.Genotype;
import jannovar.exception.VCFParseException;
import jannovar.genotype.GenotypeCall;
import jannovar.genotype.GenotypeFactoryA;
import java.util.ArrayList;

public class MultipleGenotypeFactory
extends GenotypeFactoryA {
    private ArrayList<Genotype> callList = null;
    private ArrayList<Integer> qualityList = null;
    private ArrayList<Integer> depthList = null;
    private final int UNINITIALIZED_INT = -10;
    private int gt_idx = -10;
    private int qual_idx = -10;
    private int depth_idx = -10;

    @Override
    public GenotypeCall createGenotype(String[] A) throws VCFParseException {
        this.callList = new ArrayList();
        this.qualityList = new ArrayList();
        this.depthList = new ArrayList();
        String format = A[8];
        this.parseFORMATfield(format);
        for (int i = 9; i < A.length; ++i) {
            this.parseGenotypeField(A[i]);
        }
        GenotypeCall mgt = new GenotypeCall(this.callList, this.qualityList, this.depthList);
        return mgt;
    }

    private void parseFORMATfield(String format) throws VCFParseException {
        String[] A = format.split(":");
        this.gt_idx = -10;
        this.qual_idx = -10;
        this.depth_idx = -10;
        for (int i = 0; i < A.length; ++i) {
            if (A[i].equals("GT")) {
                this.gt_idx = i;
            }
            if (A[i].equals("GQ")) {
                this.qual_idx = i;
            }
            if (!A[i].equals("DP")) continue;
            this.depth_idx = i;
        }
        if (this.gt_idx < 0) {
            String s = String.format("Could not find genotype field in FORMAT field: \"%s\"", format);
            throw new VCFParseException(s);
        }
    }

    private void parseGenotypeField(String sample) throws VCFParseException {
        int genotype_quality = -10;
        int genotype_depth = -10;
        String[] B = sample.split(":");
        String genot = B[this.gt_idx];
        Genotype call = this.parseGenotypeString(genot);
        if (call == Genotype.NOT_OBSERVED) {
            this.qual_idx = -10;
            this.depth_idx = -10;
        }
        if (this.qual_idx != -10) {
            try {
                genotype_quality = this.parseGenotypeQuality(B[this.qual_idx]);
            }
            catch (NumberFormatException e) {
                String err = "Could not parse genotype quality field \"" + B[this.qual_idx] + "\" due to a Number Format Exception:" + e.toString();
                throw new VCFParseException(err);
            }
        }
        if (this.depth_idx != -10) {
            try {
                genotype_depth = this.parseGenotypeDepth(B[this.depth_idx]);
            }
            catch (NumberFormatException e) {
                String err = "Could not parse genotype depth field \"" + B[this.depth_idx] + "\" due to a Number Format Exception:" + e.toString();
                throw new VCFParseException(err);
            }
        }
        this.callList.add(call);
        this.qualityList.add(genotype_quality);
        this.depthList.add(genotype_depth);
    }
}

