/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.reference.TranscriptModel;

public class IntergenicAnnotation {
    public static Annotation createIntergenicAnnotation(TranscriptModel leftGene, TranscriptModel rightGene, int startpos, int endpos) {
        String annot;
        int dist;
        if (leftGene == null) {
            dist = rightGene.getTXStart() - endpos;
            annot = String.format("NONE(dist=NONE),%s(dist=%d)", rightGene.getGeneSymbol(), dist);
        } else if (rightGene == null) {
            dist = startpos - leftGene.getTXEnd();
            annot = String.format("%s(dist=%d),NONE(dist=NONE)", leftGene.getGeneSymbol(), dist);
        } else {
            int distR = rightGene.getTXStart() - endpos;
            int distL = startpos - leftGene.getTXEnd();
            annot = String.format("%s(dist=%d),%s(dist=%d)", leftGene.getGeneSymbol(), distL, rightGene.getGeneSymbol(), distR);
            dist = Math.min(distR, distL);
        }
        Annotation ann = Annotation.createIntergenicAnnotation(annot, VariantType.INTERGENIC);
        ann.setDistanceToNearestExon(dist);
        return ann;
    }

    public static Annotation createUpDownstreamAnnotation(TranscriptModel trmdl, int pos) {
        VariantType type = null;
        if (trmdl == null) {
            System.out.println("createUpDownstreamAnnotation, TranscriptModel argument is null, pos=" + pos);
            System.exit(1);
        }
        int dist = 0;
        if (trmdl.isFivePrimeToGene(pos)) {
            dist = trmdl.getTXStart() - pos;
            type = trmdl.isPlusStrand() ? VariantType.UPSTREAM : VariantType.DOWNSTREAM;
        } else if (trmdl.isThreePrimeToGene(pos)) {
            dist = pos - trmdl.getTXEnd();
            type = trmdl.isMinusStrand() ? VariantType.UPSTREAM : VariantType.DOWNSTREAM;
        }
        String annot = String.format("%s(dist=%d)", trmdl.getGeneSymbol(), dist);
        Annotation ann = new Annotation(trmdl, annot, type);
        ann.setDistanceToNearestExon(dist);
        return ann;
    }
}

