/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class AnnotationList {
    private ArrayList<Annotation> annotationList;
    private VariantType type = null;
    private boolean hasMultipleGeneSymbols = false;
    private boolean isPrioritySorted = false;

    private AnnotationList() {
    }

    public AnnotationList(ArrayList<Annotation> lst) {
        this.annotationList = new ArrayList();
        this.annotationList.addAll(lst);
    }

    public ArrayList<Annotation> getAnnotationList() {
        return this.annotationList;
    }

    public void setHasMultipleGeneSymbols() {
        this.hasMultipleGeneSymbols = true;
    }

    public boolean hasMultipleGeneSymbols() {
        return this.hasMultipleGeneSymbols;
    }

    public void sortAnnotations() throws AnnotationException {
        if (this.isPrioritySorted) {
            return;
        }
        if (this.annotationList.isEmpty()) {
            throw new AnnotationException("No data for annotation");
        }
        Collections.sort(this.annotationList);
        this.isPrioritySorted = true;
    }

    public String getAllTranscriptVariantEffects() throws AnnotationException {
        if (this.annotationList.isEmpty()) {
            String e = String.format("[AnnotationList] Error: No Annotations found", new Object[0]);
            throw new AnnotationException(e);
        }
        if (!this.isPrioritySorted) {
            this.sortAnnotations();
        }
        StringBuffer buff = new StringBuffer();
        boolean hasFirst = false;
        for (Annotation anno : this.annotationList) {
            if (hasFirst) {
                buff.append(",");
            }
            buff.append((Object)anno.getVariantType());
            hasFirst = true;
        }
        return buff.toString();
    }

    public String getAllTranscriptAnnotations() throws AnnotationException {
        if (this.annotationList.isEmpty()) {
            String e = String.format("[AnnotationList] Error: No Annotations found", new Object[0]);
            throw new AnnotationException(e);
        }
        if (!this.isPrioritySorted) {
            this.sortAnnotations();
        }
        StringBuffer buff = new StringBuffer();
        boolean hasFirst = false;
        for (Annotation anno : this.annotationList) {
            if (hasFirst) {
                buff.append(",");
            }
            buff.append(anno.getSymbolAndAnnotation());
            hasFirst = true;
        }
        return buff.toString();
    }

    public String getSingleTranscriptAnnotation() throws AnnotationException {
        if (this.annotationList.isEmpty()) {
            String e = String.format("[AnnotationList] Error: No Annotations found", new Object[0]);
            throw new AnnotationException(e);
        }
        Annotation a = this.annotationList.get(0);
        return a.getSymbolAndAnnotation();
    }

    public int getDistanceFromExon() {
        if (this.annotationList.isEmpty()) {
            return 0;
        }
        int mindist = Integer.MAX_VALUE;
        for (Annotation a : this.annotationList) {
            int dist = a.getDistanceToNearestExon();
            if (dist == 0) {
                return 0;
            }
            if (dist >= mindist) continue;
            mindist = dist;
        }
        return mindist;
    }

    public String getVariantAnnotation() throws AnnotationException {
        if (this.annotationList.isEmpty()) {
            String e = String.format("[AnnotationList] Error: No Annotations found", new Object[0]);
            throw new AnnotationException(e);
        }
        ArrayList<Annotation> priorityList = new ArrayList();
        VariantType tp = this.annotationList.get(0).getVariantType();
        int topPriority = VariantType.priorityLevel(tp);
        int lastIdx = this.annotationList.size() - 1;
        VariantType lastType = this.annotationList.get(lastIdx).getVariantType();
        if (tp.equals((Object)lastType)) {
            priorityList = this.annotationList;
        } else {
            Annotation a;
            int level;
            Iterator<Annotation> i$ = this.annotationList.iterator();
            while (i$.hasNext() && (level = VariantType.priorityLevel((a = i$.next()).getVariantType())) == topPriority) {
                priorityList.add(a);
            }
        }
        if (topPriority == 1) {
            return this.getExonicAnnotations(priorityList);
        }
        if (this.type == VariantType.ncRNA_EXONIC || this.type == VariantType.ncRNA_SPLICING) {
            return this.getNoncodingRnaAnnotation(priorityList);
        }
        if (this.type == VariantType.UTR3 || this.type == VariantType.UTR5) {
            return this.getUTRAnnotation(priorityList);
        }
        if (this.type == VariantType.SYNONYMOUS) {
            return this.getExonicAnnotations(priorityList);
        }
        if (this.type == VariantType.INTRONIC || this.type == VariantType.ncRNA_INTRONIC) {
            return this.getIntronicAnnotation(priorityList);
        }
        if (this.type == VariantType.DOWNSTREAM || this.type == VariantType.UPSTREAM) {
            return this.getUpDownstreamAnnotation(priorityList);
        }
        if (this.type == VariantType.INTERGENIC) {
            Annotation ann = priorityList.get(0);
            return ann.getVariantAnnotation();
        }
        if (this.hasMultipleGeneSymbols) {
            return this.getCombinedAnnotationForVariantAffectingMultipleGenes();
        }
        throw new AnnotationException("[AnnotationList] Could not find annotation class");
    }

    private String getExonicAnnotations(ArrayList<Annotation> lst) {
        StringBuilder sb = new StringBuilder();
        boolean needGeneSymbol = true;
        for (int j = 0; j < lst.size(); ++j) {
            Annotation ann = lst.get(j);
            if (needGeneSymbol) {
                sb.append(String.format("%s(%s", ann.getGeneSymbol(), ann.getVariantAnnotation()));
                needGeneSymbol = false;
                continue;
            }
            sb.append(",").append(ann.getVariantAnnotation());
        }
        sb.append(")");
        return sb.toString();
    }

    public String getGeneSymbol() {
        if (this.annotationList == null) {
            System.err.println("error-annotationListNull");
            System.out.println("VarType = " + (Object)((Object)this.type));
        } else if (this.annotationList.isEmpty()) {
            System.err.println("error-annotationList-zero size");
            System.out.println("VarType = " + (Object)((Object)this.type));
        } else {
            Annotation ann = this.annotationList.get(0);
            if (ann == null) {
                System.err.println("error-annotationObjectNull");
                System.out.println("VarType = " + (Object)((Object)this.type));
            } else {
                return ann.getGeneSymbol();
            }
        }
        return "?";
    }

    public int getEntrezGeneID() {
        return this.annotationList.get(0).getEntrezGeneID();
    }

    public VariantType getVariantType() {
        return this.type;
    }

    public void setMostPathogenicVariantType(VariantType vt) {
        this.type = vt;
    }

    public boolean isEmpty() {
        return this.annotationList.isEmpty();
    }

    public String getMultipleGeneList() {
        StringBuilder sb = new StringBuilder();
        HashSet<String> geneSymbolSet = new HashSet<String>();
        int i = 0;
        for (Annotation a : this.annotationList) {
            if (!geneSymbolSet.contains(a.getGeneSymbol())) {
                if (i > 0) {
                    sb.append(", ");
                }
                ++i;
                sb.append(a.getGeneSymbol());
            }
            geneSymbolSet.add(a.getGeneSymbol());
        }
        return sb.toString();
    }

    public String getCombinedAnnotationForVariantAffectingMultipleGenes() throws AnnotationException {
        StringBuilder sb = new StringBuilder();
        HashSet<String> geneSymbolSet = new HashSet<String>();
        for (Annotation a : this.annotationList) {
            geneSymbolSet.add(a.getGeneSymbol());
        }
        for (String s : geneSymbolSet) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (int j = 0; j < this.annotationList.size(); ++j) {
                Annotation ann = this.annotationList.get(j);
                if (ann == null) {
                    throw new AnnotationException("[AnnotationList.java]Annotation is null");
                }
                String sym = ann.getGeneSymbol();
                if (!sym.equals(s)) continue;
                tmp.add(ann.getVariantAnnotation());
            }
            if (tmp.isEmpty()) continue;
            sb.append(s).append("(").append((String)tmp.get(0));
            for (int i = 1; i < tmp.size(); ++i) {
                sb.append(",").append((String)tmp.get(i));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private String getUpDownstreamAnnotation(ArrayList<Annotation> lst) {
        boolean first = true;
        HashSet<String> seen = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (Annotation a : lst) {
            String sym = a.getGeneSymbol();
            if (seen.contains(sym)) continue;
            seen.add(sym);
            if (first) {
                sb.append(a.getVariantAnnotation());
                first = false;
                continue;
            }
            sb.append(",").append(a.getVariantAnnotation());
        }
        return sb.toString();
    }

    private ArrayList<String> getSortedListOfGeneSymbols() {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        for (Annotation a : this.annotationList) {
            String s = a.getVariantAnnotation();
            if (set.contains(s)) continue;
            set.add(s);
            list.add(s);
        }
        Collections.sort(list);
        return list;
    }

    private String getIntronicAnnotation(ArrayList<Annotation> lst) {
        StringBuilder sb = new StringBuilder();
        if (!this.hasMultipleGeneSymbols) {
            Annotation ann = lst.get(0);
            sb.append(ann.getGeneSymbol());
            sb.append("(");
            sb.append(ann.getVariantAnnotation());
            sb.append(")");
        } else {
            HashSet<String> seen = new HashSet<String>();
            boolean hasFirst = false;
            for (Annotation a : lst) {
                String sym = a.getGeneSymbol();
                if (seen.contains(sym)) continue;
                seen.add(sym);
                if (hasFirst) {
                    sb.append(",");
                }
                sb.append(a.getGeneSymbol());
                sb.append("(");
                sb.append(a.getVariantAnnotation());
                sb.append(")");
                hasFirst = true;
            }
        }
        return sb.toString();
    }

    private String getNoncodingRnaAnnotation(ArrayList<Annotation> lst) {
        StringBuilder sb = new StringBuilder();
        boolean notfirst = false;
        for (Annotation a : lst) {
            if (notfirst) {
                sb.append(",");
            } else {
                notfirst = true;
            }
            sb.append(a.getGeneSymbol());
            sb.append("(");
            sb.append(a.getVariantAnnotation());
            sb.append(")");
        }
        return sb.toString();
    }

    private String getUTRAnnotation(ArrayList<Annotation> lst) throws AnnotationException {
        HashSet<String> seen = new HashSet<String>();
        for (Annotation a : lst) {
            String s = a.getGeneSymbol();
            if (seen.contains(s)) continue;
            seen.add(s);
            if (s != null) continue;
            String e = "No Gene symbol found for UTR variant";
            throw new AnnotationException(e);
        }
        StringBuilder sb = new StringBuilder();
        boolean needGeneSymbol = true;
        for (int j = 0; j < lst.size(); ++j) {
            Annotation ann = lst.get(j);
            if (!ann.isUTRVariant()) continue;
            if (needGeneSymbol) {
                sb.append(String.format("%s(%s", ann.getGeneSymbol(), ann.getVariantAnnotation()));
                needGeneSymbol = false;
                continue;
            }
            sb.append(",").append(ann.getVariantAnnotation());
        }
        sb.append(")");
        return sb.toString();
    }

    public void debugPrint() {
        System.out.println("AnnotatedList.java:debugPrint");
        System.out.println("Total annotations: " + this.annotationList.size());
        for (Annotation a : this.annotationList) {
            int level = VariantType.priorityLevel(a.getVariantType());
            System.out.println("[" + a.getVariantTypeAsString() + "] \"" + a.getGeneSymbol() + "\" -> " + a.getVariantAnnotation() + " [" + level + "]");
        }
        System.out.println("*******");
    }
}

