/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.common.Constants;
import jannovar.common.VariantType;
import jannovar.reference.TranscriptModel;

public class Annotation
implements Constants,
Comparable<Annotation> {
    private VariantType varType;
    private int rvarstart;
    private String variantAnnotation = null;
    private String geneSymbol = null;
    private int entrezGeneID = -10;

    public VariantType getVariantType() {
        return this.varType;
    }

    public void setVarType(VariantType typ) {
        this.varType = typ;
    }

    public Annotation(TranscriptModel tmdl, String annotation, VariantType type) {
        this.varType = type;
        this.variantAnnotation = annotation;
        this.geneSymbol = tmdl == null ? null : tmdl.getGeneSymbol();
        this.entrezGeneID = tmdl == null ? null : Integer.valueOf(tmdl.getGeneID());
    }

    public Annotation(TranscriptModel tmdl, String annotation, VariantType type, int refvarstart) {
        this(tmdl, annotation, type);
        this.rvarstart = refvarstart;
    }

    public static Annotation createIntergenicAnnotation(String annotation, VariantType type) {
        Annotation a = new Annotation();
        a.varType = type;
        a.variantAnnotation = annotation;
        a.geneSymbol = null;
        a.rvarstart = 0;
        return a;
    }

    void setDistanceToNearestExon(int d) {
        this.rvarstart = d;
    }

    int getDistanceToNearestExon() {
        if (this.varType == VariantType.INTERGENIC || this.varType == VariantType.INTRONIC || this.varType == VariantType.UPSTREAM || this.varType == VariantType.DOWNSTREAM) {
            return this.rvarstart;
        }
        return 0;
    }

    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public int getEntrezGeneID() {
        return this.entrezGeneID;
    }

    public String getVariantAnnotation() {
        return this.variantAnnotation;
    }

    public String getSymbolAndAnnotation() {
        if (this.geneSymbol == null && this.variantAnnotation != null) {
            return this.variantAnnotation;
        }
        return String.format("%s:%s", this.geneSymbol, this.variantAnnotation);
    }

    public String getAccessionNumber() {
        if (this.variantAnnotation == null) {
            return ".";
        }
        int i = this.variantAnnotation.indexOf(":");
        if (i > 0) {
            return this.variantAnnotation.substring(0, i);
        }
        if (this.geneSymbol == null) {
            return ".";
        }
        return this.geneSymbol;
    }

    public void setVariantAnnotation(String s) {
        this.variantAnnotation = s;
    }

    public void setGeneSymbol(String symbol) {
        this.geneSymbol = symbol;
    }

    public void setGeneID(int id) {
        this.entrezGeneID = id;
    }

    public boolean equals(Annotation other) {
        return this.varType == other.varType && (this.geneSymbol != null && this.geneSymbol.equals(other.geneSymbol) || this.geneSymbol == null && other.geneSymbol == null) && this.variantAnnotation != null && this.variantAnnotation.equals(other.variantAnnotation);
    }

    private Annotation() {
        this.rvarstart = 0;
    }

    public static Annotation createEmptyAnnotation() {
        Annotation a = new Annotation();
        a.rvarstart = 0;
        return a;
    }

    public String getVariantTypeAsString() {
        return this.varType.toString();
    }

    public boolean isCodingExonic() {
        switch (this.varType) {
            case SPLICING: 
            case STOPLOSS: 
            case STOPGAIN: 
            case SYNONYMOUS: 
            case MISSENSE: 
            case NON_FS_SUBSTITUTION: 
            case NON_FS_INSERTION: 
            case FS_SUBSTITUTION: 
            case FS_DELETION: 
            case FS_INSERTION: 
            case NON_FS_DELETION: {
                return true;
            }
        }
        return false;
    }

    public boolean isUTRVariant() {
        switch (this.varType) {
            case UTR3: 
            case UTR5: {
                return true;
            }
        }
        return false;
    }

    public boolean isNonCodingRNA() {
        return this.varType == VariantType.ncRNA_EXONIC;
    }

    @Override
    public int compareTo(Annotation other) {
        int yourpriority;
        int mypriority = VariantType.priorityLevel(this.varType);
        if (mypriority < (yourpriority = VariantType.priorityLevel(other.varType))) {
            return -1;
        }
        if (mypriority > yourpriority) {
            return 1;
        }
        if (this.rvarstart < other.rvarstart) {
            return -1;
        }
        if (this.rvarstart > other.rvarstart) {
            return 1;
        }
        return 0;
    }
}

