/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.geom.Path2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.SAMRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Range;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MiscUtils {
    private static final Log LOG = LogFactory.getLog(MiscUtils.class);
    public static final boolean MAC;
    public static final boolean WINDOWS;
    public static final boolean LINUX;
    public static final String UNSAVED_MARK = " *";
    public static final int MENU_MASK;

    public static boolean doesIntersect(long s_start, long s_end, long t_start, long t_end) {
        return t_start <= s_end && t_end >= s_start;
    }

    public static Condition getIntersectCondition(long s_start, long s_end, DbColumn t_start, DbColumn t_end) {
        return ComboCondition.and(new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)t_start, (Object)s_end), new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)t_end, (Object)s_start));
    }

    public static String numToString(double num) {
        return MiscUtils.numToString(num, 0);
    }

    public static String numToStringWithOrder(long count) {
        if (count < 1000L) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f %c", (double)count / Math.pow(1000.0, exp), Character.valueOf("KMGTPE".charAt(exp - 1)));
    }

    public static String numToString(double num, int significantdigits) {
        String formatString = "###,###";
        if (significantdigits > 0) {
            formatString = formatString + ".";
            for (int i = 0; i < significantdigits; ++i) {
                formatString = formatString + "#";
            }
        }
        DecimalFormat df = new DecimalFormat(formatString);
        return df.format(num);
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        return DateFormat.getTimeInstance().format(cal.getTime());
    }

    public static String join(Collection<? extends Object> strs, String separator) {
        StringBuilder result = null;
        for (Object object : strs) {
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(separator);
            }
            result.append(object);
        }
        return result.toString();
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public static String getFilenameFromPath(String path) {
        int lastSlashIndex = path.lastIndexOf(System.getProperty("file.separator"));
        if (lastSlashIndex == -1) {
            lastSlashIndex = path.lastIndexOf("/");
        }
        return path.substring(lastSlashIndex + 1, path.length());
    }

    public static String getBaseName(String path) {
        String name = new File(path).getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex == name.length() - 1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public static String getExtension(String path) {
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex == path.length() - 1) {
            return "";
        }
        return path.substring(dotIndex + 1);
    }

    public static String getExtension(URL url) {
        return MiscUtils.getExtension(url.toString());
    }

    public static String getFileName(URI uri) {
        String path = uri.toString();
        int lastSlashIndex = path.lastIndexOf("/");
        return path.substring(lastSlashIndex + 1, path.length());
    }

    public static String getTemporaryDirectory() {
        if (MAC || LINUX) {
            String tmpDir = System.getenv("TMPDIR");
            if (tmpDir != null) {
                return tmpDir;
            }
            return "/tmp/savant";
        }
        String tmpDir = System.getenv("TEMP");
        if (tmpDir != null) {
            return tmpDir;
        }
        tmpDir = System.getenv("TMP");
        if (tmpDir != null) {
            return tmpDir;
        }
        return System.getProperty("user.dir");
    }

    public static List<String> set2List(Set<String> set) {
        ArrayList<String> l = new ArrayList<String>();
        for (String s : set) {
            l.add(s);
        }
        Collections.sort(l);
        return l;
    }

    public static String getMessage(Throwable t) {
        if (t instanceof NullPointerException) {
            return "Null pointer exception";
        }
        if (t instanceof FileNotFoundException) {
            return String.format("File %s not found", t.getMessage());
        }
        if (t instanceof ArrayIndexOutOfBoundsException) {
            return "Array index out of bounds";
        }
        String result = t.getMessage();
        if (result == null) {
            result = t.getClass().getSimpleName();
        }
        return result;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter result = new StringWriter();
        t.printStackTrace(new PrintWriter(result));
        return ((Object)result).toString();
    }

    public static String homogenizeSequence(String s) {
        String result = s;
        if (result.contains("chr")) {
            result = result.replaceAll("chr", "");
        }
        if (result.contains("Chr")) {
            result = result.replaceAll("Chr", "");
        }
        if (result.contains("contig")) {
            result = result.replaceAll("contig", "");
        }
        if (result.contains("Contig")) {
            result = result.replaceAll("Contig", "");
        }
        return result;
    }

    public static double roundToSignificantDigits(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        if (n == 0) {
            return Math.round(num);
        }
        String s = num + "";
        int index = s.indexOf(".");
        while (n >= s.length() - index) {
            s = s + "0";
        }
        return Double.parseDouble(s.substring(0, index + n + 1));
    }

    public static String getSophisticatedByteString(long bytes) {
        if (bytes < 1000L) {
            return bytes + " KB";
        }
        if (bytes < 1000000000L) {
            return MiscUtils.roundToSignificantDigits((double)bytes / 1000000.0, 1) + " MB";
        }
        return MiscUtils.roundToSignificantDigits((double)bytes / 1.0E9, 2) + " GB";
    }

    public static String getNeatPathFromURI(URI u) {
        if (u == null) {
            return "";
        }
        if ("file".equals(u.getScheme())) {
            return new File(u).getAbsolutePath();
        }
        return u.toString();
    }

    public static void invokeLaterIfNecessary(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public static String reverseString(String str) {
        int strlen = str.length();
        char[] result = new char[strlen];
        for (int i = 1; i <= strlen; ++i) {
            result[strlen - i] = str.charAt(i - 1);
        }
        return new String(result);
    }

    public static boolean isMate(SAMRecord rec1, SAMRecord rec2, boolean extraCheck) {
        String[][] suffices;
        if (rec1 == rec2) {
            return false;
        }
        String name1 = rec1.getReadName();
        String name2 = rec2.getReadName();
        int len1 = name1.length();
        int len2 = name2.length();
        if (extraCheck ? name1.equals(name2) && rec1.getMateAlignmentStart() == rec2.getAlignmentStart() && rec1.getAlignmentStart() == rec2.getMateAlignmentStart() : name1.equals(name2)) {
            return true;
        }
        for (String[] pair : suffices = new String[][]{{"\\1", "\\2"}, {"_F", "_R"}, {"_F3", "_R3"}}) {
            int len = pair[0].length();
            if (!name1.substring(0, len1 - len).equals(name2.substring(0, len2 - len)) || (!name1.substring(len1 - len).equals(pair[0]) || !name2.substring(len2 - len).equals(pair[1])) && (!name1.substring(len1 - len).equals(pair[1]) || !name2.substring(len2 - len).equals(pair[0]))) continue;
            return true;
        }
        return false;
    }

    public static Color blend(Color col1, Color col2, float weight1) {
        float weight2 = (1.0f - weight1) / 255.0f;
        return new Color((float)col1.getRed() * (weight1 /= 255.0f) + (float)col2.getRed() * weight2, (float)col1.getGreen() * weight1 + (float)col2.getGreen() * weight2, (float)col1.getBlue() * weight1 + (float)col2.getBlue() * weight2);
    }

    public static Path2D.Double createPolygon(double ... coords) {
        if (coords.length < 4 || (coords.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid coordinates for createPolygon");
        }
        Path2D.Double result = new Path2D.Double(1, coords.length / 2);
        result.moveTo(coords[0], coords[1]);
        for (int i = 2; i < coords.length; i += 2) {
            result.moveTo(coords[i], coords[i + 1]);
        }
        result.closePath();
        return result;
    }

    public static String getTagValue(Element e, String tag) {
        NodeList nlList = e.getElementsByTagName(tag).item(0).getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    public static Set<String> getTagValues(Element e, String tag) {
        NodeList nlList = e.getElementsByTagName(tag);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < nlList.getLength(); ++i) {
            Node nValue = nlList.item(i).getChildNodes().item(0);
            result.add(nValue.getNodeValue());
        }
        return result;
    }

    public static String addBreaksToString(String original, int maxCharsPerLine) {
        String current = original;
        String result = "";
        while (current.length() > 0) {
            if (current.length() <= maxCharsPerLine) {
                result = result + current;
                break;
            }
            int index = current.substring(0, Math.min(current.length(), maxCharsPerLine)).lastIndexOf(" ");
            if (index == -1) {
                index = Math.min(current.length(), maxCharsPerLine);
            }
            index = Math.min(index + 1, current.length());
            result = result + current.substring(0, index) + "<BR>";
            current = current.substring(index);
        }
        return result;
    }

    public static double generateBins(CustomField field, Range r, boolean isLogScaleX) {
        int step2;
        if (isLogScaleX) {
            return 10.0;
        }
        if ((field.getColumnType() == ColumnType.DECIMAL || field.getColumnType() == ColumnType.FLOAT) && r.getMax() - r.getMin() <= 1.0 && r.getMax() <= 1.0) {
            return 0.05;
        }
        if (field.getColumnType() == ColumnType.INTEGER && field.getColumnLength() == 1 || field.getColumnType() == ColumnType.BOOLEAN) {
            return 1.0;
        }
        int min = (int)(r.getMin() - Math.abs(r.getMin() % (double)((int)Math.pow(10.0, MiscUtils.getNumDigits((int)(r.getMax() - r.getMin())) - 1))));
        int step1 = (int)Math.ceil((r.getMax() - (double)min) / 25.0);
        int step = step2 = (int)Math.pow(10.0, MiscUtils.getNumDigits(step1));
        while ((double)step * 0.5 > (double)step1) {
            step = (int)((double)step * 0.5);
        }
        step = Math.max(step, 1);
        return step;
    }

    public static int getNumDigits(int x) {
        x = Math.abs(x);
        int digits = 1;
        while (Math.pow(10.0, digits) < (double)x) {
            ++digits;
        }
        return digits;
    }

    public static String doubleToString(double d, int sigDigs) {
        int pos;
        String s = Double.toString(d);
        if (Math.abs(d) < 10.0 && (pos = s.indexOf(".")) != -1) {
            s = s.substring(0, Math.min(pos + 3, s.length()));
        }
        return s;
    }

    public static Object parseStringValueAs(Class c, String value) {
        if (c == String.class) {
            return value;
        }
        if (c == Long.class) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (c == Float.class) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new UnsupportedOperationException("Parser doesn't deal with objects of type " + c);
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String extractFileName(String fullName) {
        Pattern p = Pattern.compile(".*?([^\\\\/]+)$");
        Matcher m = p.matcher(fullName);
        return m.find() ? m.group(1) : "";
    }

    public static void deleteDirectory(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                MiscUtils.deleteDirectory(c);
            }
        }
        boolean b = f.delete();
        LOG.info((Object)("Deleting " + f.getAbsolutePath() + "... " + (b ? "SUCCESS" : "FAILED")));
    }

    public static String pluralize(int num, String singular, String plural) {
        return num == 1 ? singular : plural;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        MAC = os.startsWith("mac");
        WINDOWS = os.startsWith("windows");
        LINUX = os.contains("linux");
        MENU_MASK = MAC ? 4 : 2;
    }
}

