/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.ut.biolab.medsavant.shared.model.ScatterChartEntry;

public class ScatterChartMap
implements Serializable {
    List<String> xRanges;
    List<String> yRanges;
    ScatterChartEntry[][] entries;

    public ScatterChartMap(List<String> xRanges, List<String> yRanges, List<ScatterChartEntry> entries) {
        this.xRanges = xRanges;
        this.yRanges = yRanges;
        this.entries = new ScatterChartEntry[xRanges.size()][yRanges.size()];
        Iterator<ScatterChartEntry> i$ = entries.iterator();
        while (i$.hasNext()) {
            ScatterChartEntry e;
            this.entries[xRanges.indexOf((Object)e.getXRange())][yRanges.indexOf((Object)e.getYRange())] = e = i$.next();
        }
    }

    public ScatterChartEntry getValueAt(int x, int y) {
        if (x < 0 || x >= this.getNumX() || y < 0 || y >= this.getNumY()) {
            return null;
        }
        return this.entries[x][y];
    }

    public int getNumX() {
        return this.xRanges.size();
    }

    public int getNumY() {
        return this.yRanges.size();
    }

    public String getXValueAt(int x) {
        return this.xRanges.get(x);
    }

    public String getYValueAt(int y) {
        return this.yRanges.get(y);
    }

    public List<String> getXRanges() {
        return this.xRanges;
    }

    public List<String> getYRanges() {
        return this.yRanges;
    }

    public int getIndexOnX(String value) {
        return this.xRanges.indexOf(value);
    }

    public int getIndexOnY(String value) {
        return this.yRanges.indexOf(value);
    }

    public int getMaxFrequency() {
        int max = 0;
        for (int x = 0; x < this.getNumX(); ++x) {
            for (int y = 0; y < this.getNumY(); ++y) {
                if (this.getValueAt(x, y) == null) continue;
                max = Math.max(max, this.getValueAt(x, y).getFrequency());
            }
        }
        return max;
    }
}

