/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.db;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.db.ColumnDef;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class TableSchema
implements Serializable {
    private static final Log LOG = LogFactory.getLog(TableSchema.class);
    private final LinkedHashMap<String, DbColumn> nameToColumn;
    private final DbTable table;
    protected SelectQuery selectQuery;
    private List<DbColumn> autoIncrements;

    public TableSchema(DbTable t) {
        this.table = t;
        this.nameToColumn = new LinkedHashMap();
    }

    public TableSchema(DbSchema s, String name, Class columnsClass) {
        this(s.addTable(name));
        Field[] fields;
        this.autoIncrements = new ArrayList<DbColumn>();
        for (Field f : fields = columnsClass.getDeclaredFields()) {
            try {
                Object fieldValue = f.get(null);
                if (!(fieldValue instanceof ColumnDef)) continue;
                this.addColumn((ColumnDef)fieldValue);
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to get column definition for " + f), (Throwable)ex);
            }
        }
    }

    public TableSchema(DbSchema s, String name, ColumnDef[] cols) {
        this(s.addTable(name));
        this.autoIncrements = new ArrayList<DbColumn>();
        for (ColumnDef c : cols) {
            this.addColumn(c);
        }
    }

    public final DbColumn addColumn(String dbName, ColumnType t, int length) {
        return this.addColumn(dbName, t, length, 0);
    }

    public final DbColumn addColumn(String dbName, ColumnType t, int length, int scale) {
        Integer l = length > 0 ? Integer.valueOf(length) : null;
        DbColumn c = this.table.addColumn(dbName, t.toString(), l, scale > 0 ? Integer.valueOf(scale) : null);
        this.nameToColumn.put(dbName, c);
        return c;
    }

    public final DbColumn addColumn(ColumnDef col) {
        DbColumn dbc = this.addColumn(col.name, col.type, col.length, col.scale);
        if (col.defaultValue != null) {
            dbc.setDefaultValue(col.defaultValue);
        }
        if (col.autoIncrement) {
            this.autoIncrements.add(dbc);
        }
        if (col.nonNull) {
            dbc.notNull();
        }
        if (col.primaryKey) {
            dbc.primaryKey();
        }
        return dbc;
    }

    public int getNumFields() {
        return this.nameToColumn.size();
    }

    public DbColumn getDBColumn(String name) {
        return this.nameToColumn.get(name);
    }

    public DbColumn getDBColumn(ColumnDef def) {
        return this.getDBColumn(def.name);
    }

    public List<DbColumn> getColumns() {
        return new ArrayList<DbColumn>(this.nameToColumn.values());
    }

    public DbTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public CreateTableQuery getCreateQuery() {
        CreateTableQuery query = new CreateTableQuery(this.table, true);
        for (DbColumn col : this.autoIncrements) {
            query.addColumnConstraint(col, "AUTO_INCREMENT");
        }
        return query;
    }

    public synchronized SelectQuery select(Object ... cols) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        for (Object o : cols) {
            if (o instanceof ColumnDef) {
                this.selectQuery.addColumns(this.table.findColumn(((ColumnDef)o).name));
                continue;
            }
            this.selectQuery.addCustomColumns(new CustomSql(o));
        }
        SelectQuery result = this.selectQuery;
        this.selectQuery = null;
        return result;
    }

    public synchronized TableSchema where(Object ... wheres) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        for (int i = 0; i < wheres.length; i += 2) {
            this.selectQuery.addCondition(BinaryConditionMS.equalTo(this.table.findColumn(((ColumnDef)wheres[i]).name), wheres[i + 1]));
        }
        return this;
    }

    public synchronized TableSchema whereNotNull(Object ... wheres) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        for (int i = 0; i < wheres.length; ++i) {
            this.selectQuery.addCondition(UnaryCondition.isNotNull(this.table.findColumn(((ColumnDef)wheres[i]).name)));
        }
        return this;
    }

    public synchronized TableSchema whereIn(ColumnDef col, Collection ins) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        this.selectQuery.addCondition(new InCondition((Object)this.table.findColumn(col.name), ins));
        return this;
    }

    public synchronized TableSchema distinct() {
        if (this.selectQuery != null) {
            this.selectQuery.setIsDistinct(true);
        } else {
            this.selectQuery = new SelectQuery(true);
            this.selectQuery.addFromTable(this.table);
        }
        return this;
    }

    public synchronized TableSchema orderBy(ColumnDef ... groupCols) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        for (ColumnDef col : groupCols) {
            this.selectQuery.addOrdering(this.table.findColumn(col.name), OrderObject.Dir.ASCENDING);
        }
        return this;
    }

    public synchronized TableSchema groupBy(ColumnDef ... groupCols) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        for (ColumnDef col : groupCols) {
            this.selectQuery.addGroupings(this.table.findColumn(col.name));
        }
        return this;
    }

    public synchronized TableSchema leftJoin(TableSchema t, String colName) {
        if (this.selectQuery == null) {
            this.selectQuery = new SelectQuery(false);
            this.selectQuery.addFromTable(this.table);
        }
        this.selectQuery.addCustomJoin(String.format(" LEFT JOIN %s USING (%s)", t.getTableName(), colName));
        return this;
    }

    public synchronized InsertQuery insert(Object ... insertions) {
        InsertQuery query = new InsertQuery(this.table);
        for (int i = 0; i < insertions.length; i += 2) {
            query.addColumn(this.table.findColumn(((ColumnDef)insertions[i]).name), insertions[i + 1]);
        }
        return query;
    }

    public synchronized InsertQuery preparedInsert(ColumnDef ... cols) {
        InsertQuery query = new InsertQuery(this.table);
        for (int i = 0; i < cols.length; ++i) {
            query.addPreparedColumns(this.table.findColumn(cols[i].name));
        }
        return query;
    }

    public synchronized DeleteQuery delete(Object ... wheres) {
        DeleteQuery query = new DeleteQuery(this.table);
        for (int i = 0; i < wheres.length; i += 2) {
            query.addCondition(BinaryConditionMS.equalTo(this.table.findColumn(((ColumnDef)wheres[i]).name), wheres[i + 1]));
        }
        return query;
    }
}

