/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.reference.TranscriptModel;
import jannovar.reference.Translator;

public class SingleNucleotideSubstitution {
    public static Annotation getAnnotation(TranscriptModel kgl, int frame_s, int frame_end_s, String wtnt3, String ref, String var, int refvarstart, int exonNumber) throws AnnotationException {
        if (kgl.isPlusStrand()) {
            return SingleNucleotideSubstitution.getAnnotationPlusStrand(kgl, frame_s, wtnt3, ref, var, refvarstart, exonNumber);
        }
        return SingleNucleotideSubstitution.getAnnotationPlusStrand(kgl, frame_s, wtnt3, ref, var, refvarstart, exonNumber);
    }

    public static Annotation getAnnotationPlusStrand(TranscriptModel kgl, int frame_s, String wtnt3, String ref, String var, int refvarstart, int exonNumber) throws AnnotationException {
        String wrng;
        char strand;
        Translator translator = Translator.getTranslator();
        String canno = null;
        String panno = null;
        String varnt3 = null;
        int refcdsstart = kgl.getRefCDSStart();
        int cdspos = refvarstart - refcdsstart + 1;
        if (ref.length() != 1) {
            throw new AnnotationException(String.format("Error: Malformed reference sequence (%s) for SNV annotation of %s", ref, kgl.getGeneSymbol()));
        }
        if (var.length() != 1) {
            throw new AnnotationException(String.format("Error: Malformed variant sequence (%s) for SNV annotation of %s", var, kgl.getGeneSymbol()));
        }
        char refc = ref.charAt(0);
        char varc = var.charAt(0);
        if (frame_s == 1) {
            varnt3 = String.format("%c%c%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(varc), Character.valueOf(wtnt3.charAt(2)));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(1)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        } else if (frame_s == 2) {
            varnt3 = String.format("%c%c%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), Character.valueOf(varc));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(2)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(2)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        } else {
            varnt3 = String.format("%c%c%c", Character.valueOf(varc), Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2)));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(0)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(0)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        }
        String wtaa = translator.translateDNA(wtnt3);
        String varaa = translator.translateDNA(varnt3);
        int aavarpos = (int)Math.floor((refvarstart - kgl.getRefCDSStart()) / 3) + 1;
        if (wtaa.equals(varaa)) {
            panno = String.format("%s:exon%d:%s:p.%s%d%s", kgl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
            Annotation ann = new Annotation(kgl, panno, VariantType.SYNONYMOUS, cdspos);
            return ann;
        }
        if (varaa.equals("*")) {
            panno = String.format("%s:exon%d:%s:p.%s%d*", kgl.getName(), exonNumber, canno, wtaa, aavarpos);
            Annotation ann = new Annotation(kgl, panno, VariantType.STOPGAIN, cdspos);
            return ann;
        }
        if (wtaa.equals("*")) {
            panno = String.format("%s:exon%d:%s:p.*%d%s", kgl.getName(), exonNumber, canno, aavarpos, varaa);
            Annotation ann = new Annotation(kgl, panno, VariantType.STOPLOSS, cdspos);
            return ann;
        }
        panno = String.format("%s:exon%d:%s:p.%s%d%s", kgl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
        Annotation ann = new Annotation(kgl, panno, VariantType.MISSENSE, cdspos);
        return ann;
    }

    public static Annotation getAnnotationMinusStrand(TranscriptModel kgl, int frame_s, String wtnt3, String ref, String var, int refvarstart, int exonNumber) throws AnnotationException {
        String wrng;
        char strand;
        Translator translator = Translator.getTranslator();
        String canno = null;
        String panno = null;
        String varnt3 = null;
        int refcdsstart = kgl.getRefCDSStart();
        int cdspos = refvarstart - refcdsstart + 1;
        if (ref.length() != 1) {
            throw new AnnotationException(String.format("Error: Malformed reference sequence (%s) for SNV annotation of %s", ref, kgl.getGeneSymbol()));
        }
        if (var.length() != 1) {
            throw new AnnotationException(String.format("Error: Malformed variant sequence (%s) for SNV annotation of %s", var, kgl.getGeneSymbol()));
        }
        char refc = ref.charAt(0);
        char varc = var.charAt(0);
        if (frame_s == 1) {
            varnt3 = String.format("%c%c%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(varc), Character.valueOf(wtnt3.charAt(2)));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(1)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        } else if (frame_s == 2) {
            varnt3 = String.format("%c%c%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), Character.valueOf(varc));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(2)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(2)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        } else {
            varnt3 = String.format("%c%c%c", Character.valueOf(varc), Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2)));
            canno = String.format("c.%d%c>%c", refvarstart - refcdsstart + 1, Character.valueOf(wtnt3.charAt(0)), Character.valueOf(varc));
            if (refc != wtnt3.charAt(0)) {
                strand = kgl.getStrand();
                wrng = String.format("WARNING: mRNA/genome discrepancy: \"%s\"/\"%s\" strand=%c", ref, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(strand));
                canno = String.format("%s [%s]", canno, wrng);
            }
        }
        String wtaa = translator.translateDNA(wtnt3);
        String varaa = translator.translateDNA(varnt3);
        int aavarpos = (int)Math.floor((refvarstart - kgl.getRefCDSStart()) / 3) + 1;
        if (wtaa.equals(varaa)) {
            panno = String.format("%s:exon%d:%s:p.%s%d%s", kgl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
            Annotation ann = new Annotation(kgl, panno, VariantType.SYNONYMOUS, cdspos);
            return ann;
        }
        if (varaa.equals("*")) {
            panno = String.format("%s:exon%d:%s:p.%s%d*", kgl.getName(), exonNumber, canno, wtaa, aavarpos);
            Annotation ann = new Annotation(kgl, panno, VariantType.STOPGAIN, cdspos);
            return ann;
        }
        if (wtaa.equals("*")) {
            panno = String.format("%s:exon%d:%s:p.*%d%s", kgl.getName(), exonNumber, canno, aavarpos, varaa);
            Annotation ann = new Annotation(kgl, panno, VariantType.STOPLOSS, cdspos);
            return ann;
        }
        panno = String.format("%s:exon%d:%s:p.%s%d%s", kgl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
        Annotation ann = new Annotation(kgl, panno, VariantType.MISSENSE, cdspos);
        return ann;
    }
}

