/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

public class SAMValidationError {
    private final Type type;
    private final String message;
    private final String readName;
    private long recordNumber = -1L;
    private String source;

    public SAMValidationError(Type type, String message, String readName) {
        this.type = type;
        this.message = message;
        this.readName = readName;
    }

    public SAMValidationError(Type type, String message, String readName, long recordNumber) {
        this(type, message, readName);
        this.recordNumber = recordNumber;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.severity.toString());
        builder.append(": ");
        if (this.source != null) {
            builder.append("File ").append(this.source.toString()).append(", ");
        }
        if (this.recordNumber > 0L) {
            builder.append("Record ").append(this.recordNumber).append(", ");
        }
        if (this.readName != null) {
            builder.append("Read name ").append(this.readName).append(", ");
        }
        return builder.append(this.message).toString();
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReadName() {
        return this.readName;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(long recordNumber) {
        this.recordNumber = recordNumber;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INVALID_FLAG_PROPER_PAIR,
        INVALID_FLAG_MATE_UNMAPPED,
        MISMATCH_FLAG_MATE_UNMAPPED,
        INVALID_FLAG_MATE_NEG_STRAND,
        MISMATCH_FLAG_MATE_NEG_STRAND,
        INVALID_FLAG_FIRST_OF_PAIR,
        INVALID_FLAG_SECOND_OF_PAIR,
        PAIRED_READ_NOT_MARKED_AS_FIRST_OR_SECOND(Severity.WARNING),
        INVALID_FLAG_NOT_PRIM_ALIGNMENT,
        INVALID_FLAG_READ_UNMAPPED,
        INVALID_INSERT_SIZE,
        INVALID_MAPPING_QUALITY,
        INVALID_CIGAR,
        ADJACENCT_INDEL_IN_CIGAR(Severity.WARNING),
        INVALID_MATE_REF_INDEX,
        MISMATCH_MATE_REF_INDEX,
        INVALID_REFERENCE_INDEX,
        INVALID_ALIGNMENT_START,
        MISMATCH_MATE_ALIGNMENT_START,
        MATE_FIELD_MISMATCH,
        INVALID_TAG_NM,
        MISSING_TAG_NM(Severity.WARNING),
        MISSING_HEADER,
        MISSING_SEQUENCE_DICTIONARY,
        MISSING_READ_GROUP,
        RECORD_OUT_OF_ORDER,
        READ_GROUP_NOT_FOUND,
        INVALID_INDEXING_BIN,
        MISSING_VERSION_NUMBER,
        INVALID_VERSION_NUMBER,
        TRUNCATED_FILE,
        MISMATCH_READ_LENGTH_AND_QUALS_LENGTH,
        EMPTY_READ,
        CIGAR_MAPS_OFF_REFERENCE,
        MISMATCH_READ_LENGTH_AND_E2_LENGTH,
        MISMATCH_READ_LENGTH_AND_U2_LENGTH,
        E2_BASE_EQUALS_PRIMARY_BASE(Severity.WARNING),
        BAM_FILE_MISSING_TERMINATOR_BLOCK(Severity.WARNING),
        UNRECOGNIZED_HEADER_TYPE,
        POORLY_FORMATTED_HEADER_TAG,
        HEADER_TAG_MULTIPLY_DEFINED,
        HEADER_RECORD_MISSING_REQUIRED_TAG,
        INVALID_DATE_STRING(Severity.WARNING),
        TAG_VALUE_TOO_LARGE,
        INVALID_INDEX_FILE_POINTER,
        INVALID_PREDICTED_MEDIAN_INSERT_SIZE,
        DUPLICATE_READ_GROUP_ID,
        DUPLICATE_PROGRAM_GROUP_ID,
        MATE_NOT_FOUND,
        MATES_ARE_SAME_END;

        public final Severity severity;

        private Type() {
            this.severity = Severity.ERROR;
        }

        private Type(Severity severity) {
            this.severity = severity;
        }

        public String getHistogramString() {
            return this.severity.name() + ":" + this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR;

    }
}

