/*
 * Decompiled with CFR 0.152.
 */
package jannovar.reference;

import jannovar.common.Constants;
import java.io.Serializable;
import java.util.ArrayList;

public class TranscriptModel
implements Serializable,
Constants {
    private String accession = null;
    private String geneSymbol = null;
    private byte chromosome;
    private char strand;
    private int txStart;
    private int txEnd;
    private int cdsStart;
    private int cdsEnd;
    private int rcdsStart;
    private short exonCount;
    private int[] exonStarts = null;
    private int[] exonEnds = null;
    private int mRNAlength;
    private int CDSlength;
    private String sequence = null;
    private int geneID = -10;
    public static final long serialVersionUID = 4L;

    private TranscriptModel() {
    }

    public static TranscriptModel createTranscriptModel() {
        return new TranscriptModel();
    }

    public void setAccessionNumber(String acc) {
        this.accession = acc;
    }

    public void setChromosome(byte c) {
        this.chromosome = c;
    }

    public void setStrand(char s) {
        this.strand = s;
    }

    public void setTranscriptionStart(int st) {
        this.txStart = st;
    }

    public void setTranscriptionEnd(int st) {
        this.txEnd = st;
    }

    public void setCdsStart(int st) {
        this.cdsStart = st;
    }

    public void setCdsEnd(int st) {
        this.cdsEnd = st;
    }

    public void setExonCount(short c) {
        this.exonCount = c;
    }

    public void setExonStartsAndEnds(int[] starts, int[] ends) {
        this.exonStarts = starts;
        this.exonEnds = ends;
    }

    public void initialize() {
        this.calculateMRNALength();
        this.calculateCDSLength();
        this.calculateRefCDSStart();
    }

    private void calculateMRNALength() {
        this.mRNAlength = 0;
        for (int i = 0; i < this.exonCount; ++i) {
            this.mRNAlength += this.exonEnds[i] - this.exonStarts[i] + 1;
        }
    }

    private void calculateRefCDSStart() {
        int cumlenintron = 0;
        this.rcdsStart = 0;
        if (this.isPlusStrand()) {
            if (this.cdsStart < this.txStart) {
                this.rcdsStart = this.cdsStart - this.txStart + 1;
                return;
            }
            for (int k = 0; k < this.exonCount; ++k) {
                if (k > 0) {
                    cumlenintron += this.getLengthOfIntron(k);
                }
                if (this.cdsStart < this.getExonStart(k) || this.cdsStart > this.getExonEnd(k)) continue;
                this.rcdsStart = this.cdsStart - this.txStart - cumlenintron + 1;
                break;
            }
        } else {
            if (this.isNonCodingGene()) {
                this.rcdsStart = 1;
                return;
            }
            if (this.cdsEnd > this.txEnd) {
                this.rcdsStart = this.txEnd - this.cdsEnd + 1;
                return;
            }
            for (int k = this.exonCount - 1; k >= 0; --k) {
                if (k < this.exonCount - 1) {
                    cumlenintron += this.exonStarts[k + 1] - this.exonEnds[k] - 1;
                }
                if (this.cdsEnd > this.getExonEnd(k) || this.cdsEnd < this.getExonStart(k)) continue;
                this.rcdsStart = this.txEnd - this.cdsEnd - cumlenintron + 1;
                break;
            }
        }
    }

    public int getRefCDSEnd() {
        int cumlenintron = 0;
        int rcdsend = 0;
        if (this.isPlusStrand()) {
            for (int k = 0; k < this.exonCount; ++k) {
                if (k > 0) {
                    cumlenintron += this.getLengthOfIntron(k);
                }
                if (this.cdsEnd < this.getExonStart(k) || this.cdsEnd > this.getExonEnd(k)) continue;
                rcdsend = this.cdsEnd - this.txStart - cumlenintron + 1;
                break;
            }
        } else {
            for (int k = this.exonCount - 1; k >= 0; --k) {
                if (k < this.exonCount - 1) {
                    cumlenintron += this.exonStarts[k + 1] - this.exonEnds[k] - 1;
                }
                if (this.cdsStart > this.getExonEnd(k) || this.cdsStart < this.getExonStart(k)) continue;
                rcdsend = this.txEnd - this.cdsStart - cumlenintron + 1;
                break;
            }
        }
        return rcdsend;
    }

    public int getRVarStart(int varstart, int cumlenintron) {
        int rvarstart = varstart - this.txStart - cumlenintron + 1;
        return rvarstart;
    }

    public String getCdnaSequence() {
        return this.sequence;
    }

    public String getCodingSequence() {
        if (this.rcdsStart < 1 || this.rcdsStart + this.CDSlength >= this.sequence.length()) {
            return this.sequence;
        }
        return this.sequence.substring(this.rcdsStart - 1, this.rcdsStart + this.CDSlength - 1);
    }

    public String getCodingSequencePlus3UTR() {
        if (this.rcdsStart < 1) {
            return this.sequence;
        }
        return this.sequence.substring(this.rcdsStart - 1);
    }

    public int getRVarEnd(int end, int k, int cumlenintron) {
        int rvarend = -1;
        for (int m = k; m < this.exonCount - 1; ++m) {
            if (m > k) {
                cumlenintron += this.getLengthOfIntron(m);
            }
            if (end < this.getExonStart(m)) {
                rvarend = this.getExonEnd(m - 1) - this.txStart - cumlenintron + 1 + this.getLengthOfIntron(m);
                break;
            }
            if (end > this.getExonEnd(m)) continue;
            rvarend = end - this.txStart - cumlenintron + 1;
            break;
        }
        if (rvarend < 0) {
            rvarend = this.txEnd - this.txStart - cumlenintron + 1;
        }
        return rvarend;
    }

    public boolean isThreePrimeToGene(int pos) {
        return pos > this.txEnd;
    }

    public boolean isFivePrimeToGene(int pos) {
        return pos < this.txStart;
    }

    public boolean isNearFivePrimeEnd(int pos, int threshold) {
        int distance = this.txStart - pos;
        if (distance <= 0) {
            return false;
        }
        return distance < threshold;
    }

    public boolean isNearThreePrimeEnd(int pos, int threshold) {
        int distance = pos - this.txEnd;
        if (distance <= 0) {
            return false;
        }
        return distance < threshold;
    }

    public int getDistanceToThreePrimeTerminus(int pos) {
        return pos - this.txEnd;
    }

    public int getDistanceToFivePrimeTerminus(int pos) {
        return this.txStart - pos;
    }

    private void calculateCDSLength() {
        this.CDSlength = 0;
        for (int i = 0; i < this.exonCount; ++i) {
            if (this.cdsStart >= this.exonStarts[i] && this.cdsStart <= this.exonEnds[i]) {
                if (this.cdsEnd <= this.exonEnds[i]) {
                    this.CDSlength = this.cdsEnd - this.cdsStart + 1;
                    break;
                }
                this.CDSlength += this.exonEnds[i] - this.cdsStart + 1;
                continue;
            }
            if (this.CDSlength > 0 && this.cdsEnd < this.exonStarts[i]) {
                System.err.println("Impossible parsing scenario for " + this.accession + " (CDSend is less than exon start)");
                System.exit(1);
                continue;
            }
            if (this.CDSlength > 0 && this.cdsEnd <= this.exonEnds[i]) {
                this.CDSlength += this.cdsEnd - this.exonStarts[i] + 1;
                break;
            }
            if (this.CDSlength <= 0 || this.cdsEnd <= this.exonEnds[i]) continue;
            this.CDSlength += this.exonEnds[i] - this.exonStarts[i] + 1;
        }
    }

    public boolean isCodingGene() {
        return this.cdsStart != this.cdsEnd + 1;
    }

    public boolean isNonCodingGene() {
        return this.cdsStart == this.cdsEnd + 1;
    }

    public int getTXStart() {
        return this.txStart;
    }

    public int getTXEnd() {
        return this.txEnd;
    }

    public int getCDSStart() {
        return this.cdsStart;
    }

    public int getCDSEnd() {
        return this.cdsEnd;
    }

    public int getMRNALength() {
        return this.mRNAlength;
    }

    public int getCDSLength() {
        return this.CDSlength;
    }

    public int getActualSequenceLength() {
        return this.sequence.length();
    }

    public int getExonCount() {
        return this.exonCount;
    }

    public byte getChromosome() {
        return this.chromosome;
    }

    public int getRefCDSStart() {
        return this.rcdsStart;
    }

    public String getAccessionNumber() {
        return this.accession;
    }

    public char getStrand() {
        return this.strand;
    }

    public boolean isPlusStrand() {
        return this.strand == '+';
    }

    public boolean isMinusStrand() {
        return this.strand == '-';
    }

    public String getName() {
        return this.accession;
    }

    public String getGeneSymbol() {
        if (this.geneSymbol != null) {
            return this.geneSymbol;
        }
        return this.accession;
    }

    public String getWTCodonNucleotides(int refvarstart, int frame_s) {
        int start = refvarstart - frame_s - 1;
        if (start + 3 > this.sequence.length()) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        return this.sequence.substring(start, start + 3);
    }

    public String getWTCodonNucleotidesAfterVariant(int refvarstart, int frame_s) {
        if (this.getActualSequenceLength() >= refvarstart - frame_s + 5) {
            int start = refvarstart - frame_s + 2;
            return this.sequence.substring(start, start + 3);
        }
        return "";
    }

    public int getLengthOfIntron(int k) {
        if (k == 0) {
            return 0;
        }
        if (k >= this.exonCount) {
            return 0;
        }
        return this.exonStarts[k] - this.exonEnds[k - 1] - 1;
    }

    public int getLengthOfExon(int k) {
        return this.exonEnds[k] - this.exonStarts[k] + 1;
    }

    public int getExonStart(int k) {
        return this.exonStarts[k];
    }

    public int getExonEnd(int k) {
        return this.exonEnds[k];
    }

    public int[] getExonEnds() {
        return this.exonEnds;
    }

    public int[] getExonStarts() {
        return this.exonStarts;
    }

    public void setSequence(String seq) {
        this.sequence = seq;
    }

    public void setGeneID(int id) {
        this.geneID = id;
    }

    public int getGeneID() {
        return this.geneID;
    }

    public void setGeneSymbol(String sym) {
        this.geneSymbol = sym;
    }

    public void debugPrint() {
        int i;
        String chr = this.getChromosomeAsString();
        System.err.println(String.format("%s:%s [%s (%c)]", this.accession, this.geneSymbol, chr, Character.valueOf(this.strand)));
        System.err.println(String.format("txStart: %d; txEnd: %d; cdsStart: %d, cdsEnd: %d", this.txStart, this.txEnd, this.cdsStart, this.cdsEnd));
        System.err.println(String.format("rcdsStart: %d\tExon count: %d", this.rcdsStart, this.exonCount));
        System.err.println(String.format("mRNAlength: %d, cdslength: %d", this.mRNAlength, this.CDSlength));
        for (i = 0; i < this.exonStarts.length; ++i) {
            System.err.println(String.format("\tExon %d: %d - %d (%d nt)", i + 1, this.exonStarts[i], this.exonEnds[i], this.exonEnds[i] - this.exonStarts[i] + 1));
        }
        for (i = 0; i < this.sequence.length(); ++i) {
            if (i > 0 && i % 50 == 0) {
                System.err.println("  " + i);
            } else if (i > 0 && i % 10 == 0) {
                System.err.print(" ");
            }
            System.err.print(this.sequence.charAt(i));
        }
        System.err.println();
    }

    public void debugPrintCDS() {
        String chr = this.getChromosomeAsString();
        System.err.println(String.format("%s:%s [%s (%c)]", this.accession, this.geneSymbol, chr, Character.valueOf(this.strand)));
        System.err.println(String.format("txStart: %d; txEnd: %d; cdsStart: %d, cdsEnd: %d", this.txStart, this.txEnd, this.cdsStart, this.cdsEnd));
        System.err.println(String.format("rcdsStart: %d\tExon count: %d", this.rcdsStart, this.exonCount));
        System.err.println(String.format("mRNAlength: %d, cdslength: %d", this.mRNAlength, this.CDSlength));
        System.err.println("Coding sequence");
        int max = this.getCDSLength();
        int j = 0;
        for (int i = this.rcdsStart - 1; i < this.sequence.length() && j < max; ++i, ++j) {
            if (j > 0 && j % 50 == 0) {
                System.err.println("  " + j);
            } else if (j > 0 && j % 10 == 0) {
                System.err.print(" ");
            }
            System.err.print(this.sequence.charAt(i));
        }
        System.err.println();
    }

    public String getChromosomeAsString() {
        if (this.chromosome == 23) {
            return "chrX";
        }
        if (this.chromosome == 24) {
            return "chrY";
        }
        if (this.chromosome == 25) {
            return "chrM";
        }
        return String.format("chr%d", this.chromosome);
    }

    public String toString() {
        return String.format("%s[%s]:%s:%d-%d [%d exons]", this.getGeneSymbol(), this.getAccessionNumber(), this.getChromosomeAsString(), this.getTXStart(), this.getTXEnd(), this.getExonCount());
    }

    public int getDistanceToFivePrimeTerminuscDNA(int pos) {
        if (this.strand == '+') {
            return this.getDistance(pos, this.getTXStart());
        }
        return this.getDistance(pos, this.getTXEnd());
    }

    public int getDistanceToCDSstart(int pos) {
        if (!this.isCodingGene()) {
            return -1;
        }
        if (this.strand == '+') {
            return this.getDistance(pos, this.getCDSStart());
        }
        return this.getDistance(pos, this.getCDSEnd());
    }

    public int getDistanceToCDSend(int pos) {
        if (!this.isCodingGene()) {
            return -1;
        }
        if (this.strand == '+') {
            return this.getDistance(pos, this.getCDSEnd());
        }
        return this.getDistance(pos, this.getCDSStart());
    }

    private int getDistance(int a, int b) {
        if (a < this.getTXStart() | b < this.getTXStart()) {
            System.out.println(String.format("[WARNING] TXstart: %d\tTXend: %d\tPosA: %d\tPosB: %d", this.getTXStart(), this.getTXEnd(), a, b));
            return -2;
        }
        if (a > this.getTXEnd() | b > this.getTXEnd()) {
            return -3;
        }
        for (int i = 0; i < this.exonCount - 1; ++i) {
            if (a > this.exonEnds[i] & a < this.exonStarts[i + 1]) {
                return -4;
            }
            if (!(b > this.exonEnds[i] & b < this.exonStarts[i + 1])) continue;
            return -5;
        }
        if (a > b) {
            int c = a;
            a = b;
            b = c;
        }
        int cumlen = 0;
        for (int i = 0; i < this.exonCount; ++i) {
            if (a >= this.exonStarts[i]) {
                if (a > this.exonEnds[i]) continue;
                if (b <= this.exonEnds[i]) {
                    return b - a + 1;
                }
                cumlen = this.exonEnds[i] - a + 1;
                continue;
            }
            if (b <= this.exonEnds[i]) {
                return cumlen + b - this.exonStarts[i] + 1;
            }
            cumlen += this.exonEnds[i] - this.exonStarts[i] + 1;
        }
        return cumlen;
    }

    public Integer[] getChromosomalCoordinates(int start, int end) {
        if (start > end) {
            int c = start;
            start = end;
            end = c;
        }
        Integer[] chromCoord = null;
        ArrayList<Integer> chromCoordTemp = new ArrayList<Integer>();
        int cumlength = 0;
        if (this.isMinusStrand()) {
            int c = start;
            start = this.mRNAlength - end;
            end = this.mRNAlength - c;
        }
        for (int i = 0; i < this.exonCount; ++i) {
            int exonlength = this.exonEnds[i] - this.exonStarts[i] + 1;
            if (start > cumlength + exonlength) {
                cumlength += exonlength;
                continue;
            }
            chromCoordTemp.add(start - cumlength + this.exonStarts[i] - 1);
            if (end > cumlength + exonlength) {
                chromCoordTemp.add(this.exonEnds[i]);
                start = cumlength += exonlength;
                continue;
            }
            chromCoordTemp.add(end - cumlength + this.exonStarts[i] - 1);
            break;
        }
        chromCoord = chromCoordTemp.toArray(new Integer[0]);
        return chromCoord;
    }

    public int getRefPosition(int cpos) {
        if (cpos < this.txStart || cpos > this.txEnd) {
            return -1;
        }
        int refPos = 0;
        if (this.isPlusStrand()) {
            for (int i = 0; i < this.exonCount; ++i) {
                if (this.exonEnds[i] < cpos) {
                    refPos += this.exonEnds[i] - this.exonStarts[i] + 1;
                    continue;
                }
                if (this.exonStarts[i] <= cpos) {
                    return refPos + (cpos - this.exonStarts[i] + 1);
                }
                return -1;
            }
        } else {
            for (int i = this.exonCount - 1; i >= 0; --i) {
                if (this.exonStarts[i] > cpos) {
                    refPos += this.exonEnds[i] - this.exonStarts[i] + 1;
                    continue;
                }
                if (this.exonEnds[i] >= cpos) {
                    return refPos + (this.exonEnds[i] - cpos + 1);
                }
                return -1;
            }
        }
        return -1;
    }
}

