/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.exception.KGParseException;
import jannovar.reference.TranscriptModel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class TranscriptDataParser {
    protected String directory_path;
    protected HashMap<String, TranscriptModel> knownGeneMap = new HashMap();

    public TranscriptDataParser(String path) {
        this.directory_path = path.endsWith("/") ? path : path + "/";
    }

    public TranscriptDataParser(String dirpath, String proxyHost, String port) {
        this(dirpath);
        if (proxyHost == null) {
            return;
        }
        System.setProperty("proxySet", "true");
        if (proxyHost.startsWith("http://")) {
            proxyHost = proxyHost.substring(7);
        }
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", port);
    }

    public HashMap<String, TranscriptModel> getKnownGeneMap() {
        return this.knownGeneMap;
    }

    public ArrayList<TranscriptModel> getKnownGeneList() {
        ArrayList<TranscriptModel> lst = new ArrayList<TranscriptModel>(this.knownGeneMap.values());
        return lst;
    }

    protected BufferedReader getBufferedReaderFromFilePath(String path, boolean isGzip) throws IOException {
        BufferedReader br;
        FileInputStream fin = new FileInputStream(path);
        if (isGzip) {
            br = new BufferedReader(new InputStreamReader(new GZIPInputStream(fin)));
        } else {
            DataInputStream in = new DataInputStream(fin);
            br = new BufferedReader(new InputStreamReader(in));
        }
        return br;
    }

    protected void makeDirectoryIfNotExist() {
        File directory = new File(this.directory_path);
        if (directory.exists()) {
            System.err.println(String.format("Cowardly refusing to create directory \"%s\" since it already exists", this.directory_path));
        } else {
            directory.mkdir();
        }
    }

    public boolean download_file(String baseURL, String fname) throws KGParseException {
        String urlstring = baseURL + fname;
        String local_file_path = this.directory_path + fname;
        File f = new File(local_file_path);
        if (f.exists()) {
            System.out.println(String.format("[INFO] Timorously refusing to download file \"%s\" since it already exists", local_file_path));
            return false;
        }
        System.out.println("[INFO] Downloading: \"" + urlstring + "\"");
        int threshold = 0;
        int block = 250000;
        try {
            int bytesRead;
            URL url = new URL(urlstring);
            URLConnection urlc = url.openConnection();
            InputStream reader = urlc.getInputStream();
            FileOutputStream writer = new FileOutputStream(local_file_path);
            byte[] buffer = new byte[153600];
            int totalBytesRead = 0;
            int size = urlc.getContentLength();
            if (size >= 0) {
                block = size / 20;
            }
            System.out.println("0%       50%      100%");
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
                if ((totalBytesRead += bytesRead) <= threshold) continue;
                System.out.print("=");
                threshold += block;
            }
            System.out.println();
            System.out.println("[INFO] Done. " + new Integer(totalBytesRead).toString() + "(" + size + ") bytes read.");
            writer.close();
            reader.close();
        }
        catch (MalformedURLException e) {
            String err = String.format("Could not interpret url: \"%s\"\n%s", urlstring, e.toString());
            throw new KGParseException(err);
        }
        catch (IOException e) {
            String err = String.format("IO Exception reading from URL: \"%s\"\n%s", urlstring, e.toString());
            throw new KGParseException(err);
        }
        return true;
    }
}

