/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.common.Constants;
import jannovar.exception.JannovarException;
import jannovar.exception.KGParseException;
import jannovar.io.TranscriptDataParser;
import jannovar.reference.TranscriptModel;

public class RefSeqParser
extends TranscriptDataParser
implements Constants {
    public static final int NFIELDS = 11;
    private static final String hg19base = "http://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/";
    private static final String refFlat = "refFlat.txt";

    public RefSeqParser(String path) {
        super(path);
    }

    public void parseRefFlatFile() {
    }

    public void downloadFiles() throws JannovarException {
        this.makeDirectoryIfNotExist();
        String refFlatCompressed = String.format("%s.gz", refFlat);
        this.download_file(hg19base, refFlatCompressed);
    }

    public TranscriptModel parseTranscriptModelFromLine(String line) throws KGParseException {
        int i;
        int exonCount;
        int cdsEnd;
        int cdsStart;
        int txEnd;
        int txStart;
        int chromosome;
        TranscriptModel model = TranscriptModel.createTranscriptModel();
        String[] A = line.split("\t");
        if (A.length != 11) {
            String error = String.format("Malformed line in UCSC knownGene.txt file:\n%s\nExpected %d fields but there were %d", line, 11, A.length);
            throw new KGParseException(error);
        }
        model.setGeneSymbol(A[0]);
        model.setAccessionNumber(A[1]);
        try {
            if (A[2].equals("chrX")) {
                chromosome = 23;
            } else if (A[2].equals("chrY")) {
                chromosome = 24;
            } else if (A[2].equals("chrM")) {
                chromosome = 25;
            } else {
                String tmp = A[2].substring(3);
                chromosome = Byte.parseByte(tmp);
            }
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse chromosome field: " + A[1]);
        }
        model.setChromosome((byte)chromosome);
        char strand = A[3].charAt(0);
        if (strand != '+' && strand != '-') {
            throw new KGParseException("Malformed strand: " + A[2]);
        }
        model.setStrand(strand);
        try {
            txStart = Integer.parseInt(A[4]) + 1;
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse txStart:" + A[4]);
        }
        model.setTranscriptionStart(txStart);
        try {
            txEnd = Integer.parseInt(A[5]);
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse txEnd:" + A[5]);
        }
        model.setTranscriptionEnd(txEnd);
        try {
            cdsStart = Integer.parseInt(A[6]) + 1;
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse cdsStart:" + A[6]);
        }
        model.setCdsStart(cdsStart);
        try {
            cdsEnd = Integer.parseInt(A[7]);
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse cdsEnd:" + A[7]);
        }
        model.setCdsEnd(cdsEnd);
        try {
            exonCount = Byte.parseByte(A[8]);
        }
        catch (NumberFormatException e) {
            throw new KGParseException("Could not parse exonCount:" + A[8]);
        }
        model.setExonCount((short)exonCount);
        int[] exonStarts = new int[exonCount];
        int[] exonEnds = new int[exonCount];
        String starts = A[9];
        String ends = A[10];
        String[] B = starts.split(",");
        if (B.length != exonCount) {
            String error = String.format("[RefSeqParser] Malformed exonStarts list: found %d but I expected %d exons", B.length, (byte)exonCount);
            error = String.format("%s. This should never happen, the refFlat.txt file may be corrupted", error);
            throw new KGParseException(error);
        }
        for (i = 0; i < exonCount; ++i) {
            try {
                exonStarts[i] = Integer.parseInt(B[i]) + 1;
                continue;
            }
            catch (NumberFormatException e) {
                String error = String.format("[UCSCKGParser] Malformed exon start at position %d of line %s", i, starts);
                error = String.format("%s. This should never happen, the knownGene.txt file may be corrupted", error);
                throw new KGParseException(error);
            }
        }
        B = ends.split(",");
        for (i = 0; i < exonCount; ++i) {
            try {
                exonEnds[i] = Integer.parseInt(B[i]);
                continue;
            }
            catch (NumberFormatException e) {
                String error = String.format("[UCSCKGParser] Malformed exon end at position %d of line %s", i, ends);
                error = String.format("%s. This should never happen, the knownGene.txt file may be corrupted", error);
                throw new KGParseException(error);
            }
        }
        model.setExonStartsAndEnds(exonStarts, exonEnds);
        model.initialize();
        return model;
    }
}

