/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.reference.TranscriptModel;
import jannovar.reference.Translator;

public class DeletionAnnotation {
    public static Annotation getAnnotationSingleNucleotide(TranscriptModel kgl, int frame_s, String wtnt3, String wtnt3_after, String ref, String var, int refvarstart, int exonNumber) throws AnnotationException {
        Object annotation = null;
        Translator translator = Translator.getTranslator();
        int posVariantInCDS = refvarstart - kgl.getRefCDSStart() + 1;
        int aavarpos = (int)Math.floor(posVariantInCDS / 3) + 1;
        if (wtnt3_after == null || wtnt3_after.length() < 3) {
            String canno = String.format("%s:exon%d:c.%ddel%s", kgl.getName(), exonNumber, posVariantInCDS, ref);
            Annotation ann = new Annotation(kgl, canno, VariantType.FS_DELETION, posVariantInCDS);
            return ann;
        }
        String varnt3 = frame_s == 1 ? String.format("%c%c%s", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(2)), Character.valueOf(wtnt3_after.charAt(0))) : (frame_s == 2 ? String.format("%c%c%s", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3_after.charAt(0))) : String.format("%c%c%s", Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2)), Character.valueOf(wtnt3_after.charAt(0))));
        String wtaa = translator.translateDNA(wtnt3);
        String varaa = translator.translateDNA(varnt3);
        String canno = String.format("c.%ddel%s", posVariantInCDS, ref);
        if (wtaa.equals("*")) {
            if (varaa.startsWith("*")) {
                String nfsdel_ann = String.format("%s:exon%d:%s:p.X%dX", kgl.getName(), exonNumber, canno, aavarpos);
                Annotation ann = new Annotation(kgl, nfsdel_ann, VariantType.NON_FS_DELETION, posVariantInCDS);
                return ann;
            }
            String stoploss_ann = String.format("%s:exon%d:%s:p.X%d%s", kgl.getName(), exonNumber, canno, aavarpos, varaa);
            Annotation ann = new Annotation(kgl, stoploss_ann, VariantType.STOPLOSS, posVariantInCDS);
            return ann;
        }
        if (varaa.contains("*")) {
            String stopgain_ann = String.format("%s:exon%d:%s:p.%s%dX", kgl.getName(), exonNumber, canno, wtaa, aavarpos);
            Annotation ann = new Annotation(kgl, stopgain_ann, VariantType.STOPGAIN, posVariantInCDS);
            return ann;
        }
        String fsdel_ann = String.format("%s:exon%d:%s:p.%s%dfs", kgl.getName(), exonNumber, canno, wtaa, aavarpos);
        Annotation ann = new Annotation(kgl, fsdel_ann, VariantType.FS_DELETION, posVariantInCDS);
        return ann;
    }

    public static Annotation getMultinucleotideDeletionAnnotation(TranscriptModel kgl, int frame_s, String wtnt3, String wtnt3_after, String ref, String var, int refvarstart, int refvarend, int exonNumber) throws AnnotationException {
        Object annotation = null;
        Translator translator = Translator.getTranslator();
        int deletedNT = 32;
        Object varnt3 = null;
        String canno = null;
        String panno = null;
        String wtaa = translator.translateDNA(wtnt3);
        int refcdsstart = kgl.getRefCDSStart();
        int cdslen = kgl.getCDSLength();
        int aavarpos = (int)Math.floor((refvarstart - kgl.getRefCDSStart()) / 3) + 1;
        int varposend = -1;
        int posVariantInCDS = refvarstart - kgl.getRefCDSStart();
        if (refvarstart <= refcdsstart) {
            if (refvarend >= cdslen + refcdsstart) {
                varposend = (int)Math.floor(cdslen / 3);
                canno = String.format("c.%d_%ddel", refvarstart - refcdsstart, cdslen + refcdsstart - 1);
            } else {
                varposend = (int)Math.floor((refvarend - refcdsstart) / 3) + 1;
                canno = String.format("c.1_%ddel", refvarend - refvarstart + 1);
            }
            panno = String.format("%s:exon%d:%s:p.%d_%ddel", kgl.getName(), exonNumber, canno, aavarpos, varposend);
            Annotation ann = new Annotation(kgl, panno, VariantType.FS_SUBSTITUTION, posVariantInCDS);
            return ann;
        }
        if (refvarend >= cdslen + refcdsstart) {
            varposend = (int)Math.floor(cdslen / 3);
            canno = String.format("c.%d_%ddel", refvarstart - refcdsstart + 1, cdslen + refcdsstart - 1);
            panno = String.format("%s:exon%d:%s:p.%d_%ddel", kgl.getName(), exonNumber, canno, aavarpos, varposend);
            Annotation ann = new Annotation(kgl, panno, VariantType.FS_SUBSTITUTION, posVariantInCDS);
            return ann;
        }
        if ((refvarend - refvarstart + 1) % 3 == 0) {
            varposend = (int)Math.floor((refvarend - refcdsstart) / 3) + 1;
            posVariantInCDS = refvarstart - refcdsstart + 1;
            canno = String.format("c.%d_%ddel", posVariantInCDS, refvarend - refcdsstart + 1);
            panno = String.format("%s:exon%d:%s:p.%d_%ddel", kgl.getName(), exonNumber, canno, aavarpos, varposend);
            Annotation ann = new Annotation(kgl, panno, VariantType.NON_FS_DELETION, posVariantInCDS);
            return ann;
        }
        int posMutationInCDS = refvarstart - refcdsstart + 1;
        canno = String.format("c.%d_%ddel", posMutationInCDS, refvarend - refcdsstart + 1);
        try {
            panno = DeletionAnnotation.shiftedFrameDeletion(kgl, exonNumber, canno, ref, posMutationInCDS, aavarpos, frame_s);
        }
        catch (AnnotationException e) {
            System.err.println("Exception while annotating frame-shift deletion: " + canno);
            panno = canno;
        }
        Annotation ann = new Annotation(kgl, panno, VariantType.FS_DELETION, posMutationInCDS);
        return ann;
    }

    private static String shiftedFrameDeletion(TranscriptModel trmdl, int exonNumber, String cDNAanno, String ref, int posMutationInCDS, int aaVarStartPos, int frame_s) throws AnnotationException {
        Translator translator = Translator.getTranslator();
        int len = ref.length();
        String orf = trmdl.getCodingSequencePlus3UTR();
        int start = posMutationInCDS - 1;
        int endpos = start + ref.length();
        String deletion = orf.substring(start, endpos);
        String prefix = orf.substring(start - frame_s, start);
        int restlen = orf.length() - endpos > 30 ? 30 : orf.length() - endpos;
        String rest = orf.substring(endpos, endpos + restlen);
        String wt = prefix + deletion + rest;
        String mut = prefix + rest;
        String wtaa = translator.translateDNA(wt);
        String mutaa = translator.translateDNA(mut);
        int aapos = aaVarStartPos;
        int endk = mutaa.length();
        for (int k = 0; k < endk; ++k) {
            if (wtaa.charAt(k) != mutaa.charAt(k)) {
                String annot = String.format("%s:exon%d:%s:p.%c%d%cfs", trmdl.getName(), exonNumber, cDNAanno, Character.valueOf(wtaa.charAt(k)), aapos, Character.valueOf(mutaa.charAt(k)));
                return annot;
            }
            ++aapos;
        }
        String annot = String.format("%s:exon%d:%s:p.%c%ddelins%c", trmdl.getName(), exonNumber, cDNAanno, Character.valueOf(wtaa.charAt(0)), aaVarStartPos, Character.valueOf(mutaa.charAt(0)));
        return annot;
    }
}

