/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class URLProtocolHandlerUtil {
    private static final String HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final Object FACTORY_LOCK = new Object();
    private static HandlerFactory _handlerFactory = null;

    public static void registerProtocolHandler(String protocol, URLStreamHandler handler) {
        if (_handlerFactory != null) {
            _handlerFactory.addHandler(protocol, handler);
        } else {
            URLProtocolHandlerUtil.registerAsSystemProperty(protocol, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerAsSystemProperty(String protocol, URLStreamHandler handler) {
        String protocolPkg;
        Package pack = handler.getClass().getPackage();
        if (pack == null) {
            throw new IllegalArgumentException("Class loader did not define a package for class " + handler.getClass().getName());
        }
        String pkg = pack.getName();
        if (!pkg.endsWith(protocolPkg = "." + protocol) || !handler.getClass().getSimpleName().equals("Handler")) {
            throw new IllegalArgumentException("Malformed handler class name '" + handler.getClass().getName() + "' for protocol '" + protocol + "'.  Should be " + "'<pkg>.<protocol>.Handler.");
        }
        pkg = pkg.substring(0, pkg.length() - protocolPkg.length());
        Object object = FACTORY_LOCK;
        synchronized (object) {
            String pkgProp = StringUtils.defaultString((String)System.getProperty(HANDLER_PKGS));
            ArrayList<String> packages = new ArrayList<String>();
            for (String oldPkg : pkgProp.split("\\|")) {
                if (StringUtils.isBlank((String)oldPkg)) continue;
                packages.add(oldPkg);
            }
            if (!packages.contains(pkg)) {
                packages.add(pkg);
                System.setProperty(HANDLER_PKGS, StringUtils.join(packages.iterator(), (String)"|"));
            }
        }
    }

    static {
        try {
            HandlerFactory tmpFactory = new HandlerFactory();
            URL.setURLStreamHandlerFactory(tmpFactory);
            _handlerFactory = tmpFactory;
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static class HandlerFactory
    implements URLStreamHandlerFactory {
        private final TreeMap<String, URLStreamHandler> _protocolMap = new TreeMap();

        HandlerFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addHandler(String protocol, URLStreamHandler handler) {
            Object object = FACTORY_LOCK;
            synchronized (object) {
                this._protocolMap.put(protocol, handler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol == null) {
                return null;
            }
            Object object = FACTORY_LOCK;
            synchronized (object) {
                return this._protocolMap.get(protocol);
            }
        }
    }
}

