/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.Reference;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.ReferenceManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class ReferenceManager
extends MedSavantServerUnicastRemoteObject
implements ReferenceManagerAdapter,
MedSavantDatabase.GeneSetColumns {
    private static ReferenceManager instance;

    public static synchronized ReferenceManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new ReferenceManager();
        }
        return instance;
    }

    @Override
    public Reference[] getReferences(String sessID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema table = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("reference_id"), table.getDBColumn("name"));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Reference> results = new ArrayList<Reference>();
        while (rs.next()) {
            results.add(new Reference(rs.getInt("reference_id"), rs.getString("name")));
        }
        return results.toArray(new Reference[0]);
    }

    @Override
    public String[] getReferenceNames(String sessID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema table = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("name"));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<String> results = new ArrayList<String>();
        while (rs.next()) {
            results.add(rs.getString(1));
        }
        return results.toArray(new String[0]);
    }

    @Override
    public int getReferenceID(String sessID, String refName) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema table = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("reference_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("name"), refName));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    @Override
    public boolean containsReference(String sessID, String refName) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema table = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("name"), refName));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        return rs.next();
    }

    @Override
    public int addReference(String sessID, String refName, Chromosome[] chroms, String url) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema referenceTable = MedSavantDatabase.ReferenceTableSchema;
        MedSavantDatabase.ChromosomeTableSchema chromTable = MedSavantDatabase.ChromosomeTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sessID);
        InsertQuery query1 = new InsertQuery(referenceTable.getTable());
        query1.addColumn(referenceTable.getDBColumn("name"), refName);
        query1.addColumn(referenceTable.getDBColumn("url"), url);
        PreparedStatement stmt = c.prepareStatement(query1.toString(), 1);
        stmt.execute();
        ResultSet rs = stmt.getGeneratedKeys();
        rs.next();
        int refID = rs.getInt(1);
        c.setAutoCommit(false);
        for (int i = 0; i < chroms.length; ++i) {
            Chromosome chrom = chroms[i];
            InsertQuery query = new InsertQuery(chromTable.getTable());
            query.addColumn(chromTable.getDBColumn("reference_id"), refID);
            query.addColumn(chromTable.getDBColumn("contig_id"), i);
            query.addColumn(chromTable.getDBColumn("contig_name"), chrom.getName());
            query.addColumn(chromTable.getDBColumn("contig_length"), chrom.getLength());
            query.addColumn(chromTable.getDBColumn("centromere_pos"), chrom.getCentromerePos());
            c.createStatement().executeUpdate(query.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
        return refID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeReference(String sessID, int refID) throws SQLException, SessionExpiredException {
        TableSchema annotationTable = MedSavantDatabase.AnnotationTableSchema;
        MedSavantDatabase.VariantTablemapTableSchema variantMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        MedSavantDatabase.ChromosomeTableSchema chromTable = MedSavantDatabase.ChromosomeTableSchema;
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            SelectQuery q1 = new SelectQuery();
            q1.addFromTable(annotationTable.getTable());
            q1.addAllColumns();
            q1.addCondition(BinaryConditionMS.equalTo(annotationTable.getDBColumn(MedSavantDatabase.AnnotationColumns.REFERENCE_ID), refID));
            ResultSet rs = conn.executeQuery(q1.toString());
            if (rs.next()) {
                boolean bl = false;
                return bl;
            }
            SelectQuery q2 = new SelectQuery();
            q2.addFromTable(variantMapTable.getTable());
            q2.addAllColumns();
            q2.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("reference_id"), refID));
            rs = conn.executeQuery(q2.toString());
            if (rs.next()) {
                boolean bl = false;
                return bl;
            }
            DeleteQuery q3 = new DeleteQuery(refTable.getTable());
            q3.addCondition(BinaryConditionMS.equalTo(refTable.getDBColumn("reference_id"), refID));
            conn.executeUpdate(q3.toString());
            DeleteQuery q4 = new DeleteQuery(chromTable.getTable());
            q4.addCondition(BinaryConditionMS.equalTo(chromTable.getDBColumn("reference_id"), refID));
            conn.executeUpdate(q4.toString());
        }
        finally {
            conn.close();
        }
        return true;
    }

    @Override
    public String getReferenceUrl(String sid, int referenceid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(refTable.getTable());
        query.addColumns(refTable.getDBColumn("url"));
        query.addCondition(BinaryConditionMS.equalTo(refTable.getDBColumn("reference_id"), referenceid));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        return rs.getString(1);
    }

    @Override
    public Chromosome[] getChromosomes(String sid, int referenceid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ChromosomeTableSchema table = MedSavantDatabase.ChromosomeTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), referenceid));
        query.addOrdering(table.getDBColumn("contig_id"), OrderObject.Dir.ASCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Chromosome> result = new ArrayList<Chromosome>();
        while (rs.next()) {
            result.add(new Chromosome(rs.getString("contig_name"), rs.getInt("centromere_pos"), rs.getInt("contig_length")));
        }
        return result.toArray(new Chromosome[0]);
    }

    public String getReferenceName(String sid, int refID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(refTable.getTable());
        query.addColumns(refTable.getDBColumn("name"));
        query.addCondition(BinaryConditionMS.equalTo(refTable.getDBColumn("reference_id"), refID));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        return rs.getString(1);
    }
}

