/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.shared.serverapi.NetworkManagerAdapter;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class NetworkManager
extends MedSavantServerUnicastRemoteObject
implements NetworkManagerAdapter {
    private static final Log LOG = LogFactory.getLog(NetworkManager.class);
    private static NetworkManager instance;
    private int counter = 0;
    private final HashMap<String, InboundStreamInfo> inboundMap = new HashMap();
    private final HashMap<String, OutboundStreamInfo> outboundMap = new HashMap();
    private byte[] outboundBuffer = new byte[65536];

    public static synchronized NetworkManager getInstance() throws RemoteException {
        if (instance == null) {
            instance = new NetworkManager();
        }
        return instance;
    }

    private NetworkManager() throws RemoteException {
    }

    @Override
    public int openWriterOnServer(String sessID, String name, long fileLen) throws IOException {
        int transferID = this.counter++;
        LOG.info((Object)("Opening writer on server, transfer ID is " + transferID));
        String fileName = new File(name).getName();
        File parentDir = DirectorySettings.getTmpDirectory();
        File outFile = new File(parentDir, fileName);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            String s = "Cannot write file " + outFile.getAbsolutePath() + " because parent directories could not be created";
            LOG.error((Object)s);
            throw new IOException(s);
        }
        int i = 0;
        while (outFile.exists()) {
            String incrementedFn = ++i + "-" + fileName;
            outFile = new File(DirectorySettings.getTmpDirectory(), incrementedFn);
        }
        outFile.createNewFile();
        if (!outFile.canWrite()) {
            String s = "Cannot write to file " + outFile.getAbsolutePath();
            LOG.error((Object)s);
            throw new IOException(s);
        }
        this.inboundMap.put(sessID + transferID, new InboundStreamInfo(outFile, name, fileLen));
        LOG.info((Object)("File will transfer to " + outFile.getAbsolutePath()));
        return transferID;
    }

    @Override
    public void writeToServer(String sessID, int transferID, byte[] buf) throws IOException, InterruptedException {
        InboundStreamInfo info = this.inboundMap.get(sessID + transferID);
        try {
            info.stream.write(buf);
            info.bytesWritten += (long)buf.length;
            this.makeProgress(sessID, String.format("Uploading %s to server...", info.sourceName), (double)info.bytesWritten / (double)info.length);
        }
        catch (IOException iex) {
            try {
                info.stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            info.stream = null;
            info.file.delete();
            throw iex;
        }
    }

    @Override
    public void closeWriterOnServer(String sessID, int transferID) throws IOException {
        InboundStreamInfo info = this.inboundMap.get(sessID + transferID);
        info.stream.close();
        info.stream = null;
        LOG.info((Object)("Closed transfer with ID " + transferID));
    }

    public File getFileByTransferID(String sessID, int transferID) {
        for (String key : this.inboundMap.keySet()) {
            LOG.info((Object)("\t" + key + " " + this.inboundMap.get((Object)key).file.getAbsolutePath()));
        }
        LOG.info((Object)("Looking up file with ID " + sessID + transferID));
        return this.inboundMap.get((Object)new StringBuilder().append((String)sessID).append((int)transferID).toString()).file;
    }

    public String getSourceNameByTransferID(String sessID, int transferID) {
        return this.inboundMap.get((Object)new StringBuilder().append((String)sessID).append((int)transferID).toString()).sourceName;
    }

    public int openReaderOnServer(String sessID, File f) throws IOException {
        int transferID = this.counter++;
        this.outboundMap.put(sessID + transferID, new OutboundStreamInfo(f));
        return transferID;
    }

    @Override
    public byte[] readFromServer(String sessID, int transferID) throws IOException, InterruptedException {
        OutboundStreamInfo info = this.outboundMap.get(sessID + transferID);
        int numBytes = info.stream.available();
        if (numBytes > 0) {
            if (numBytes != this.outboundBuffer.length) {
                this.outboundBuffer = new byte[numBytes];
            }
            info.stream.read(this.outboundBuffer);
            info.bytesRead += (long)this.outboundBuffer.length;
            this.makeProgress(sessID, "Downloading from server...", (double)info.bytesRead / (double)info.length);
            return this.outboundBuffer;
        }
        return null;
    }

    private void deleteEmptyParents(File p) throws IOException {
        IOUtils.deleteEmptyParents(p, DirectorySettings.getTmpDirectory());
    }

    @Override
    public void closeReaderOnServer(String sessID, int transferID) throws IOException {
        OutboundStreamInfo info = this.outboundMap.remove(sessID + transferID);
        info.stream.close();
        File parent = info.file.getParentFile();
        info.file.delete();
        this.deleteEmptyParents(parent);
    }

    private class OutboundStreamInfo {
        final File file;
        final long length;
        InputStream stream;
        long bytesRead = 0L;

        OutboundStreamInfo(File f) throws FileNotFoundException {
            this.file = f;
            this.length = f.length();
            this.stream = new FileInputStream(f);
        }
    }

    private class InboundStreamInfo {
        final File file;
        final String sourceName;
        final long length;
        OutputStream stream;
        long bytesWritten = 0L;

        InboundStreamInfo(File f, String name, long len) throws FileNotFoundException {
            this.file = f;
            this.sourceName = name;
            this.length = len;
            this.stream = new FileOutputStream(f);
        }
    }
}

