/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class TSVFile {
    private final Log LOG = LogFactory.getLog(TSVFile.class);
    private File file;
    private final int numLines;

    public TSVFile(File f, int numLines) {
        this.file = f;
        this.numLines = numLines;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public File getFile() {
        return this.file;
    }

    public TSVFile moveTo(File dst) {
        File f = this.getFile();
        this.LOG.info((Object)("Renaming " + f.getAbsolutePath() + " to " + dst.getAbsolutePath()));
        if (!IOUtils.moveFile(f, dst)) {
            this.LOG.error((Object)("Couldn't rename " + f.getAbsolutePath() + " to " + dst.getAbsolutePath()));
        }
        this.file = dst;
        return this;
    }
}

