/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.util;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import com.mysql.jdbc.CommunicationsException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.db.util.DistinctValuesCache;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.DBUtilsAdapter;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class DBUtils
extends MedSavantServerUnicastRemoteObject
implements DBUtilsAdapter {
    private static final Log LOG = LogFactory.getLog(DBUtils.class);
    private static DBUtils instance;

    public static synchronized DBUtils getInstance() throws RemoteException {
        if (instance == null) {
            instance = new DBUtils();
        }
        return instance;
    }

    private DBUtils() throws RemoteException {
    }

    private static File getTemporaryDatabaseFile() throws IOException {
        int i = 0;
        File f = new File(DirectorySettings.getDatabaseWorkingDir(), "0_tmp.txt");
        while (f.exists()) {
            f = new File(DirectorySettings.getDatabaseWorkingDir(), ++i + "_tmp.txt");
        }
        return f;
    }

    public static void copyQueryResultToNewTable(String sid, Query sq, String dstTable) throws RemoteException, SessionExpiredException, IOException, SQLException {
        DBUtils.copyQueryResultToNewTable(sid, sq, dstTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyQueryResultToNewTable(String sid, Query sq, String dstTable, MedSavantServerJob parent) throws IOException, SQLException, SessionExpiredException {
        File f = DBUtils.getTemporaryDatabaseFile();
        try {
            String intoString = "INTO OUTFILE \"" + f.getAbsolutePath().replaceAll("\\\\", "/") + "\" " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)"\t") + "' " + "ENCLOSED BY '" + "\"" + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)"\\") + "' " + " LINES TERMINATED BY '\\r\\n' ";
            String queryString = sq instanceof UnionQuery ? sq.toString() + " " + intoString : sq.toString().replace("FROM", intoString + "FROM");
            LOG.info((Object)queryString);
            ConnectionController.executeQuery(sid, queryString);
            DBUtils.loadTable(sid, f, dstTable);
            LOG.info((Object)"Query result copied!");
        }
        finally {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyQueryResultToNewTable(String sid, String query, String dstTable, MedSavantServerJob parent) throws IOException, SQLException, SessionExpiredException {
        File f = DBUtils.getTemporaryDatabaseFile();
        try {
            String intoString = "INTO OUTFILE \"" + f.getAbsolutePath().replaceAll("\\\\", "/") + "\" " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)"\t") + "' " + "ENCLOSED BY '" + "\"" + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)"\\") + "' " + " LINES TERMINATED BY '\\r\\n' ";
            String queryString = query + " " + intoString;
            LOG.info((Object)queryString);
            ConnectionController.executeQuery(sid, queryString);
            DBUtils.loadTable(sid, f, dstTable);
            LOG.info((Object)"Query result copied!");
        }
        finally {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getCurrentDatabaseTime(String sessID) throws SQLException, SessionExpiredException {
        ResultSet rs = null;
        try {
            rs = ConnectionController.executeQuery(sessID, "SELECT NOW()+0");
            Date currentDate = null;
            if (rs.next()) {
                currentDate = new Date(rs.getTimestamp(1).getTime());
            }
            Date date = currentDate;
            return date;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static boolean fieldExists(String sid, String tableName, String fieldName) throws SQLException, SessionExpiredException {
        ResultSet rs = ConnectionController.executeQuery(sid, "SHOW COLUMNS IN " + tableName);
        while (rs.next()) {
            if (!rs.getString(1).equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static String getColumnTypeString(String s) {
        int pos = s.indexOf("(");
        if (pos == -1) {
            return s;
        }
        return s.substring(0, pos);
    }

    public DbTable importTable(String sessionId, String tablename) throws SQLException, SessionExpiredException {
        DbSpec spec = new DbSpec();
        DbSchema schema = spec.addDefaultSchema();
        DbTable table = schema.addTable(tablename);
        ResultSet rs = ConnectionController.executeQuery(sessionId, "DESCRIBE " + tablename);
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int numberOfColumns = rsMetaData.getColumnCount();
        while (rs.next()) {
            int[] ls = CustomField.extractColumnLengthAndScale(rs.getString(2));
            table.addColumn(rs.getString(1), DBUtils.getColumnTypeString(rs.getString(2)), (Integer)ls[0], ls[1] > 0 ? Integer.valueOf(ls[1]) : null);
        }
        return table;
    }

    @Override
    public TableSchema importTableSchema(String sessionId, String tablename) throws SQLException, SessionExpiredException {
        DbSpec spec = new DbSpec();
        DbSchema schema = spec.addDefaultSchema();
        DbTable table = schema.addTable(tablename);
        TableSchema ts = new TableSchema(table);
        LOG.info((Object)String.format("Executing %s on %s...", "DESCRIBE " + tablename, sessionId));
        ResultSet rs = ConnectionController.executeQuery(sessionId, "DESCRIBE " + tablename);
        while (rs.next()) {
            int[] ls = CustomField.extractColumnLengthAndScale(rs.getString(2));
            table.addColumn(rs.getString(1), DBUtils.getColumnTypeString(rs.getString(2)), (Integer)ls[0], ls[1] == 0 ? null : Integer.valueOf(ls[1]));
            ts.addColumn(rs.getString(1), ColumnType.fromString(DBUtils.getColumnTypeString(rs.getString(2))), ls[0], ls[1]);
        }
        return ts;
    }

    public static void dumpTable(String sessID, String tableName, File dst) throws SQLException, SessionExpiredException {
        String intoString = "INTO OUTFILE \"" + dst.getAbsolutePath().replaceAll("\\\\", "/") + "\" " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)"\t") + "' " + "ENCLOSED BY '" + "\"" + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)"\\") + "' " + " LINES TERMINATED BY '\\r\\n' ";
        String query = "SELECT * FROM " + tableName + " " + intoString;
        ConnectionController.executeQuery(sessID, query);
    }

    public static void loadTable(String sessID, File src, String dst) throws SQLException, SessionExpiredException {
        String query = "LOAD DATA LOCAL INFILE '" + src.getAbsolutePath().replaceAll("\\\\", "/") + "' " + "INTO TABLE " + dst + " " + "FIELDS TERMINATED BY '" + "\t" + "' ENCLOSED BY '" + "\"" + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)"\\") + "' " + " LINES TERMINATED BY '\\r\\n'" + ";";
        LOG.info((Object)query);
        ConnectionController.executeQuery(sessID, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTable(String sessID, String srcTableName, String dstTableName) throws IOException, SQLException, SessionExpiredException {
        File tmp = null;
        try {
            File parent;
            int i = 0;
            while ((tmp = new File(parent = DirectorySettings.getDatabaseWorkingDir(), "tmpfile_" + i++)).exists()) {
            }
            LOG.info((Object)("Copying table " + srcTableName + " to " + dstTableName + " by dumping and reloading..."));
            LOG.info((Object)("Dumping " + srcTableName + " to file " + tmp.getAbsolutePath()));
            DBUtils.dumpTable(sessID, srcTableName, tmp);
            LOG.info((Object)("Loading " + tmp.getAbsolutePath() + " into " + dstTableName));
            DBUtils.loadTable(sessID, tmp, dstTableName);
        }
        finally {
            if (tmp != null && tmp.exists()) {
                tmp.delete();
            }
        }
    }

    public static void dropTable(String sessID, String tableName) throws SQLException, SessionExpiredException {
        ConnectionController.executeUpdate(sessID, "DROP TABLE IF EXISTS " + tableName + ";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String sessID, String tableName) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            boolean bl = conn.tableExists(tableName);
            return bl;
        }
        finally {
            conn.close();
        }
    }

    @Override
    public int getNumRecordsInTable(String sessID, String tablename) throws SQLException, SessionExpiredException {
        ResultSet rs = ConnectionController.executeQuery(sessID, "SELECT COUNT(*) FROM `" + tablename + "`");
        rs.next();
        return rs.getInt(1);
    }

    public static String extractMySQLMessage(CommunicationsException x) {
        String key = "\nMESSAGE: ";
        String msg = x.getMessage();
        int startPos = msg.indexOf(key);
        if (startPos >= 0) {
            int endPos = msg.indexOf(10, startPos += key.length());
            return msg.substring(startPos, endPos);
        }
        return msg;
    }

    public static String getMessage(Throwable t) {
        if (t instanceof CommunicationsException) {
            String result = t.getMessage();
            int retPos = result.indexOf(10);
            if (retPos > 0) {
                result = result.substring(0, retPos);
                result = result + DBUtils.extractMySQLMessage((CommunicationsException)t);
            }
            return result;
        }
        return MiscUtils.getMessage(t);
    }

    @Override
    public List<String> getDistinctValuesForColumn(String sessID, String tableName, String colName, boolean cacheing) throws InterruptedException, SQLException, RemoteException, SessionExpiredException {
        return this.getDistinctValuesForColumn(sessID, tableName, colName, false, cacheing);
    }

    @Override
    public List<String> getDistinctValuesForColumn(String sessID, String tableName, String colName, boolean explodeColonSeparatedValues, boolean cacheing) throws InterruptedException, SQLException, RemoteException, SessionExpiredException {
        LOG.info((Object)("Getting distinct values for " + tableName + "." + colName));
        this.makeProgress(sessID, String.format("Retrieving distinct values for %s...", colName), 0.0);
        String dbName = SessionManager.getInstance().getDatabaseForSession(sessID);
        if (cacheing && DistinctValuesCache.isCached(dbName, tableName, colName)) {
            try {
                this.makeProgress(sessID, "Using cached values...", 1.0);
                return DistinctValuesCache.getCachedStringList(dbName, tableName, colName);
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to get cached distinct values for " + dbName + "/" + tableName + "/" + colName), (Throwable)ex);
            }
        }
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tableName);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.setIsDistinct(true);
        query.addColumns(table.getDBColumn(colName));
        this.makeProgress(sessID, "Querying database...", 0.2);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString() + (cacheing ? " LIMIT 10000" : ""));
        HashSet<String> set = new HashSet<String>();
        while (rs.next()) {
            this.makeProgress(sessID, String.format("Retrieving distinct values for %s...", colName), 0.75);
            String val = rs.getString(1);
            if (val == null) {
                set.add("");
                continue;
            }
            if (explodeColonSeparatedValues) {
                String[] vals = val.split(";");
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = vals[i].trim();
                }
                set.addAll(Arrays.asList(vals));
                continue;
            }
            set.add(val);
        }
        ArrayList<String> result = new ArrayList<String>(set);
        Collections.sort(result);
        if (cacheing) {
            this.makeProgress(sessID, "Saving cached values...", 0.9);
            if (result.size() == 10000) {
                DistinctValuesCache.cacheResults(dbName, tableName, colName, null);
                result = null;
            } else {
                DistinctValuesCache.cacheResults(dbName, tableName, colName, result);
            }
        }
        return result;
    }

    @Override
    public Range getExtremeValuesForColumn(String sessID, String tabName, String colName) throws InterruptedException, SQLException, RemoteException, SessionExpiredException {
        LOG.info((Object)("Getting extreme values for " + tabName + "." + colName));
        this.makeProgress(sessID, String.format("Retrieving extreme values for %s...", colName), 0.0);
        String dbName = SessionManager.getInstance().getDatabaseForSession(sessID);
        if (DistinctValuesCache.isCached(dbName, tabName, colName)) {
            try {
                Range result = DistinctValuesCache.getCachedRange(dbName, tabName, colName);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to get cached extreme values for " + dbName + "/" + tabName + "/" + colName), (Throwable)ex);
            }
        }
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tabName);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addCustomColumns(FunctionCall.min().addColumnParams(table.getDBColumn(colName)));
        query.addCustomColumns(FunctionCall.max().addColumnParams(table.getDBColumn(colName)));
        this.makeProgress(sessID, "Querying database...", 0.2);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        rs.next();
        double min = rs.getDouble(1);
        double max = rs.getDouble(2);
        Range result = new Range(min, max);
        this.makeProgress(sessID, "Saving cached values...", 0.9);
        DistinctValuesCache.cacheResults(dbName, tabName, colName, Arrays.asList(min, max));
        return result;
    }

    @Override
    public Condition getRangeCondition(DbColumn col, Range r) {
        Condition[] results = new Condition[]{BinaryCondition.greaterThan(col, r.getMin(), true), BinaryCondition.lessThan(col, r.getMax(), false)};
        return ComboCondition.and(results);
    }
}

