/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db;

import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import org.ut.biolab.medsavant.shared.db.ColumnDef;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.db.TableSchema;

public class MedSavantDatabase {
    public static final DbSchema schema = new DbSpec().addDefaultSchema();
    public static final TableSchema AnnotationTableSchema = new TableSchema(schema, "annotation", AnnotationColumns.class);
    public static final TableSchema AnnotationFormatTableSchema = new TableSchema(schema, "annotation_format", AnnotationFormatColumns.class);
    public static final ChromosomeTableSchema ChromosomeTableSchema = new ChromosomeTableSchema(schema);
    public static final CohortTableSchema CohortTableSchema = new CohortTableSchema(schema);
    public static final CohortMembershipTableSchema CohortmembershipTableSchema = new CohortMembershipTableSchema(schema);
    public static final TableSchema GeneSetTableSchema = new TableSchema(schema, "genes", GeneSetColumns.class);
    public static final TableSchema OntologyInfoTableSchema = new TableSchema(schema, "ontology_info", OntologyInfoColumns.class);
    public static final TableSchema OntologyTableSchema = new TableSchema(schema, "ontology", OntologyColumns.class);
    public static final PatientFormatTableSchema PatientformatTableSchema = new PatientFormatTableSchema(schema);
    public static final PatientTablemapTableSchema PatienttablemapTableSchema = new PatientTablemapTableSchema(schema);
    public static final ProjectTableSchema ProjectTableSchema = new ProjectTableSchema(schema);
    public static final ReferenceTableSchema ReferenceTableSchema = new ReferenceTableSchema(schema);
    public static final TableSchema RegionSetTableSchema = new TableSchema(schema, "region_set", RegionSetColumns.class);
    public static final TableSchema RegionSetMembershipTableSchema = new TableSchema(schema, "region_set_membership", RegionSetMembershipColumns.class);
    public static final ServerLogTableSchema ServerlogTableSchema = new ServerLogTableSchema(schema);
    public static final SettingsTableSchema SettingsTableSchema = new SettingsTableSchema(schema);
    public static final VariantPendingUpdateTableSchema VariantpendingupdateTableSchema = new VariantPendingUpdateTableSchema(schema);
    public static final VariantTablemapTableSchema VarianttablemapTableSchema = new VariantTablemapTableSchema(schema);
    public static final VariantFormatTableSchema VariantformatTableSchema = new VariantFormatTableSchema(schema);
    public static final TableSchema VariantTagTableSchema = new TableSchema(schema, "variant_tag", VariantTagColumns.class);
    public static final VariantStarredTableSchema VariantStarredTableSchema = new VariantStarredTableSchema(schema);
    public static final VariantFileTableSchema VariantFileTableSchema = new VariantFileTableSchema(schema);
    public static final VariantFileTableSchema VariantFileIBTableSchema = new VariantFileTableSchema(schema, "_ib");
    public static final UserCommentGroupTableSchema UserCommentGroupTableSchema = new UserCommentGroupTableSchema(schema);
    public static final UserCommentTableSchema UserCommentTableSchema = new UserCommentTableSchema(schema);
    public static final UserRoleTableSchema UserRoleTableSchema = new UserRoleTableSchema(schema);
    public static final UserRoleAssignmentTableSchema UserRoleAssignmentTableSchema = new UserRoleAssignmentTableSchema(schema);

    public static class VariantFileTableSchema
    extends TableSchema {
        public static final String TABLE_NAME_PREFIX = "variant_file";
        public static final int INDEX_OF_UPLOAD_ID = 0;
        public static final ColumnType TYPE_OF_UPLOAD_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_UPLOAD_ID = 11;
        public static final String COLUMNNAME_OF_UPLOAD_ID = "upload_id";
        public static final int INDEX_OF_FILE_ID = 1;
        public static final ColumnType TYPE_OF_FILE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_FILE_ID = 11;
        public static final String COLUMNNAME_OF_FILE_ID = "file_id";
        public static final int INDEX_OF_PROJECT_ID = 1;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 1;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_FILE_NAME = 2;
        public static final ColumnType TYPE_OF_FILE_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_FILE_NAME = 500;
        public static final String COLUMNNAME_OF_FILE_NAME = "file_name";

        public VariantFileTableSchema(DbSchema s) {
            this(s, "");
        }

        public VariantFileTableSchema(DbSchema s, String suffix) {
            super(s.addTable(TABLE_NAME_PREFIX + suffix));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_UPLOAD_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_FILE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_FILE_NAME, ColumnType.VARCHAR, 500);
        }
    }

    public static class VariantStarredTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "variant_starred";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 1;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_UPLOAD_ID = 2;
        public static final ColumnType TYPE_OF_UPLOAD_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_UPLOAD_ID = 11;
        public static final String COLUMNNAME_OF_UPLOAD_ID = "upload_id";
        public static final int INDEX_OF_FILE_ID = 3;
        public static final ColumnType TYPE_OF_FILE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_FILE_ID = 11;
        public static final String COLUMNNAME_OF_FILE_ID = "file_id";
        public static final int INDEX_OF_VARIANT_ID = 4;
        public static final ColumnType TYPE_OF_VARIANT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_VARIANT_ID = 11;
        public static final String COLUMNNAME_OF_VARIANT_ID = "variant_id";
        public static final int INDEX_OF_USER = 5;
        public static final ColumnType TYPE_OF_USER = ColumnType.VARCHAR;
        public static final int LENGTH_OF_USER = 200;
        public static final String COLUMNNAME_OF_USER = "user";
        public static final int INDEX_OF_DESCRIPTION = 6;
        public static final ColumnType TYPE_OF_DESCRIPTION = ColumnType.VARCHAR;
        public static final int LENGTH_OF_DESCRIPTION = 500;
        public static final String COLUMNNAME_OF_DESCRIPTION = "description";
        public static final int INDEX_OF_TIMESTAMP = 7;
        public static final ColumnType TYPE_OF_TIMESTAMP = ColumnType.DATE;
        public static final int LENGTH_OF_TIMESTAMP = -1;
        public static final String COLUMNNAME_OF_TIMESTAMP = "timestamp";

        public VariantStarredTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_UPLOAD_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_FILE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_VARIANT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_USER, ColumnType.VARCHAR, 200);
            this.addColumn(COLUMNNAME_OF_DESCRIPTION, ColumnType.VARCHAR, 500);
            this.addColumn(COLUMNNAME_OF_TIMESTAMP, ColumnType.DATE, -1);
        }
    }

    public static class UserCommentTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "user_comment";
        public static final int INDEX_OF_USER_COMMENT_ID = 0;
        public static final ColumnType TYPE_OF_USER_COMMENT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_USER_COMMENT_ID = 11;
        public static final String COLUMNNAME_OF_USER_COMMENT_ID = "user_comment_id";
        public static final int INDEX_OF_USER_COMMENT_GROUP_ID = 1;
        public static final ColumnType TYPE_OF_USER_COMMENT_GROUP_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_USER_COMMENT_GROUP_ID = 11;
        public static final String COLUMNNAME_OF_USER_COMMENT_GROUP_ID = "fk_user_comment_group_id";
        public static final int INDEX_OF_PARENT_USER_COMMENT_ID = 2;
        public static final ColumnType TYPE_OF_PARENT_USER_COMMENT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PARENT_USER_COMMENT_ID = 11;
        public static final String COLUMNNAME_OF_PARENT_USER_COMMENT_ID = "fk_parent_user_comment_id";
        public static final int INDEX_OF_USER = 3;
        public static final ColumnType TYPE_OF_USER = ColumnType.VARCHAR;
        public static final int LENGTH_OF_USER = 200;
        public static final String COLUMNNAME_OF_USER = "user";
        public static final int INDEX_OF_ONTOLOGY_ID = 4;
        public static final ColumnType TYPE_OF_ONTOLOGY_ID = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ONTOLOGY_ID = 10;
        public static final String COLUMNNAME_OF_ONTOLOGY_ID = "ontology_id";
        public static final int INDEX_OF_ONTOLOGY = 5;
        public static final ColumnType TYPE_OF_ONTOLOGY = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ONTOLOGY = 30;
        public static final String COLUMNNAME_OF_ONTOLOGY = "ontology";
        public static final int INDEX_OF_APPROVED = 6;
        public static final ColumnType TYPE_OF_APPROVED = ColumnType.BOOLEAN;
        public static final String COLUMNNAME_OF_APPROVED = "is_approved";
        public static final int LENGTH_OF_APPROVED = 1;
        public static final int INDEX_OF_INCLUDE = 7;
        public static final ColumnType TYPE_OF_INCLUDE = ColumnType.BOOLEAN;
        public static final String COLUMNNAME_OF_INCLUDE = "is_included";
        public static final int LENGTH_OF_INCLUDE = 1;
        public static final int INDEX_OF_DELETED = 8;
        public static final ColumnType TYPE_OF_DELETED = ColumnType.BOOLEAN;
        public static final String COLUMNNAME_OF_DELETED = "is_deleted";
        public static final int LENGTH_OF_DELETED = 1;
        public static final int INDEX_OF_CREATION_DATE = 9;
        public static final ColumnType TYPE_OF_CREATION_DATE = ColumnType.DATETIME;
        public static final String COLUMNNAME_OF_CREATION_DATE = "creation_date";
        public static final int LENGTH_OF_CREATION_DATE = 0;
        public static final int INDEX_OF_MODIFICATION_DATE = 10;
        public static final ColumnType TYPE_OF_MODIFICATION_DATE = ColumnType.TIMESTAMP;
        public static final String COLUMNNAME_OF_MODIFICATION_DATE = "last_modified";
        public static final int LENGTH_OF_MODIFICATION_DATE = 0;
        public static final int INDEX_OF_COMMENT = 11;
        public static final ColumnType TYPE_OF_COMMENT = ColumnType.TEXT;
        public static final String COLUMNNAME_OF_COMMENT = "variant_comment";
        public static final int LENGTH_OF_COMMENT = 0;

        public UserCommentTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_USER_COMMENT_ID, TYPE_OF_USER_COMMENT_ID, 11);
            this.addColumn(COLUMNNAME_OF_USER_COMMENT_GROUP_ID, TYPE_OF_USER_COMMENT_GROUP_ID, 11);
            this.addColumn(COLUMNNAME_OF_PARENT_USER_COMMENT_ID, TYPE_OF_PARENT_USER_COMMENT_ID, 11);
            this.addColumn(COLUMNNAME_OF_USER, TYPE_OF_USER, 200);
            this.addColumn(COLUMNNAME_OF_ONTOLOGY, TYPE_OF_ONTOLOGY, 30);
            this.addColumn(COLUMNNAME_OF_ONTOLOGY_ID, TYPE_OF_ONTOLOGY_ID, 10);
            this.addColumn(COLUMNNAME_OF_APPROVED, TYPE_OF_APPROVED, 1);
            this.addColumn(COLUMNNAME_OF_INCLUDE, TYPE_OF_INCLUDE, 1);
            this.addColumn(COLUMNNAME_OF_DELETED, TYPE_OF_DELETED, 1);
            this.addColumn(COLUMNNAME_OF_CREATION_DATE, TYPE_OF_CREATION_DATE, 0);
            this.addColumn(COLUMNNAME_OF_MODIFICATION_DATE, TYPE_OF_MODIFICATION_DATE, 0);
            this.addColumn(COLUMNNAME_OF_COMMENT, TYPE_OF_COMMENT, 0);
        }
    }

    public static class UserCommentGroupTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "user_comment_group";
        public static final int INDEX_OF_USER_COMMENT_GROUP_ID = 0;
        public static final ColumnType TYPE_OF_USER_COMMENT_GROUP_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_USER_COMMENT_GROUP_ID = 11;
        public static final String COLUMNNAME_OF_USER_COMMENT_GROUP_ID = "user_comment_group_id";
        public static final int INDEX_OF_PROJECT_ID = 1;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 2;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_CHROMOSOME = 3;
        public static final ColumnType TYPE_OF_CHROMOSOME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_CHROMOSOME = 5;
        public static final String COLUMNNAME_OF_CHROMOSOME = "chrom";
        public static final int INDEX_OF_START_POSITION = 4;
        public static final ColumnType TYPE_OF_START_POSITION = ColumnType.INTEGER;
        public static final int LENGTH_OF_START_POSITION = 11;
        public static final String COLUMNNAME_OF_START_POSITION = "start_position";
        public static final int INDEX_OF_END_POSITION = 5;
        public static final ColumnType TYPE_OF_END_POSITION = ColumnType.INTEGER;
        public static final int LENGTH_OF_END_POSITION = 11;
        public static final String COLUMNNAME_OF_END_POSITION = "end_position";
        public static final int INDEX_OF_REF = 6;
        public static final ColumnType TYPE_OF_REF = ColumnType.VARCHAR;
        public static final int LENGTH_OF_REF = 255;
        public static final String COLUMNNAME_OF_REF = "ref";
        public static final int INDEX_OF_ALT = 7;
        public static final ColumnType TYPE_OF_ALT = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ALT = 255;
        public static final String COLUMNNAME_OF_ALT = "alt";

        public UserCommentGroupTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_USER_COMMENT_GROUP_ID, TYPE_OF_USER_COMMENT_GROUP_ID, 11);
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, TYPE_OF_PROJECT_ID, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, TYPE_OF_REFERENCE_ID, 11);
            this.addColumn(COLUMNNAME_OF_CHROMOSOME, TYPE_OF_CHROMOSOME, 5);
            this.addColumn(COLUMNNAME_OF_START_POSITION, TYPE_OF_START_POSITION, 11);
            this.addColumn(COLUMNNAME_OF_END_POSITION, TYPE_OF_END_POSITION, 11);
            this.addColumn(COLUMNNAME_OF_REF, TYPE_OF_REF, 255);
            this.addColumn(COLUMNNAME_OF_ALT, TYPE_OF_ALT, 255);
        }
    }

    public static class UserRoleAssignmentTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "user_role_assignment";
        public static final int INDEX_OF_USERNAME = 0;
        public static final ColumnType TYPE_OF_USERNAME = ColumnType.VARCHAR;
        public static final String COLUMNNAME_OF_USERNAME = "user";
        public static final int LENGTH_OF_USERNAME = 300;
        public static final int INDEX_OF_ROLE_ID = 1;
        public static final ColumnType TYPE_OF_ROLE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_ROLE_ID = 11;
        public static final String COLUMNNAME_OF_ROLE_ID = "fk_user_role_id";

        public UserRoleAssignmentTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_USERNAME, ColumnType.VARCHAR, 300);
            this.addColumn(COLUMNNAME_OF_ROLE_ID, ColumnType.INTEGER, 11);
        }
    }

    public static class UserRoleTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "user_role";
        public static final int INDEX_OF_ID = 0;
        public static final ColumnType TYPE_OF_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_ID = 11;
        public static final String COLUMNNAME_OF_ID = "user_role_id";
        public static final int INDEX_OF_ROLENAME = 1;
        public static final ColumnType TYPE_OF_ROLENAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ROLENAME = 64;
        public static final String COLUMNNAME_OF_ROLENAME = "role_name";
        public static final int INDEX_OF_ROLE_DESCRIPTION = 2;
        public static final ColumnType TYPE_OF_ROLE_DESCRIPTION = ColumnType.TEXT;
        public static final String COLUMNNAME_OF_ROLE_DESCRIPTION = "role_description";
        public static final int LENGTH_OF_ROLE_DESCRIPTION = 0;

        public UserRoleTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_ROLENAME, ColumnType.VARCHAR, 64);
            this.addColumn(COLUMNNAME_OF_ROLE_DESCRIPTION, ColumnType.TEXT, 0);
        }
    }

    public static class SettingsTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "settings";
        public static final int INDEX_OF_KEY = 0;
        public static final ColumnType TYPE_OF_KEY = ColumnType.VARCHAR;
        public static final int LENGTH_OF_KEY = 100;
        public static final String COLUMNNAME_OF_KEY = "setting_key";
        public static final int INDEX_OF_VALUE = 1;
        public static final ColumnType TYPE_OF_VALUE = ColumnType.VARCHAR;
        public static final int LENGTH_OF_VALUE = 300;
        public static final String COLUMNNAME_OF_VALUE = "setting_value";

        public SettingsTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_KEY, ColumnType.VARCHAR, 100);
            this.addColumn(COLUMNNAME_OF_VALUE, ColumnType.VARCHAR, 100);
        }
    }

    public static interface VariantTagColumns {
        public static final ColumnDef UPLOAD_ID = new ColumnDef("upload_id", ColumnType.INTEGER, 11);
        public static final ColumnDef TAGKEY = new ColumnDef("tagkey", ColumnType.VARCHAR, 500);
        public static final ColumnDef TAGVALUE = new ColumnDef("tagvalue", ColumnType.VARCHAR, 1000);
    }

    public static class VariantFormatTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "variant_format";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 1;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_UPDATE_ID = 2;
        public static final ColumnType TYPE_OF_UPDATE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_UPDATE_ID = 11;
        public static final String COLUMNNAME_OF_UPDATE_ID = "update_id";
        public static final int INDEX_OF_POSITION = 3;
        public static final ColumnType TYPE_OF_POSITION = ColumnType.INTEGER;
        public static final int LENGTH_OF_POSITION = 11;
        public static final String COLUMNNAME_OF_POSITION = "position";
        public static final int INDEX_OF_COLUMN_NAME = 4;
        public static final ColumnType TYPE_OF_COLUMN_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_COLUMN_NAME = 200;
        public static final String COLUMNNAME_OF_COLUMN_NAME = "column_name";
        public static final int INDEX_OF_COLUMN_TYPE = 5;
        public static final ColumnType TYPE_OF_COLUMN_TYPE = ColumnType.VARCHAR;
        public static final int LENGTH_OF_COLUMN_TYPE = 45;
        public static final String COLUMNNAME_OF_COLUMN_TYPE = "column_type";
        public static final int INDEX_OF_FILTERABLE = 6;
        public static final ColumnType TYPE_OF_FILTERABLE = ColumnType.INTEGER;
        public static final int LENGTH_OF_FILTERABLE = 1;
        public static final String COLUMNNAME_OF_FILTERABLE = "filterable";
        public static final int INDEX_OF_ALIAS = 7;
        public static final ColumnType TYPE_OF_ALIAS = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ALIAS = 200;
        public static final String COLUMNNAME_OF_ALIAS = "alias";
        public static final int INDEX_OF_DESCRIPTION = 8;
        public static final ColumnType TYPE_OF_DESCRIPTION = ColumnType.VARCHAR;
        public static final int LENGTH_OF_DESCRIPTION = 500;
        public static final String COLUMNNAME_OF_DESCRIPTION = "description";

        public VariantFormatTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_UPDATE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_POSITION, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_COLUMN_NAME, ColumnType.VARCHAR, 200);
            this.addColumn(COLUMNNAME_OF_COLUMN_TYPE, ColumnType.VARCHAR, 45);
            this.addColumn(COLUMNNAME_OF_FILTERABLE, ColumnType.INTEGER, 1);
            this.addColumn(COLUMNNAME_OF_ALIAS, ColumnType.VARCHAR, 200);
            this.addColumn(COLUMNNAME_OF_DESCRIPTION, ColumnType.VARCHAR, 500);
        }
    }

    public static class VariantTablemapTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "variant_tablemap";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 1;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_UPDATE_ID = 2;
        public static final ColumnType TYPE_OF_UPDATE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_UPDATE_ID = 11;
        public static final String COLUMNNAME_OF_UPDATE_ID = "update_id";
        public static final int INDEX_OF_PUBLISHED = 3;
        public static final ColumnType TYPE_OF_PUBLISHED = ColumnType.BOOLEAN;
        public static final int LENGTH_OF_PUBLISHED = 1;
        public static final String COLUMNNAME_OF_PUBLISHED = "published";
        public static final int INDEX_OF_VARIANT_TABLENAME = 4;
        public static final ColumnType TYPE_OF_VARIANT_TABLENAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_VARIANT_TABLENAME = 100;
        public static final String COLUMNNAME_OF_VARIANT_TABLENAME = "variant_tablename";
        public static final int INDEX_OF_ANNOTATION_IDS = 5;
        public static final ColumnType TYPE_OF_ANNOTATION_IDS = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ANNOTATION_IDS = 500;
        public static final String COLUMNNAME_OF_ANNOTATION_IDS = "annotation_ids";
        public static final int INDEX_OF_VARIANT_SUBSET_TABLENAME = 6;
        public static final ColumnType TYPE_OF_VARIANT_SUBSET_TABLENAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_VARIANT_SUBSET_TABLENAME = 100;
        public static final String COLUMNNAME_OF_VARIANT_SUBSET_TABLENAME = "variant_subset_tablename";
        public static final int INDEX_OF_SUBSET_MULTIPLIER = 7;
        public static final ColumnType TYPE_OF_SUBSET_MULTIPLIER = ColumnType.FLOAT;
        public static final int LENGTH_OF_SUBSET_MULTIPLIER = -1;
        public static final String COLUMNNAME_OF_SUBSET_MULTIPLIER = "subset_multiplier";

        public VariantTablemapTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_UPDATE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PUBLISHED, ColumnType.BOOLEAN, 1);
            this.addColumn(COLUMNNAME_OF_VARIANT_TABLENAME, ColumnType.VARCHAR, 100);
            this.addColumn(COLUMNNAME_OF_ANNOTATION_IDS, ColumnType.VARCHAR, 500);
            this.addColumn(COLUMNNAME_OF_VARIANT_SUBSET_TABLENAME, ColumnType.VARCHAR, 100);
            this.addColumn(COLUMNNAME_OF_SUBSET_MULTIPLIER, ColumnType.FLOAT, -1);
        }
    }

    public static class VariantPendingUpdateTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "variant_pending_update";
        public static final int INDEX_OF_UPLOAD_ID = 0;
        public static final ColumnType TYPE_OF_UPLOAD_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_UPLOAD_ID = 11;
        public static final String COLUMNNAME_OF_UPLOAD_ID = "upload_id";
        public static final int INDEX_OF_PROJECT_ID = 1;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_REFERENCE_ID = 2;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_ACTION = 3;
        public static final ColumnType TYPE_OF_ACTION = ColumnType.INTEGER;
        public static final int LENGTH_OF_ACTION = 11;
        public static final String COLUMNNAME_OF_ACTION = "action";
        public static final int INDEX_OF_STATUS = 4;
        public static final ColumnType TYPE_OF_STATUS = ColumnType.INTEGER;
        public static final int LENGTH_OF_STATUS = 5;
        public static final String COLUMNNAME_OF_STATUS = "status";
        public static final int INDEX_OF_TIMESTAMP = 5;
        public static final ColumnType TYPE_OF_TIMESTAMP = ColumnType.DATE;
        public static final int LENGTH_OF_TIMESTAMP = -1;
        public static final String COLUMNNAME_OF_TIMESTAMP = "timestamp";
        public static final int INDEX_OF_USER = 6;
        public static final ColumnType TYPE_OF_USER = ColumnType.VARCHAR;
        public static final int LENGTH_OF_USER = 200;
        public static final String COLUMNNAME_OF_USER = "user";

        public VariantPendingUpdateTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_UPLOAD_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_ACTION, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_STATUS, ColumnType.INTEGER, 5);
            this.addColumn(COLUMNNAME_OF_TIMESTAMP, ColumnType.DATE, -1);
            this.addColumn(COLUMNNAME_OF_USER, ColumnType.VARCHAR, 200);
        }
    }

    public static class ServerLogTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "server_log";
        public static final int INDEX_OF_ID = 0;
        public static final ColumnType TYPE_OF_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_ID = 11;
        public static final String COLUMNNAME_OF_ID = "id";
        public static final int INDEX_OF_USER = 1;
        public static final ColumnType TYPE_OF_USER = ColumnType.VARCHAR;
        public static final int LENGTH_OF_USER = 50;
        public static final String COLUMNNAME_OF_USER = "user";
        public static final int INDEX_OF_EVENT = 2;
        public static final ColumnType TYPE_OF_EVENT = ColumnType.VARCHAR;
        public static final int LENGTH_OF_EVENT = 50;
        public static final String COLUMNNAME_OF_EVENT = "event";
        public static final int INDEX_OF_DESCRIPTION = 3;
        public static final ColumnType TYPE_OF_DESCRIPTION = ColumnType.VARCHAR;
        public static final int LENGTH_OF_DESCRIPTION = -1;
        public static final String COLUMNNAME_OF_DESCRIPTION = "description";
        public static final int INDEX_OF_TIMESTAMP = 4;
        public static final ColumnType TYPE_OF_TIMESTAMP = ColumnType.DATE;
        public static final int LENGTH_OF_TIMESTAMP = -1;
        public static final String COLUMNNAME_OF_TIMESTAMP = "timestamp";

        public ServerLogTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_USER, ColumnType.VARCHAR, 50);
            this.addColumn(COLUMNNAME_OF_EVENT, ColumnType.VARCHAR, 50);
            this.addColumn(COLUMNNAME_OF_DESCRIPTION, ColumnType.VARCHAR, -1);
            this.addColumn(COLUMNNAME_OF_TIMESTAMP, ColumnType.DATE, -1);
        }
    }

    public static interface RegionSetMembershipColumns {
        public static final ColumnDef REGION_SET_ID = new ColumnDef("region_set_id", ColumnType.INTEGER, 11);
        public static final ColumnDef GENOME_ID = new ColumnDef("genome_id", ColumnType.INTEGER, 11);
        public static final ColumnDef CHROM = new ColumnDef("chrom", ColumnType.VARCHAR, 30);
        public static final ColumnDef START = new ColumnDef("start", ColumnType.INTEGER, 11);
        public static final ColumnDef END = new ColumnDef("end", ColumnType.INTEGER, 11);
        public static final ColumnDef DESCRIPTION = new ColumnDef("description", ColumnType.VARCHAR, 255);
    }

    public static interface RegionSetColumns {
        public static final ColumnDef REGION_SET_ID = new ColumnDef("region_set_id", ColumnType.INTEGER, 11, true, true, true, null);
        public static final ColumnDef NAME = new ColumnDef("name", ColumnType.VARCHAR, 255);
    }

    public static class ReferenceTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "reference";
        public static final int INDEX_OF_REFERENCE_ID = 0;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_NAME = 1;
        public static final ColumnType TYPE_OF_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_NAME = 50;
        public static final String COLUMNNAME_OF_NAME = "name";
        public static final int INDEX_OF_URL = 2;
        public static final ColumnType TYPE_OF_URL = ColumnType.VARCHAR;
        public static final int LENGTH_OF_URL = 200;
        public static final String COLUMNNAME_OF_URL = "url";

        public ReferenceTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_NAME, ColumnType.VARCHAR, 50);
            this.addColumn(COLUMNNAME_OF_URL, ColumnType.VARCHAR, 200);
        }
    }

    public static class ProjectTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "project";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_NAME = 1;
        public static final ColumnType TYPE_OF_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_NAME = 50;
        public static final String COLUMNNAME_OF_NAME = "name";

        public ProjectTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_NAME, ColumnType.VARCHAR, 50);
        }
    }

    public static class PatientTablemapTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "patient_tablemap";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_PATIENT_TABLENAME = 1;
        public static final ColumnType TYPE_OF_PATIENT_TABLENAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_PATIENT_TABLENAME = 100;
        public static final String COLUMNNAME_OF_PATIENT_TABLENAME = "patient_tablename";

        public PatientTablemapTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PATIENT_TABLENAME, ColumnType.VARCHAR, 100);
        }
    }

    public static class PatientFormatTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "patient_format";
        public static final int INDEX_OF_PROJECT_ID = 0;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_POSITION = 1;
        public static final ColumnType TYPE_OF_POSITION = ColumnType.INTEGER;
        public static final int LENGTH_OF_POSITION = 11;
        public static final String COLUMNNAME_OF_POSITION = "position";
        public static final int INDEX_OF_COLUMN_NAME = 2;
        public static final ColumnType TYPE_OF_COLUMN_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_COLUMN_NAME = 200;
        public static final String COLUMNNAME_OF_COLUMN_NAME = "column_name";
        public static final int INDEX_OF_COLUMN_TYPE = 3;
        public static final ColumnType TYPE_OF_COLUMN_TYPE = ColumnType.VARCHAR;
        public static final int LENGTH_OF_COLUMN_TYPE = 45;
        public static final String COLUMNNAME_OF_COLUMN_TYPE = "column_type";
        public static final int INDEX_OF_FILTERABLE = 4;
        public static final ColumnType TYPE_OF_FILTERABLE = ColumnType.INTEGER;
        public static final int LENGTH_OF_FILTERABLE = 1;
        public static final String COLUMNNAME_OF_FILTERABLE = "filterable";
        public static final int INDEX_OF_ALIAS = 5;
        public static final ColumnType TYPE_OF_ALIAS = ColumnType.VARCHAR;
        public static final int LENGTH_OF_ALIAS = 200;
        public static final String COLUMNNAME_OF_ALIAS = "alias";
        public static final int INDEX_OF_DESCRIPTION = 6;
        public static final ColumnType TYPE_OF_DESCRIPTION = ColumnType.VARCHAR;
        public static final int LENGTH_OF_DESCRIPTION = 500;
        public static final String COLUMNNAME_OF_DESCRIPTION = "description";

        public PatientFormatTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_POSITION, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_COLUMN_NAME, ColumnType.VARCHAR, 200);
            this.addColumn(COLUMNNAME_OF_COLUMN_TYPE, ColumnType.VARCHAR, 45);
            this.addColumn(COLUMNNAME_OF_FILTERABLE, ColumnType.INTEGER, 1);
            this.addColumn(COLUMNNAME_OF_ALIAS, ColumnType.VARCHAR, 200);
            this.addColumn(COLUMNNAME_OF_DESCRIPTION, ColumnType.VARCHAR, 500);
        }
    }

    public static interface OntologyInfoColumns {
        public static final ColumnDef TYPE = new ColumnDef("type", ColumnType.VARCHAR, 10);
        public static final ColumnDef ONTOLOGY_NAME = new ColumnDef("name", ColumnType.VARCHAR, 60, false, true, true, null);
        public static final ColumnDef OBO_URL = new ColumnDef("obo_url", ColumnType.VARCHAR, 300);
        public static final ColumnDef MAPPING_URL = new ColumnDef("mapping_url", ColumnType.VARCHAR, 300);
    }

    public static interface OntologyColumns {
        public static final ColumnDef ONTOLOGY = new ColumnDef("ontology", ColumnType.VARCHAR, 10);
        public static final ColumnDef ID = new ColumnDef("id", ColumnType.VARCHAR, 30, false, true, true, null);
        public static final ColumnDef NAME = new ColumnDef("name", ColumnType.VARCHAR, 300);
        public static final ColumnDef DEF = new ColumnDef("def", ColumnType.TEXT, 120000, false, false, false, null);
        public static final ColumnDef ALT_IDS = new ColumnDef("alt_ids", ColumnType.VARCHAR, 300, false, false, false, null);
        public static final ColumnDef PARENTS = new ColumnDef("parents", ColumnType.VARCHAR, 120, false, false, false, null);
        public static final ColumnDef GENES = new ColumnDef("genes", ColumnType.TEXT, 120000, false, false, false, null);
    }

    public static interface GeneSetColumns {
        public static final ColumnDef GENOME = new ColumnDef("genome", ColumnType.VARCHAR, 30);
        public static final ColumnDef TYPE = new ColumnDef("type", ColumnType.VARCHAR, 30);
        public static final ColumnDef NAME = new ColumnDef("name", ColumnType.VARCHAR, 30);
        public static final ColumnDef CHROM = new ColumnDef("chrom", ColumnType.VARCHAR, 30);
        public static final ColumnDef START = new ColumnDef("start", ColumnType.INTEGER, 11);
        public static final ColumnDef END = new ColumnDef("end", ColumnType.INTEGER, 11);
        public static final ColumnDef CODING_START = new ColumnDef("codingStart", ColumnType.INTEGER, 11);
        public static final ColumnDef CODING_END = new ColumnDef("codingEnd", ColumnType.INTEGER, 11);
        public static final ColumnDef EXON_STARTS = new ColumnDef("exonStarts", ColumnType.VARCHAR, 9000);
        public static final ColumnDef EXON_ENDS = new ColumnDef("exonEnds", ColumnType.VARCHAR, 9000);
        public static final ColumnDef TRANSCRIPT = new ColumnDef("transcript", ColumnType.VARCHAR, 30);
    }

    public static class CohortMembershipTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "cohort_membership";
        public static final int INDEX_OF_COHORT_ID = 0;
        public static final ColumnType TYPE_OF_COHORT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_COHORT_ID = 11;
        public static final String COLUMNNAME_OF_COHORT_ID = "cohort_id";
        public static final int INDEX_OF_PATIENT_ID = 1;
        public static final ColumnType TYPE_OF_PATIENT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PATIENT_ID = 11;
        public static final String COLUMNNAME_OF_PATIENT_ID = "patient_id";

        public CohortMembershipTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_COHORT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PATIENT_ID, ColumnType.INTEGER, 11);
        }
    }

    public static class CohortTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "cohort";
        public static final int INDEX_OF_COHORT_ID = 0;
        public static final ColumnType TYPE_OF_COHORT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_COHORT_ID = 11;
        public static final String COLUMNNAME_OF_COHORT_ID = "cohort_id";
        public static final int INDEX_OF_PROJECT_ID = 1;
        public static final ColumnType TYPE_OF_PROJECT_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_PROJECT_ID = 11;
        public static final String COLUMNNAME_OF_PROJECT_ID = "project_id";
        public static final int INDEX_OF_NAME = 2;
        public static final ColumnType TYPE_OF_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_NAME = 255;
        public static final String COLUMNNAME_OF_NAME = "name";

        public CohortTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_COHORT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_PROJECT_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_NAME, ColumnType.VARCHAR, 255);
        }
    }

    public static class ChromosomeTableSchema
    extends TableSchema {
        public static final String TABLE_NAME = "chromosome";
        public static final int INDEX_OF_REFERENCE_ID = 0;
        public static final ColumnType TYPE_OF_REFERENCE_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_REFERENCE_ID = 11;
        public static final String COLUMNNAME_OF_REFERENCE_ID = "reference_id";
        public static final int INDEX_OF_CONTIG_ID = 1;
        public static final ColumnType TYPE_OF_CONTIG_ID = ColumnType.INTEGER;
        public static final int LENGTH_OF_CONTIG_ID = 11;
        public static final String COLUMNNAME_OF_CONTIG_ID = "contig_id";
        public static final int INDEX_OF_CONTIG_NAME = 2;
        public static final ColumnType TYPE_OF_CONTIG_NAME = ColumnType.VARCHAR;
        public static final int LENGTH_OF_CONTIG_NAME = 100;
        public static final String COLUMNNAME_OF_CONTIG_NAME = "contig_name";
        public static final int INDEX_OF_CONTIG_LENGTH = 3;
        public static final ColumnType TYPE_OF_CONTIG_LENGTH = ColumnType.INTEGER;
        public static final int LENGTH_OF_CONTIG_LENGTH = 11;
        public static final String COLUMNNAME_OF_CONTIG_LENGTH = "contig_length";
        public static final int INDEX_OF_CENTROMERE_POS = 4;
        public static final ColumnType TYPE_OF_CENTROMERE_POS = ColumnType.INTEGER;
        public static final int LENGTH_OF_CENTROMERE_POS = 11;
        public static final String COLUMNNAME_OF_CENTROMERE_POS = "centromere_pos";

        public ChromosomeTableSchema(DbSchema s) {
            super(s.addTable(TABLE_NAME));
            this.addColumns();
        }

        private void addColumns() {
            this.addColumn(COLUMNNAME_OF_REFERENCE_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_CONTIG_ID, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_CONTIG_NAME, ColumnType.VARCHAR, 100);
            this.addColumn(COLUMNNAME_OF_CONTIG_LENGTH, ColumnType.INTEGER, 11);
            this.addColumn(COLUMNNAME_OF_CENTROMERE_POS, ColumnType.INTEGER, 11);
        }
    }

    public static interface AnnotationFormatColumns {
        public static final ColumnDef ANNOTATION_ID = new ColumnDef("annotation_id", ColumnType.INTEGER, 11, true, true, true, null);
        public static final ColumnDef POSITION = new ColumnDef("position", ColumnType.INTEGER, 11, true, true, true, null);
        public static final ColumnDef COLUMN_NAME = new ColumnDef("column_name", ColumnType.VARCHAR, 200);
        public static final ColumnDef COLUMN_TYPE = new ColumnDef("column_type", ColumnType.VARCHAR, 45);
        public static final ColumnDef FILTERABLE = new ColumnDef("filterable", ColumnType.BOOLEAN, 1);
        public static final ColumnDef ALIAS = new ColumnDef("alias", ColumnType.VARCHAR, 200);
        public static final ColumnDef DESCRIPTION = new ColumnDef("description", ColumnType.VARCHAR, 500);
        public static final ColumnDef TAGS = new ColumnDef("tags", ColumnType.VARCHAR, 500);
    }

    public static interface AnnotationColumns {
        public static final ColumnDef ANNOTATION_ID = new ColumnDef("annotation_id", ColumnType.INTEGER, 11, true, true, true, null);
        public static final ColumnDef PROGRAM = new ColumnDef("program", ColumnType.VARCHAR, 100);
        public static final ColumnDef VERSION = new ColumnDef("version", ColumnType.VARCHAR, 100, true, false, true, null);
        public static final ColumnDef REFERENCE_ID = new ColumnDef("reference_id", ColumnType.INTEGER, 11);
        public static final ColumnDef PATH = new ColumnDef("path", ColumnType.VARCHAR, 500);
        public static final ColumnDef HAS_REF = new ColumnDef("has_ref", ColumnType.BOOLEAN, 1);
        public static final ColumnDef HAS_ALT = new ColumnDef("has_alt", ColumnType.BOOLEAN, 1);
        public static final ColumnDef TYPE = new ColumnDef("type", ColumnType.INTEGER, 11);
        public static final ColumnDef IS_END_INCLUSIVE = new ColumnDef("is_end_inclusive", ColumnType.BOOLEAN, 1);
    }
}

