/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.shared.model.ProgressStatus;

public class MedSavantServerUnicastRemoteObject
extends UnicastRemoteObject {
    private static final Log LOG = LogFactory.getLog(MedSavantServerUnicastRemoteObject.class);
    private static int CONNECT_PORT = 36800;
    private static int EXPORT_PORT = 36801;
    protected final Map<String, ProgressStatus> sessionProgresses = new HashMap<String, ProgressStatus>();

    public MedSavantServerUnicastRemoteObject() throws RemoteException {
        super(EXPORT_PORT, MedSavantServerEngine.getDefaultClientSocketFactory(), MedSavantServerEngine.getDefaultServerSocketFactory());
    }

    public static int getListenPort() {
        return CONNECT_PORT;
    }

    public static int getExportPort() {
        return EXPORT_PORT;
    }

    public static void setListenPort(int port) {
        CONNECT_PORT = port;
        EXPORT_PORT = port + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressStatus checkProgress(String sessID, boolean userCancelled) {
        Map<String, ProgressStatus> map = this.sessionProgresses;
        synchronized (map) {
            if (userCancelled) {
                LOG.info((Object)"Setting progress-status to CANCELLED.");
                this.sessionProgresses.put(sessID, ProgressStatus.CANCELLED);
                return ProgressStatus.CANCELLED;
            }
            return this.sessionProgresses.get(sessID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeProgress(String sessID, String msg, double frac) throws InterruptedException {
        Map<String, ProgressStatus> map = this.sessionProgresses;
        synchronized (map) {
            if (frac == 0.0) {
                this.sessionProgresses.put(sessID, new ProgressStatus(msg, frac));
            } else {
                ProgressStatus status = this.sessionProgresses.get(sessID);
                if (status == ProgressStatus.CANCELLED) {
                    LOG.info((Object)"Operation cancelled by user.");
                    throw new InterruptedException();
                }
                if (status == null || !status.message.equals(msg) || status.fractionCompleted != frac) {
                    this.sessionProgresses.put(sessID, new ProgressStatus(msg, frac));
                }
            }
        }
    }
}

