/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.IOJob;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;

public class MedSavantIOController {
    private static final Log LOG = LogFactory.getLog(MedSavantIOController.class);
    private static final int TIME_PER_PERMIT = 10000;
    private static Semaphore IOSem = new Semaphore(MedSavantServerEngine.MAX_IO_JOBS, true);
    private static final Timer timer = new Timer();
    private static final List<Permit> outStandingPermits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestIO(IOJob job) throws IOException, InterruptedException {
        Permit permit = Permit.getPermit(job);
        try {
            while (job.continueIO()) {
                permit.renew();
                job.doIO();
            }
            job.finish();
        }
        finally {
            permit.release();
        }
    }

    static {
        timer.schedule((TimerTask)new PermitRenewerTask(), 10000L, 10000L);
        outStandingPermits = new ArrayList<Permit>();
    }

    private static class Permit {
        private boolean valid;
        private String jobName;

        private Permit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Permit getPermit(IOJob job) throws InterruptedException {
            Permit p = new Permit();
            p.jobName = job.getName();
            List list = outStandingPermits;
            synchronized (list) {
                outStandingPermits.add(p);
            }
            IOSem.acquire();
            p.valid = true;
            return p;
        }

        public void invalidate() {
            this.valid = false;
        }

        public void renew() throws InterruptedException {
            if (!this.valid) {
                IOSem.release();
                IOSem.acquire();
                this.valid = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IOSem.release();
            List list = outStandingPermits;
            synchronized (list) {
                outStandingPermits.remove(this);
            }
        }
    }

    private static class PermitRenewerTask
    extends TimerTask {
        private PermitRenewerTask() {
        }

        @Override
        public synchronized void run() {
            for (Permit p : outStandingPermits) {
                p.invalidate();
            }
        }
    }
}

