/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;
import org.ut.biolab.medsavant.shared.util.WebResources;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VersionSettings {
    private static final Log LOG = LogFactory.getLog(VersionSettings.class);
    private static final String UNDEFINED_VERSION = "";
    private static final String BETA_VERSION = "SNAPSHOT";
    private static final int FIRST_TIMEOUT = 10000;
    private static final int SUBSEQUENT_TIMEOUT = 1000;
    private static int timeoutVal = 10000;

    public static boolean isBeta() {
        return VersionSettings.getVersionString().toLowerCase().contains(BETA_VERSION.toLowerCase());
    }

    public static String getVersionString() {
        String version = UNDEFINED_VERSION;
        Package aPackage = VersionSettings.class.getPackage();
        if (aPackage != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = UNDEFINED_VERSION;
        }
        return System.getProperty("medsavant.version", version);
    }

    public static boolean isCompatible(URL url, String queryVersion, String hostVersion, boolean exactMatchByPass) throws SAXException, SocketTimeoutException, IOException {
        DocumentBuilder dBuilder;
        LOG.info((Object)("Checking compatibility between " + queryVersion + " and host: " + hostVersion));
        if (exactMatchByPass && hostVersion.equals(queryVersion)) {
            LOG.info((Object)"Client and server versions match exactly");
            return true;
        }
        LOG.info((Object)"Client and server versions aren't an exact match, looking up compatibility...");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return false;
        }
        Document doc = null;
        try {
            doc = dBuilder.parse(NetworkUtils.openStream(url, timeoutVal, timeoutVal));
        }
        catch (SocketTimeoutException sto) {
            LOG.info((Object)("Timed out after " + timeoutVal + " seconds"));
            timeoutVal = 1000;
            throw sto;
        }
        timeoutVal = 10000;
        doc.getDocumentElement().normalize();
        System.out.println("Document element normalized");
        HashMap<String, Set<String>> versionMap = new HashMap<String, Set<String>>();
        String nodeName = "host";
        NodeList nodes = doc.getElementsByTagName(nodeName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            String versionNum;
            Node n = nodes.item(i);
            if (n.getNodeType() != 1 || (versionNum = (e = (Element)n).getAttribute("name")) == null || versionNum.equals(UNDEFINED_VERSION)) continue;
            versionMap.put(versionNum, MiscUtils.getTagValues(e, "compatible"));
        }
        return versionMap.containsKey(hostVersion) && ((Set)versionMap.get(hostVersion)).contains(queryVersion);
    }

    public static boolean isClientCompatibleWithServer(String clientVersion, String serverVersion) throws IOException, SAXException, SocketTimeoutException {
        LOG.info((Object)"Checking client->server compatibility");
        return VersionSettings.isCompatible(WebResources.CLIENT_SERVER_VERSION_COMPATIBILITY_URL, clientVersion, serverVersion, true);
    }

    public static boolean isDatabaseCompatibleWithServer(String dbVersion, String serverVersion) throws IOException, SAXException, SocketTimeoutException {
        LOG.info((Object)"Checking database->server compatibility");
        return VersionSettings.isCompatible(WebResources.DATABASE_SERVER_VERSION_COMPATIBILITY_URL, dbVersion, serverVersion, true);
    }

    public static boolean isAppSDKCompatibleWithClient(String appSDKVersion, String clientVersion) throws IOException, SAXException, SocketTimeoutException {
        LOG.info((Object)"Checking app->client compatibility");
        return VersionSettings.isCompatible(WebResources.APPSDK_CLIENT_VERSION_COMPATIBILITY_URL, appSDKVersion, clientVersion, false);
    }
}

