/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.File;
import java.io.FileFilter;

public class ExtensionsFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String[] extensions;

    public ExtensionsFileFilter(String[] exts) {
        this.extensions = exts;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (f.isFile()) {
            for (String ext : this.extensions) {
                if (!f.getAbsolutePath().toLowerCase().endsWith("." + ext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.extensions[0].equals("vcf")) {
            return "VCF files | " + this.getExtensionString();
        }
        if (this.extensions[0].equals("svp")) {
            return "Savant Project Files | " + this.getExtensionString();
        }
        return "*." + this.extensions[0];
    }

    private String getExtensionString() {
        String s = "";
        for (String e : this.extensions) {
            s = s + " *." + e;
        }
        return s;
    }
}

