/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.util.Date;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;

public class UserComment
implements Serializable {
    public static final OntologyType ONTOLOGY_TYPE = OntologyType.HPO;
    private static final boolean DEFAULT_APPROVED_STATUS = false;
    private static final boolean DEFAULT_INCLUDED_STATUS = false;
    private static final boolean DEFAULT_DELETED_STATUS = false;
    protected final Integer commentId;
    private final String user;
    private final boolean isApproved;
    private final boolean isIncluded;
    private final boolean isDeleted;
    private final Date creationDate;
    private final Date modificationDate;
    private final String commentText;
    private final OntologyTerm ontologyTerm;
    private UserComment parentComment;

    public boolean equals(Object c) {
        if (c == null) {
            return false;
        }
        if (!(c instanceof UserComment)) {
            return false;
        }
        if (c.hashCode() != this.hashCode()) {
            return false;
        }
        UserComment uc = (UserComment)c;
        if (this.commentId != null && uc.getCommentID() != null) {
            return this.commentId == uc.getCommentID();
        }
        return this.user.equals(uc.getUser()) && this.commentText.equals(uc.commentText) && this.ontologyTerm.equals(uc.ontologyTerm);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.commentId != null ? this.commentId.hashCode() : 0);
        hash = 97 * hash + (this.user != null ? this.user.hashCode() : 0);
        hash = 97 * hash + (this.modificationDate != null ? this.modificationDate.hashCode() : 0);
        hash = 97 * hash + (this.commentText != null ? this.commentText.hashCode() : 0);
        hash = 97 * hash + (this.ontologyTerm != null ? this.ontologyTerm.hashCode() : 0);
        return hash;
    }

    public UserComment(UserComment parentComment, Boolean approveParent, Boolean includeParent, Boolean markParentDeleted, String comment) {
        this(parentComment.isApproved(), parentComment.isIncluded(), parentComment.isDeleted(), comment, parentComment.getOntologyTerm(), new UserComment(approveParent, includeParent, markParentDeleted, parentComment.getCommentText(), parentComment.getOntologyTerm()));
        this.parentComment = new UserComment(parentComment.getCommentID(), null, approveParent, includeParent, markParentDeleted, null, null, parentComment.getCommentText(), parentComment.getOntologyTerm(), null);
    }

    public UserComment(String comment, OntologyTerm ontologyTerm) {
        this(false, (Boolean)false, (Boolean)false, comment, ontologyTerm);
    }

    public UserComment(Boolean isApproved, Boolean isIncluded, Boolean isDeleted, String comment, OntologyTerm ontologyTerm) {
        this(null, null, isApproved, isIncluded, isDeleted, null, null, comment, ontologyTerm, null);
    }

    public UserComment(Boolean isApproved, Boolean isIncluded, Boolean isDeleted, String comment, OntologyTerm ontologyTerm, UserComment parentComment) {
        this(null, null, isApproved, isIncluded, isDeleted, null, null, comment, ontologyTerm, parentComment);
    }

    public UserComment(Integer commentId, String user, Boolean isApproved, Boolean isIncluded, Boolean isDeleted, Date creationDate, Date modificationDate, String commentText, OntologyTerm ontologyTerm, UserComment parentComment) {
        this.commentId = commentId;
        this.user = user;
        this.isApproved = isApproved;
        this.isIncluded = isIncluded;
        this.isDeleted = isDeleted;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.commentText = commentText;
        this.ontologyTerm = ontologyTerm;
        this.parentComment = parentComment;
    }

    public OntologyTerm getOntologyTerm() {
        return this.ontologyTerm;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public boolean statusChanged() {
        return this.parentComment != null && (this.parentComment.isApproved() != this.isApproved() || this.parentComment.isDeleted() != this.isDeleted() || this.parentComment.isIncluded() != this.isIncluded());
    }

    public UserComment getOriginalComment() {
        return this.parentComment;
    }

    public Integer getCommentID() {
        return this.commentId;
    }
}

