/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import java.util.ArrayList;
import java.util.List;

public class DbTable
extends DbObject<DbSchema>
implements Table {
    private String _alias;
    private List<DbColumn> _columns = new ArrayList<DbColumn>();
    private List<DbConstraint> _constraints = new ArrayList<DbConstraint>();

    public DbTable(DbSchema parent, String name) {
        this(parent, name, parent.getSpec().getNextAlias());
    }

    public DbTable(DbSchema parent, String name, String alias) {
        super(parent, name);
        this._alias = alias;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getTableNameSQL() {
        return this.getAbsoluteName();
    }

    public List<DbColumn> getColumns() {
        return this._columns;
    }

    public List<DbConstraint> getConstraints() {
        return this._constraints;
    }

    public DbColumn findColumn(String name) {
        return DbTable.findObject(this._columns, name);
    }

    public DbColumn[] findColumns(String ... names) {
        if (names == null) {
            return null;
        }
        DbColumn[] cols = new DbColumn[names.length];
        for (int i = 0; i < names.length; ++i) {
            cols[i] = DbTable.findObject(this._columns, names[i]);
        }
        return cols;
    }

    public DbColumn addColumn(String name) {
        return this.addColumn(name, null, null, null);
    }

    public DbColumn addColumn(String name, String typeName, Integer typeLength, Integer scale) {
        DbColumn column = this.getSpec().createColumn(this, name, typeName, typeLength, scale);
        return this.addColumn(column);
    }

    public DbColumn addColumn(String name, int type, Integer typeLength, Integer scale) {
        return this.addColumn(name, DbColumn.getTypeName(type), typeLength, scale);
    }

    public <T extends DbColumn> T addColumn(T column) {
        this._columns.add(this.checkOwnership(column));
        return column;
    }

    public DbConstraint unique(String name, String ... colNames) {
        DbConstraint constraint = this.getSpec().createTableConstraint(this, name, Constraint.Type.UNIQUE, colNames);
        return this.addConstraint(constraint);
    }

    public DbConstraint primaryKey(String name, String ... colNames) {
        DbConstraint constraint = this.getSpec().createTableConstraint(this, name, Constraint.Type.PRIMARY_KEY, colNames);
        return this.addConstraint(constraint);
    }

    public DbForeignKeyConstraint foreignKey(String name, String[] colNames, String referencedSchemaName, String referencedTableName, String[] referencedColNames) {
        DbTable referencedTable = this.getSpec().findSchema(referencedSchemaName).findTable(referencedTableName);
        DbForeignKeyConstraint fkConstraint = this.getSpec().createTableForeignKeyConstraint(this, name, referencedTable, colNames, referencedColNames);
        return this.addConstraint(fkConstraint);
    }

    public <T extends DbConstraint> T addConstraint(T constraint) {
        this._constraints.add(this.checkOwnership(constraint));
        return constraint;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getAlias() + ")";
    }
}

