/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;

public class QueryPreparer {
    public static final int DEFAULT_START_INDEX = 1;
    private static final int NO_INDEX = -1;
    private int _curIndex;
    private List<StaticPlaceHolder> _staticPlaceHolders;

    public QueryPreparer() {
        this(1);
    }

    public String toString() {
        Formatter fmt = new Formatter();
        if (this._staticPlaceHolders != null) {
            for (StaticPlaceHolder placeHolder : this._staticPlaceHolders) {
                if (placeHolder != null) {
                    fmt.format("[%s] %s%n", placeHolder.getClass().getSimpleName(), placeHolder.displayToString());
                    continue;
                }
                fmt.format("<null>???", new Object[0]);
            }
        } else {
            fmt.format("<No static place holders>%n", new Object[0]);
        }
        return fmt.toString();
    }

    public QueryPreparer(int startIndex) {
        if (startIndex < 1) {
            throw new IllegalArgumentException("invalid start index");
        }
        this._curIndex = startIndex;
    }

    public PlaceHolder getNewPlaceHolder() {
        return new PlaceHolder(this);
    }

    public MultiPlaceHolder getNewMultiPlaceHolder() {
        return new MultiPlaceHolder(this);
    }

    public StaticPlaceHolder addStaticPlaceHolder(String val) {
        return this.addStaticPlaceHolder(new StringStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Long val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new LongStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(-5, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Integer val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new IntegerStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(4, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Boolean val) {
        if (val != null) {
            return this.addStaticPlaceHolder(new BooleanStaticPlaceHolder(val, this));
        }
        return this.addStaticPlaceHolder(new NullStaticPlaceHolder(16, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(long val) {
        return this.addStaticPlaceHolder(new LongStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(int val) {
        return this.addStaticPlaceHolder(new IntegerStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(boolean val) {
        return this.addStaticPlaceHolder(new BooleanStaticPlaceHolder(val, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Object obj) {
        return this.addStaticPlaceHolder(new ObjectStaticPlaceHolder<Object>(obj, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(Object obj, int sqlType) {
        return this.addStaticPlaceHolder(new TypedStaticPlaceHolder(obj, sqlType, this));
    }

    public StaticPlaceHolder addStaticPlaceHolder(StaticPlaceHolder ph) {
        if (this._staticPlaceHolders == null) {
            this._staticPlaceHolders = new ArrayList<StaticPlaceHolder>();
        }
        this._staticPlaceHolders.add(ph);
        return ph;
    }

    public void setStaticValues(PreparedStatement ps) throws SQLException {
        if (this._staticPlaceHolders != null) {
            for (StaticPlaceHolder ph : this._staticPlaceHolders) {
                ph.setValue(ps);
            }
        }
    }

    public static class BooleanStaticPlaceHolder
    extends StaticPlaceHolder {
        private boolean _val;

        public BooleanStaticPlaceHolder(boolean val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setBoolean(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class IntegerStaticPlaceHolder
    extends StaticPlaceHolder {
        private int _val;

        public IntegerStaticPlaceHolder(int val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setInt(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class LongStaticPlaceHolder
    extends StaticPlaceHolder {
        private long _val;

        public LongStaticPlaceHolder(long val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setLong(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class StringStaticPlaceHolder
    extends ObjectStaticPlaceHolder<String> {
        public StringStaticPlaceHolder(String val, QueryPreparer outer) {
            super(val, outer);
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setString((String)this._val, ps);
        }
    }

    public static class TypedStaticPlaceHolder
    extends ObjectStaticPlaceHolder<Object> {
        private int _sqlType;

        public TypedStaticPlaceHolder(Object val, int sqlType, QueryPreparer outer) {
            super(val, outer);
            this._sqlType = sqlType;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setObject(this._val, this._sqlType, ps);
        }
    }

    public static class ObjectStaticPlaceHolder<ObjType>
    extends StaticPlaceHolder {
        protected ObjType _val;

        public ObjectStaticPlaceHolder(ObjType val, QueryPreparer outer) {
            super(outer);
            this._val = val;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setObject(this._val, ps);
        }

        @Override
        public String displayToString() {
            return "'" + this._val + "'";
        }
    }

    public static class NullStaticPlaceHolder
    extends StaticPlaceHolder {
        private int _sqlType;

        public NullStaticPlaceHolder(int sqlType, QueryPreparer outer) {
            super(outer);
            this._sqlType = sqlType;
        }

        @Override
        public void setValue(PreparedStatement ps) throws SQLException {
            this.setNull(this._sqlType, ps);
        }

        @Override
        public String displayToString() {
            return "NullSqlType=" + this._sqlType;
        }
    }

    public static abstract class StaticPlaceHolder
    extends PlaceHolder {
        public StaticPlaceHolder(QueryPreparer outer) {
            super(outer);
        }

        public abstract void setValue(PreparedStatement var1) throws SQLException;

        public abstract String displayToString();
    }

    public static class MultiPlaceHolder
    extends PlaceHolder {
        private List<Integer> _indexes = new LinkedList<Integer>();

        public MultiPlaceHolder(QueryPreparer outer) {
            super(outer);
        }

        @Override
        public List<Integer> getIndexes() {
            return this._indexes;
        }

        @Override
        public boolean isInQuery() {
            return !this.getIndexes().isEmpty();
        }

        @Override
        protected void addIndex(int index) {
            this.getIndexes().add(index);
        }

        @Override
        public int getIndex() {
            if (this.getIndexes().size() <= 1) {
                return !this.getIndexes().isEmpty() ? this.getIndexes().get(0) : -1;
            }
            throw new UnsupportedOperationException("This method may not be used for multi-use MultiPlaceHolder");
        }

        @Override
        public void setNull(int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setNull(index, sqlType);
                }
            }
        }

        @Override
        public void setInt(int value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setInt(index, value);
                }
            }
        }

        @Override
        public void setLong(long value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setLong(index, value);
                }
            }
        }

        @Override
        public void setBoolean(boolean value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setBoolean(index, value);
                }
            }
        }

        @Override
        protected void setNonNullString(String value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setString(index, value);
                }
            }
        }

        @Override
        public void setObject(Object value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setObject(index, value);
                }
            }
        }

        @Override
        protected void setNonNullObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                for (Integer index : this.getIndexes()) {
                    ps.setObject((int)index, value, sqlType);
                }
            }
        }
    }

    public static class PlaceHolder
    extends SqlObject {
        private QueryPreparer _outer;
        private int _index = -1;

        public PlaceHolder(QueryPreparer outer) {
            this._outer = outer;
        }

        public boolean isInQuery() {
            return this.getIndex() != -1;
        }

        private void setIndex(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        public List<Integer> getIndexes() {
            return Collections.singletonList(this._index);
        }

        protected void addIndex(int index) {
            if (this.getIndex() != -1) {
                throw new IllegalStateException("attempt to reset value of PlaceHolder, cannot reuse or use multiple times in the same query");
            }
            this.setIndex(index);
        }

        public void setNull(int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setNull(this.getIndex(), sqlType);
            }
        }

        public void setInt(int value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setInt(this.getIndex(), value);
            }
        }

        public void setInt(Integer value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setInt((int)value, ps);
            } else {
                this.setNull(4, ps);
            }
        }

        public void setLong(long value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setLong(this.getIndex(), value);
            }
        }

        public void setLong(Long value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setLong((long)value, ps);
            } else {
                this.setNull(-5, ps);
            }
        }

        public void setBoolean(boolean value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setBoolean(this.getIndex(), value);
            }
        }

        public void setBoolean(Boolean value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setBoolean((boolean)value, ps);
            } else {
                this.setNull(16, ps);
            }
        }

        protected void setNonNullString(String value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setString(this.getIndex(), value);
            }
        }

        public void setString(String value, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setNonNullString(value, ps);
            } else {
                this.setNull(12, ps);
            }
        }

        public void setObject(Object value, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setObject(this.getIndex(), value);
            }
        }

        protected void setNonNullObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (this.isInQuery()) {
                ps.setObject(this.getIndex(), value, sqlType);
            }
        }

        public void setObject(Object value, int sqlType, PreparedStatement ps) throws SQLException {
            if (value != null) {
                this.setNonNullObject(value, sqlType, ps);
            } else {
                this.setNull(sqlType, ps);
            }
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
        }

        public final void appendTo(AppendableExt app) throws IOException {
            this.addIndex(this._outer._curIndex++);
            SqlObject.QUESTION_MARK.appendTo(app);
        }
    }
}

