/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Index;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class CreateIndexQuery
extends BaseCreateQuery<CreateIndexQuery> {
    protected SqlObject _table;

    public CreateIndexQuery(Index index) {
        this((Object)index.getTable(), (Object)index);
        this._columns.addObjects(Converter.COLUMN_TO_OBJ, index.getColumns());
    }

    public CreateIndexQuery(Table table, String indexName) {
        this((Object)table, (Object)indexName);
    }

    public CreateIndexQuery(Table table, Object index) {
        this((Object)table, index);
    }

    public CreateIndexQuery(Object tableStr, Object index) {
        super(Converter.toCustomIndexSqlObject(index));
        this._table = Converter.toCustomTableSqlObject(tableStr);
    }

    public CreateIndexQuery setTableName(String nameName) {
        return this.setCustomTableName(nameName);
    }

    public CreateIndexQuery setCustomTableName(Object name) {
        this._table = Converter.toCustomTableSqlObject(name);
        return this;
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.INDEX, this._object);
    }

    @Override
    public CreateIndexQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._table.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append((CharSequence)"CREATE INDEX ").append((Appendee)this._object).append((CharSequence)" ON ").append((Appendee)this._table).append((CharSequence)" (").append((Appendee)this._columns).append((CharSequence)")");
        this.appendTableSpace(app);
    }
}

