/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.variants;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.GenericStringChooser;
import org.ut.biolab.medsavant.client.view.component.SelectableListView;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.GenomeContainer;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.PeekingPanel;
import org.ut.biolab.medsavant.client.view.variants.MedSavantDataSource;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.util.ServerRequest;
import savant.api.adapter.DataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.event.GenomeChangedEvent;
import savant.api.util.DialogUtils;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.TrackController;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.PersistentSettings;
import savant.util.ColourKey;
import savant.view.swing.Savant;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;
import savant.view.variation.VariationController;

public class BrowserPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(BrowserPage.class);
    private JPanel view;
    private JPanel browserPanel;
    private GenomeContainer genomeContainer;
    private PeekingPanel genomeView;
    private PeekingPanel variationPanel;
    private Component[] settingComponents;
    private boolean variantTrackLoaded = false;
    private static BrowserPage instance;
    private MedSavantDataSource msds;
    private final Semaphore trackAdditionLock = new Semaphore(1, true);
    boolean isDoneMappingIdsToBAMURLs = false;
    private List<String> dnaIDs;
    private ArrayList<String> sampleIdsHavingBams;
    private HashMap<String, String> dnaIDToURLMap;

    public static BrowserPage getInstance() {
        return instance;
    }

    public BrowserPage(MultiSectionApp parent) {
        super(parent, "Browser");
        instance = this;
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                BrowserPage.this.updateContents();
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    BrowserPage.this.updateContents();
                }
            }
        });
        this.startMappingDNAIdsToBAMURLs();
        GenomeController.getInstance().addListener((savant.api.util.Listener)new savant.api.util.Listener<GenomeChangedEvent>(){

            public void handleEvent(GenomeChangedEvent event) {
                if (!BrowserPage.this.variantTrackLoaded) {
                    try {
                        LOG.debug((Object)"Loading gene track");
                        String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
                        String urlOfTrack = BrowserPage.getTrackURL(referenceName, "gene");
                        BrowserPage.this.addTrackFromURLString(urlOfTrack, DataFormat.GENERIC_INTERVAL);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error loading gene track", (Throwable)ex);
                    }
                    try {
                        LOG.debug((Object)"Loading MedSavant variant track");
                        BrowserPage.this.msds = new MedSavantDataSource();
                        LOG.debug((Object)"Subscribing selection change listener");
                        Track t = TrackFactory.createTrack((DataSourceAdapter)BrowserPage.this.msds);
                        FrameController c = FrameController.getInstance();
                        c.createFrame(new Track[]{t});
                        BrowserPage.this.variantTrackLoaded = true;
                    }
                    catch (SavantTrackCreationCancelledException ex) {
                        LOG.error((Object)"Error loading MedSavant variant track", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Misc. error loading MedSavant variant track", (Throwable)ex);
                    }
                }
            }
        });
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        if (this.settingComponents == null) {
            while (this.genomeView == null && this.variationPanel == null) {
                try {
                    LOG.debug((Object)"Waiting for panels...");
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BrowserPage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.settingComponents = new Component[3];
            this.settingComponents[0] = PeekingPanel.getToggleButtonForPanel(this.genomeView, "Genome");
            this.settingComponents[1] = PeekingPanel.getToggleButtonForPanel(this.variationPanel, "Variation");
            this.settingComponents[2] = this.getUndockButton();
        }
        return this.settingComponents;
    }

    private void setupToolbarButtons(Savant savantInstance) {
        JPanel pluginToolbar = savantInstance.getPluginToolbar();
        try {
            String buttonStyle = "segmentedCapsule";
            JButton dnaButton = new JButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BAMFILE));
            dnaButton.setToolTipText("Open BAM File(s)");
            dnaButton.putClientProperty("JButton.buttonType", buttonStyle);
            dnaButton.putClientProperty("JButton.segmentPosition", "only");
            dnaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (BrowserPage.this.isDoneMappingIdsToBAMURLs) {
                        GenericStringChooser bamFileChooser = new GenericStringChooser(BrowserPage.this.sampleIdsHavingBams, "Open BAM File(s)");
                        bamFileChooser.setLocationRelativeTo(BrowserPage.this.view);
                        bamFileChooser.addListener(new Listener<SelectableListView.SelectionEvent>(){

                            @Override
                            public void handleEvent(SelectableListView.SelectionEvent event) {
                                List selections = event.getSelections();
                                for (Object o : selections) {
                                    String url = (String)BrowserPage.this.dnaIDToURLMap.get(o.toString());
                                    BrowserPage.this.addTrackFromURLString(url, DataFormat.ALIGNMENT);
                                }
                            }
                        });
                        bamFileChooser.setVisible(true);
                    } else {
                        DialogUtils.displayMessage((String)"Still collecting alignment file URLs, try again soon.");
                    }
                }
            });
            pluginToolbar.add(dnaButton);
            pluginToolbar.setVisible(true);
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR ", (Throwable)e);
        }
    }

    @Override
    public JPanel getView() {
        try {
            if (this.view == null) {
                this.trackAdditionLock.acquire();
                this.view = new JPanel();
                this.view.setLayout(new BorderLayout());
                this.view.add(new WaitPanel("Starting Genome Browser"));
                Chromosome[] chroms = MedSavantClient.ReferenceManager.getChromosomes(LoginController.getSessionID(), ReferenceController.getInstance().getCurrentReferenceID());
                this.genomeContainer = new GenomeContainer(this.pageName, chroms);
                this.genomeView = new PeekingPanel("Genome", "South", this.genomeContainer, false, 225);
                final JPanel variationPlaceHolder = new JPanel();
                variationPlaceHolder.setLayout(new BorderLayout());
                variationPlaceHolder.add((Component)new WaitPanel("Initializing variant views..."), "Center");
                this.variationPanel = new PeekingPanel("Variations", "West", variationPlaceHolder, false, 325);
                this.variationPanel.setToggleBarVisible(false);
                Runnable prepareBrowserThread = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            final JPanel tmpView = new JPanel();
                            tmpView.setLayout(new BorderLayout());
                            BrowserPage.this.genomeView.setToggleBarVisible(false);
                            tmpView.add((Component)((Object)BrowserPage.this.genomeView), "North");
                            BrowserPage.this.browserPanel = new JPanel();
                            BrowserPage.this.browserPanel.setLayout(new BorderLayout());
                            Savant savantInstance = Savant.getInstance((boolean)false, (boolean)false);
                            BrowserPage.this.setupToolbarButtons(savantInstance);
                            PersistentSettings.getInstance().setColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM, Color.white);
                            PersistentSettings.getInstance().setColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP, Color.white);
                            PersistentSettings.getInstance().setColor(ColourKey.AXIS_GRID, new Color(240, 240, 240));
                            savantInstance.setStartPageVisible(false);
                            savantInstance.setTrackBackground(new Color(210, 210, 210));
                            savantInstance.setBookmarksVisibile(false);
                            savantInstance.setVariantsVisibile(false);
                            variationPlaceHolder.removeAll();
                            variationPlaceHolder.add((Component)VariationController.getInstance().getModule(), "Center");
                            GenomeController.getInstance().setGenome(null);
                            String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
                            final String urlOfTrack = BrowserPage.getTrackURL(referenceName, "sequence");
                            BrowserPage.this.browserPanel.add((Component)savantInstance.getBrowserPanel(), "Center");
                            tmpView.add((Component)BrowserPage.this.browserPanel, "Center");
                            tmpView.add((Component)((Object)BrowserPage.this.variationPanel), "East");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserPage.this.view.removeAll();
                                    BrowserPage.this.view.add((Component)tmpView, "Center");
                                    BrowserPage.this.view.updateUI();
                                }
                            });
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserPage.this.addTrackFromURLString(urlOfTrack, DataFormat.SEQUENCE);
                                    BrowserPage.this.trackAdditionLock.release();
                                }
                            });
                            t.start();
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Got exception: " + ex));
                        }
                    }
                };
                new Thread(prepareBrowserThread).start();
            } else if (this.genomeContainer != null) {
                this.genomeContainer.updateIfRequired();
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error generating genome view: %s", ex);
        }
        return this.view;
    }

    public void addTrackFromURLString(String urlString, final DataFormat format) {
        try {
            final URL url = new URL(urlString);
            if (!TrackController.getInstance().containsTrack(urlString)) {
                if (this.view == null) {
                    this.getView();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BrowserPage.this.trackAdditionLock.acquire();
                                FrameController.getInstance().addTrackFromURI(url.toURI(), format, null);
                                BrowserPage.this.trackAdditionLock.release();
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex);
                            }
                        }
                    });
                    t.start();
                } else {
                    FrameController.getInstance().addTrackFromURI(url.toURI(), format, null);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    private static String getTrackURL(String referenceName, String trackName) throws Exception {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("reference", referenceName);
        requestMap.put("trackname", trackName);
        JSONObject o = ServerRequest.requestFromServer("browser/track", requestMap);
        String urlOfTrack = (String)o.get((Object)"url");
        return urlOfTrack;
    }

    @Override
    public void viewWillLoad() {
        super.viewWillLoad();
        this.genomeContainer.updateIfRequired();
        if (this.msds != null && this.variantTrackLoaded) {
            this.msds.refresh();
        }
    }

    @Override
    public void viewDidUnload() {
        super.viewDidUnload();
    }

    public void updateContents() {
        ThreadController.getInstance().cancelWorkers(this.pageName);
        if (this.genomeContainer == null) {
            return;
        }
        this.genomeContainer.setUpdateRequired(true);
        if (this.loaded) {
            this.genomeContainer.updateIfRequired();
        }
    }

    private void startMappingDNAIdsToBAMURLs() {
        this.dnaIDs = Arrays.asList(new String[0]);
        this.sampleIdsHavingBams = new ArrayList();
        this.dnaIDToURLMap = new HashMap();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserPage.this.dnaIDs = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.DNA_ID.getColumnName(), false);
                    for (String s : BrowserPage.this.dnaIDs) {
                        String url = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), s);
                        if (url == null || url.isEmpty()) continue;
                        BrowserPage.this.sampleIdsHavingBams.add(s);
                        String[] splitUrls = url.split(",");
                        BrowserPage.this.dnaIDToURLMap.put(s, splitUrls[0]);
                    }
                    BrowserPage.this.isDoneMappingIdsToBAMURLs = true;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
        });
    }
}

