/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.httpclient.NameValuePair;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.ut.biolab.medsavant.client.view.util.VerticalLabelUI;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;

public class PeekingPanel
extends JXCollapsiblePane {
    private final JComponent panel;
    private boolean isExpanded;
    private final JLabel title;
    public final String titleString;
    private final JPanel titlePanel;
    private final DockedSide dockedSide;

    public PeekingPanel(String label, String borderLayoutPosition, JComponent panel, boolean isExpanded) {
        this(label, borderLayoutPosition, panel, isExpanded, 350);
    }

    public PeekingPanel(String label, String borderLayoutPosition, JComponent panel, boolean isExpanded, int size) {
        boolean isVertical = borderLayoutPosition.equals("East") || borderLayoutPosition.equals("West");
        this.setAnimated(false);
        if (borderLayoutPosition.equals("North")) {
            this.dockedSide = DockedSide.NORTH;
            this.setDirection(JXCollapsiblePane.Direction.UP);
        } else if (borderLayoutPosition.equals("South")) {
            this.dockedSide = DockedSide.SOUTH;
            this.setDirection(JXCollapsiblePane.Direction.DOWN);
        } else if (borderLayoutPosition.equals("East")) {
            this.dockedSide = DockedSide.EAST;
            this.setDirection(JXCollapsiblePane.Direction.RIGHT);
        } else {
            this.dockedSide = DockedSide.WEST;
            this.setDirection(JXCollapsiblePane.Direction.LEFT);
        }
        this.setLayout(new BorderLayout());
        this.panel = panel;
        if (isVertical) {
            panel.setPreferredSize(new Dimension(size, 999));
        } else {
            panel.setPreferredSize(new Dimension(999, size));
        }
        this.titlePanel = new JPanel();
        this.titlePanel.setCursor(Cursor.getPredefinedCursor(12));
        this.titlePanel.setBorder(ViewUtil.getTinyBorder());
        if (isVertical) {
            this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 1));
        } else {
            this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        }
        this.titlePanel.add(Box.createHorizontalGlue());
        this.titleString = label.toUpperCase();
        this.title = new JLabel(" ");
        this.title.setForeground(Color.darkGray);
        if (borderLayoutPosition.equals("East")) {
            this.title.setUI(new VerticalLabelUI(true));
        } else if (borderLayoutPosition.equals("West")) {
            this.title.setUI(new VerticalLabelUI(false));
        }
        this.titlePanel.add(this.title);
        if (!isVertical) {
            this.titlePanel.add(Box.createHorizontalGlue());
        }
        this.titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PeekingPanel.this.toggleExpanded();
            }
        });
        this.add(this.titlePanel, borderLayoutPosition);
        this.add(panel, "Center");
        this.setExpanded(isExpanded);
    }

    public final void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        String s = (this.isExpanded ? " HIDE " + this.titleString : " SHOW " + this.titleString) + " ";
        this.titlePanel.setToolTipText(s);
        if (!this.isExpanded) {
            this.title.setText(s);
            this.title.setFont(ViewUtil.getTinyTitleFont());
            this.panel.setVisible(false);
        } else {
            this.title.setText(s);
            this.title.setFont(ViewUtil.getTinyTitleFont());
            this.panel.setVisible(true);
        }
        this.setCollapsed(!this.isExpanded);
    }

    public void toggleExpanded() {
        this.setExpanded(!this.isExpanded);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setToggleBarVisible(boolean b) {
        this.titlePanel.setVisible(b);
    }

    public static JToggleButton getToggleButtonForPanel(PeekingPanel persistencePanel) {
        return PeekingPanel.getToggleButtonForPanel(persistencePanel, persistencePanel.titleString);
    }

    public static JToggleButton getToggleButtonForPanel(final PeekingPanel persistencePanel, final String name) {
        final RevealToggleButton b = new RevealToggleButton(name, persistencePanel.getDockedSide());
        b.setFocusable(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                persistencePanel.setExpanded(b.isSelected());
                try {
                    AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("view-event", b.isSelected() ? "PanelShown" : "PanelHidden"), new NameValuePair("panel-name", name)});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        b.setSelected(persistencePanel.isExpanded);
        return b;
    }

    public DockedSide getDockedSide() {
        return this.dockedSide;
    }

    public static class RevealToggleButton
    extends JToggleButton {
        private final DockedSide side;

        public RevealToggleButton(String title, DockedSide side) {
            super(title);
            this.side = side;
            this.putClientProperty("JButton.buttonType", "segmentedTextured");
            switch (side) {
                case EAST: {
                    ViewUtil.positionButtonFirst(this);
                    break;
                }
                case WEST: {
                    ViewUtil.positionButtonLast(this);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    ViewUtil.positionButtonMiddle(this);
                }
            }
        }

        public DockedSide getSide() {
            return this.side;
        }
    }

    public static enum DockedSide {
        EAST,
        WEST,
        NORTH,
        SOUTH;

    }
}

