/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.notify;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.images.ImagePanel;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class NotificationsPanel
extends JPanel {
    private Log LOG = LogFactory.getLog(NotificationsPanel.class);
    int verticalOffset = 44;
    int inset = 10;
    int gap = 4;
    private final ArrayList<Notification> notifications = new ArrayList();
    private final HashMap<Notification, NotificationPanel> map = new HashMap();
    private JPanel npanelContainer;
    private List<JButton> menuButtons = new ArrayList<JButton>();
    private ImageIcon inactiveButtonIcon;
    private ImageIcon activeButtonIcon;
    private boolean isHidden = false;
    double duration = 1.0;
    int travelDistance = 400;

    public NotificationsPanel() {
        this.initUI();
    }

    public void addNotification(Notification n) {
        this.notifications.add(n);
        NotificationPanel notificationPanel = new NotificationPanel(n);
        notificationPanel.setParent(this);
        this.map.put(n, notificationPanel);
        this.updateView();
    }

    public void removeNotification(Notification n) {
        this.notifications.remove(n);
        this.map.remove(n);
        this.updateView();
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        NotificationsPanel p = new NotificationsPanel();
        for (int i = 0; i < 4; ++i) {
            Notification n = new Notification();
            n.setName("Hello World " + i);
            p.addNotification(n);
        }
        f.add(p);
        f.show();
    }

    private void initUI() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.npanelContainer = ViewUtil.getClearPanel();
        this.npanelContainer.setLayout((LayoutManager)new MigLayout(String.format("insets %d %d %d %d, gapy %d, fillx, alignx trailing, wrap, hidemode 3", this.verticalOffset + this.inset, this.inset, this.inset, this.inset, this.gap)));
        this.add((Component)this.npanelContainer, "East");
        this.inactiveButtonIcon = IconFactory.getInstance().getIcon("/org/ut/biolab/medsavant/client/view/images/icon/notifications-inactive.png");
        this.activeButtonIcon = IconFactory.getInstance().getIcon("/org/ut/biolab/medsavant/client/view/images/icon/notifications-active.png");
    }

    private void toggleVisibility() {
        this.isHidden = !this.isHidden;
        this.updateView();
    }

    private void updateView() {
        this.refreshButtonIcons();
        this.npanelContainer.removeAll();
        if (!this.isHidden) {
            for (Notification n : this.notifications) {
                this.npanelContainer.add(this.map.get(n));
            }
        }
        this.npanelContainer.updateUI();
    }

    private void refreshButtonIcons() {
        if (this.isHidden) {
            for (JButton menuButton : this.menuButtons) {
                menuButton.setIcon(this.inactiveButtonIcon);
                menuButton.setToolTipText("Show notifications");
            }
        } else {
            for (JButton menuButton : this.menuButtons) {
                menuButton.setIcon(this.activeButtonIcon);
                menuButton.setToolTipText("Hide notifications");
            }
        }
    }

    public JButton generateMenuButton() {
        JButton menuButton = ViewUtil.getTexturedButton("");
        menuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsPanel.this.toggleVisibility();
            }
        });
        this.menuButtons.add(menuButton);
        this.refreshButtonIcons();
        return menuButton;
    }

    private static class NotificationPanel
    extends JPanel
    implements Listener<Notification> {
        int height = 70;
        int leftWidth = 65;
        int middleWidth = 140;
        int rightWidth = 55;
        int insets = 8;
        int innerinsets = 2;
        private final Notification notification;
        private JLabel nameLabel;
        private JLabel subTextLabel;
        private JButton closeButton;
        private NotificationsPanel parentPanel;
        private JProgressBar progress;
        private Color subTextErrorColor = Color.red;
        private Color subTextNormalColor;
        private ActionListener closeActionListener;
        private ProgressWheel progressIndifinite;
        private JButton actionButton;

        public NotificationPanel(Notification n) {
            this.notification = n;
            n.addListener(this);
            this.initUI();
            this.refreshUI();
        }

        void setParent(NotificationsPanel parent) {
            this.parentPanel = parent;
        }

        @Override
        public void handleEvent(Notification event) {
            this.refreshUI();
        }

        private void refreshUI() {
            if (this.notification.isClosed()) {
                this.closeActionListener.actionPerformed(null);
            }
            this.setVisible(!this.notification.isHidden());
            this.nameLabel.setText(this.notification.getName());
            this.subTextLabel.setText(this.notification.getDescription());
            this.subTextLabel.setForeground(this.notification.getDescription().toLowerCase().contains("error") ? this.subTextErrorColor : this.subTextNormalColor);
            this.closeButton.setVisible(this.notification.canHide());
            ViewUtil.ellipsizeLabel(this.nameLabel, this.middleWidth - 2 * this.innerinsets);
            ViewUtil.ellipsizeLabel(this.subTextLabel, this.middleWidth - 2 * this.innerinsets);
            if (this.notification.isShowsProgress()) {
                this.progressIndifinite.setVisible(this.notification.isIndeterminateProgress());
                this.progress.setVisible(!this.notification.isIndeterminateProgress());
                this.progress.setValue((int)(this.notification.getProgress() * 100.0));
            } else {
                this.progressIndifinite.setVisible(false);
                this.progress.setVisible(false);
            }
            if (this.notification.getAction() != null) {
                this.actionButton.removeActionListener(this.notification.getAction());
                this.actionButton.addActionListener(this.notification.getAction());
                this.actionButton.setText(ViewUtil.ellipsize(this.notification.getActionName(), this.rightWidth - this.innerinsets - this.actionButton.getInsets().left - this.actionButton.getInsets().right));
                this.actionButton.setVisible(true);
            }
            this.updateUI();
        }

        private void initUI() {
            this.setOpaque(false);
            JPanel p = ViewUtil.getRoundedShadowedPanel(Color.white, new Color(245, 245, 245), 0.95f, 10, new Color(200, 200, 200), 7);
            ViewUtil.consumeMouseEventsForComponent(p);
            p.setLayout((LayoutManager)new MigLayout(String.format("fillx, insets %d, height %d", this.insets, this.height)));
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            JPanel leftSide = ViewUtil.getClearPanel();
            JPanel middle = ViewUtil.getClearPanel();
            JPanel rightSide = ViewUtil.getClearPanel();
            leftSide.setLayout((LayoutManager)new MigLayout(String.format("width %d, insets %d, hidemode 3", this.leftWidth, this.innerinsets)));
            middle.setLayout((LayoutManager)new MigLayout(String.format("width %d, insets %d, alignx left, fillx, wrap, gapy 2", this.middleWidth, this.innerinsets)));
            rightSide.setLayout((LayoutManager)new MigLayout(String.format("width %d, insets %d, alignx left, wrap, hidemode 3, wrap 1, gapy 2", this.rightWidth, this.innerinsets)));
            p.add(leftSide);
            p.add(middle);
            p.add(rightSide);
            this.nameLabel = ViewUtil.getSettingsHeaderLabel("");
            this.subTextLabel = ViewUtil.getSettingsHelpLabel("");
            this.closeActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NotificationPanel.this.parentPanel != null) {
                        NotificationPanel.this.parentPanel.removeNotification(NotificationPanel.this.notification);
                    }
                }
            };
            this.closeButton = ViewUtil.getTexturedButton("Hide");
            this.closeButton.addActionListener(this.closeActionListener);
            this.actionButton = ViewUtil.getTexturedButton("");
            this.actionButton.setVisible(false);
            this.progress = (JProgressBar)ViewUtil.makeMini(new JProgressBar());
            this.progressIndifinite = ViewUtil.getIndeterminateProgressBar();
            middle.add((Component)this.nameLabel, "growx 1.0");
            middle.add(this.subTextLabel);
            middle.add((Component)this.progress, "width 100%, hidemode 3");
            middle.add((Component)this.progressIndifinite, "hidemode 3");
            this.subTextNormalColor = this.subTextLabel.getForeground();
            this.progress.setVisible(false);
            this.progressIndifinite.setVisible(false);
            rightSide.add(this.closeButton);
            rightSide.add(this.actionButton);
            if (this.notification.getIcon() != null) {
                leftSide.removeAll();
                int dim = Math.min(this.height - 2 * this.insets - 2 * this.innerinsets, this.leftWidth - 2 * this.innerinsets);
                leftSide.add(new ImagePanel(this.notification.getIcon().getImage(), dim, dim));
            }
        }
    }
}

