/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.login;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.controller.ServerController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.component.NiceMenu;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.login.MedSavantServerInfo;
import org.ut.biolab.medsavant.client.view.login.SplashFrame;
import org.ut.biolab.medsavant.client.view.login.SplashServerManagementComponent;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.component.field.editable.EditableField;
import org.ut.biolab.medsavant.component.field.editable.EditableFieldValidator;
import org.ut.biolab.medsavant.component.field.editable.EnumEditableField;
import org.ut.biolab.medsavant.component.field.editable.FieldCommittedListener;
import org.ut.biolab.medsavant.component.field.editable.FieldEditedListener;
import org.ut.biolab.medsavant.component.field.editable.PasswordEditableField;
import org.ut.biolab.medsavant.component.field.editable.StringEditableField;
import org.ut.biolab.medsavant.component.field.validator.HostnameValidator;
import org.ut.biolab.medsavant.component.field.validator.NonEmptyStringValidator;
import org.ut.biolab.medsavant.component.field.validator.PositiveNumberValidator;

public class ServerDetailedView
extends DetailedView
implements FieldCommittedListener,
FieldEditedListener {
    private StringEditableField nameField;
    private StringEditableField hostField;
    private StringEditableField portField;
    private StringEditableField databaseField;
    private StringEditableField usernameField;
    private PasswordEditableField passwordField;
    private EnumEditableField rememberPasswordField;
    private final SplashServerManagementComponent serverManagementComponent;
    private MedSavantServerInfo server;
    private JButton chooseButton;
    private KeyValuePairPanel kvp;
    private final SplashFrame splash;

    public ServerDetailedView(SplashFrame splash, SplashServerManagementComponent serverManagementComponent) {
        super("Servers");
        this.serverManagementComponent = serverManagementComponent;
        this.splash = splash;
        this.setSelectedItem(null);
    }

    @Override
    public void setSelectedItem(Object[] selectedRow) {
        if (selectedRow == null || selectedRow.length == 0) {
            this.showBlockPanel();
            return;
        }
        MedSavantServerInfo server = (MedSavantServerInfo)selectedRow[1];
        this.showServerInfo(server);
    }

    @Override
    public void setMultipleSelections(List<Object[]> selectedRows) {
    }

    @Override
    public JPopupMenu createPopup() {
        return new JPopupMenu();
    }

    private KeyValuePairPanel getNiceFormForServer(final MedSavantServerInfo server) {
        String DBNAME_KEY = "Database name";
        final KeyValuePairPanel kvp = new KeyValuePairPanel(1, true);
        final NonEmptyStringValidator nonEmptyStringValidator = new NonEmptyStringValidator("server name");
        EditableFieldValidator<String> nameValidator = new EditableFieldValidator<String>(){

            public boolean validate(String value) {
                if (nonEmptyStringValidator.validate(value)) {
                    return !ServerDetailedView.this.isDifferentServerWithName(value, server);
                }
                return false;
            }

            public String getDescriptionOfValidValue() {
                return "Invalid name (must not be blank or already exist)";
            }
        };
        this.nameField = new StringEditableField();
        this.nameField.setName("Server name");
        this.nameField.setAutonomousEditingEnabled(false);
        this.nameField.setEditing(true);
        this.nameField.setValidator((EditableFieldValidator)nameValidator);
        this.nameField.setValue((Object)server.getNickname());
        this.hostField = new StringEditableField();
        this.hostField.setAutonomousEditingEnabled(false);
        this.hostField.setEditing(true);
        this.hostField.setValidator((EditableFieldValidator)new HostnameValidator());
        this.hostField.setValue((Object)server.getHost());
        this.portField = new StringEditableField();
        this.portField.setAutonomousEditingEnabled(false);
        this.portField.setEditing(true);
        this.portField.setValidator((EditableFieldValidator)new PositiveNumberValidator("port"));
        this.portField.setValue((Object)(server.getPort() + ""));
        this.databaseField = new StringEditableField();
        this.databaseField.setAutonomousEditingEnabled(false);
        this.databaseField.setEditing(true);
        this.databaseField.setValidator((EditableFieldValidator)new NonEmptyStringValidator("database name"));
        this.databaseField.setValue((Object)server.getDatabase());
        this.usernameField = new StringEditableField();
        this.usernameField.setAutonomousEditingEnabled(false);
        this.usernameField.setEditing(true);
        this.usernameField.setValidator((EditableFieldValidator)new NonEmptyStringValidator("username"));
        this.usernameField.setValue((Object)server.getUsername());
        this.passwordField = new PasswordEditableField();
        this.passwordField.setAutonomousEditingEnabled(false);
        this.passwordField.setEditing(true);
        this.passwordField.setValidator((EditableFieldValidator)new NonEmptyStringValidator("password"));
        this.passwordField.setValue((Object)server.getPassword());
        this.rememberPasswordField = new EnumEditableField((Object[])new String[]{"No", "Yes"});
        this.rememberPasswordField.setAutonomousEditingEnabled(false);
        this.rememberPasswordField.setEditing(true);
        this.rememberPasswordField.setValue((Object)(server.isRememberPassword() ? "Yes" : "No"));
        this.addCommitListenersToFields(new EditableField[]{this.nameField, this.hostField, this.portField, this.databaseField, this.usernameField, this.passwordField, this.rememberPasswordField});
        this.addChangeListenersToFields(new EditableField[]{this.nameField, this.hostField, this.portField, this.databaseField, this.usernameField, this.passwordField, this.rememberPasswordField});
        kvp.addKeyWithValue("Server name", (JComponent)this.nameField);
        kvp.addKeyWithValue("Host name", (JComponent)this.hostField);
        kvp.addKeyWithValue("Port", (JComponent)this.portField);
        kvp.addKeyWithValue("Username", (JComponent)this.usernameField);
        kvp.addKeyWithValue("Password", (JComponent)this.passwordField);
        kvp.addKeyWithValue("Remember password", (JComponent)this.rememberPasswordField);
        kvp.addKeyWithValue("Database name", (JComponent)this.databaseField);
        final JToggleButton adminButton = ViewUtil.getSoftToggleButton("Admin");
        JLabel adminLabel = ViewUtil.getSettingsHelpLabel("Requires administrative priviledges");
        JButton createDBButton = ViewUtil.getTexturedButton("Create Database");
        JButton deleteDBButton = ViewUtil.getTexturedButton("Delete Database");
        createDBButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Creating db");
                ServerDetailedView.this.createDatabaseSpecifiedByForm();
            }
        });
        deleteDBButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Deleting db");
                ServerDetailedView.this.deleteDatabaseSpecifiedByForm();
            }
        });
        JPanel adminPanel = ViewUtil.getClearPanel();
        adminPanel.setLayout((LayoutManager)new MigLayout("insets 0"));
        adminPanel.add((Component)adminLabel, "wrap");
        adminPanel.add((Component)createDBButton, "split");
        adminPanel.add((Component)deleteDBButton, "wrap");
        adminButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kvp.toggleDetailVisibility("Database name", adminButton.isSelected());
            }
        });
        kvp.setAdditionalColumn("Database name", 0, adminButton);
        kvp.setDetailComponent("Database name", adminPanel);
        kvp.toggleDetailVisibility("Database name", adminButton.isSelected());
        return kvp;
    }

    private boolean isDifferentServerWithName(String name, MedSavantServerInfo server) {
        MedSavantServerInfo existingServer = ServerController.getInstance().getServerNamed(name);
        boolean result = existingServer != null && !existingServer.equals(server);
        return result;
    }

    private void showServerInfo(final MedSavantServerInfo server) {
        if (this.server != null && server.getUniqueID().equals(this.server.getUniqueID())) {
            return;
        }
        System.out.println("Setting server to " + server.getNickname());
        this.server = server;
        this.removeAll();
        this.revalidate();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        JPanel container = ViewUtil.getClearPanel();
        NiceMenu bottomMenu = new NiceMenu(NiceMenu.MenuLocation.BOTTOM);
        bottomMenu.setOpaque(false);
        bottomMenu.setBorder(BorderFactory.createEmptyBorder());
        container.setLayout((LayoutManager)new MigLayout("fillx, insets 20, hidemode 3"));
        if (server == null) {
            return;
        }
        this.kvp = this.getNiceFormForServer(server);
        container.add((Component)this.kvp, "wrap, aligny top, growx 1.0, wmax 100%");
        this.chooseButton = ViewUtil.getTexturedButton("Connect");
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ServerDetailedView.this.validateServerSettings()) {
                    ServerController.getInstance().setCurrentServer(server);
                    ServerDetailedView.this.splash.switchToLogin();
                }
            }
        });
        bottomMenu.addRightComponent(this.chooseButton);
        this.add((Component)container, "Center");
        this.add((Component)bottomMenu, "South");
        this.updateUI();
    }

    private boolean validateServerSettings() {
        EditableField[] fields;
        for (EditableField f : fields = new EditableField[]{this.nameField, this.hostField, this.portField, this.usernameField, this.passwordField, this.rememberPasswordField, this.databaseField}) {
            if (f.validateCurrentValue()) continue;
            return false;
        }
        return true;
    }

    private void createDatabaseSpecifiedByForm() {
        String host = (String)this.hostField.getValue();
        int port = Integer.parseInt((String)this.portField.getValue());
        String database = (String)this.databaseField.getValue();
        String username = (String)this.usernameField.getValue();
        String password = (String)this.passwordField.getValue();
        this.createDatabase(host, port, database, username, password);
    }

    private void deleteDatabaseSpecifiedByForm() {
        String host = (String)this.hostField.getValue();
        int port = Integer.parseInt((String)this.portField.getValue());
        String database = (String)this.databaseField.getValue();
        String username = (String)this.usernameField.getValue();
        String password = (String)this.passwordField.getValue();
        this.removeDatabase(host, port, database, username, password);
    }

    private void removeDatabase(final String address, final int port, final String database, final String username, final String password) {
        if (DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This operation cannot be undone.", database) == 0) {
            new ProgressDialog("Removing Database", String.format("<html>Removing database <i>%s</i>. Please wait.</html>", database)){

                @Override
                public void run() {
                    try {
                        MedSavantClient.initializeRegistry(address, port + "");
                        MedSavantClient.SetupManager.removeDatabase(address, port, database, username, password.toCharArray());
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                this.setVisible(false);
                            }
                        });
                        ServerController.getInstance().removeServer(ServerDetailedView.this.server);
                        DialogUtils.displayMessage("Database Removed", String.format("<html>Database <i>%s</i> successfully removed.</html>", database));
                    }
                    catch (Exception ex) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    this.setVisible(false);
                                }
                            });
                        }
                        catch (Exception ex1) {
                            Logger.getLogger(SplashFrame.class.getName()).log(Level.SEVERE, null, ex1);
                        }
                        ClientMiscUtils.reportError("Database could not be removed: %s", ex);
                    }
                }
            }.setVisible(true);
        }
    }

    private void createDatabase(final String address, final int port, final String database, final String username, final String password) {
        if (DialogUtils.askYesNo("Create Database", String.format("<html>Are you sure you want to create the database <i>%s</i>?</html>", database)) == 0) {
            new ProgressDialog("Creating Database", String.format("<html>Creating database <i>%s</i>. Please wait.</html>", database)){

                @Override
                public void run() {
                    try {
                        MedSavantClient.initializeRegistry(address, port + "");
                        MedSavantClient.SetupManager.createDatabase(address, port, database, username, password.toCharArray());
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                this.setVisible(false);
                            }
                        });
                        ServerDetailedView.this.doSave();
                        DialogUtils.displayMessage("Database Created", String.format("<html>Database <i>%s</i> successfully created.</html>", database));
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    this.setVisible(false);
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ClientMiscUtils.reportError("Database could not be created: %s\nPlease check the settings and try again.", ex);
                    }
                }
            }.setVisible(true);
        }
    }

    private void showBlockPanel() {
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("center, fillx, filly, wrap 1"));
        WaitPanel blockCard = new WaitPanel("No server selected");
        blockCard.setProgressBarVisible(false);
        this.add((Component)blockCard, "width 100%, height 100%");
        this.updateUI();
    }

    private void doSave() {
        this.doSave(true);
    }

    private void doSave(boolean requiresListRefresh) {
        String name = (String)this.nameField.getValue();
        String host = (String)this.hostField.getValue();
        Integer portInt = Integer.parseInt((String)this.portField.getValue());
        int port = portInt == null ? 0 : portInt;
        String database = (String)this.databaseField.getValue();
        String username = (String)this.usernameField.getValue();
        String password = (String)this.passwordField.getValue();
        boolean rememberPass = this.rememberPasswordField.getValue().equals("Yes");
        this.server.setHost(host);
        this.server.setPort(port);
        this.server.setDatabase(database);
        this.server.setNickname(name);
        this.server.setUsername(username);
        this.server.setPassword(password);
        this.server.setRememberPassword(rememberPass);
        if (this.isDifferentServerWithName(this.server.getNickname(), this.server)) {
            System.out.println("Not saving with duplicate server name");
            return;
        }
        ServerController.getInstance().saveServers(requiresListRefresh);
        this.serverManagementComponent.getServerList().selectItemWithKey(name);
    }

    public void handleCommitEvent(EditableField f) {
        this.doSave();
    }

    public void handleEditEvent(EditableField f) {
        if (f.validateCurrentValue()) {
            this.doSave(false);
            if (f.getName() != null && f.getName().equals("Server name")) {
                this.parent.setSelectedItemText(f.getValue().toString());
            }
        }
    }

    private void addCommitListenersToFields(EditableField ... fields) {
        for (EditableField f : fields) {
            f.addFieldComittedListener((FieldCommittedListener)this);
        }
    }

    private void addChangeListenersToFields(EditableField ... fields) {
        for (EditableField f : fields) {
            f.addFieldEditedListener((FieldEditedListener)this);
        }
    }
}

