/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.TablePanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.VariantComment;
import org.ut.biolab.medsavant.shared.util.SQLUtils;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class SocialVariantSubInspector
extends SubInspector
implements Listener<VariantRecord> {
    private VariantRecord selectedVariant;
    private final JTextArea ta = new JTextArea();
    private JPanel existingCommentsPanel;

    public SocialVariantSubInspector() {
        TablePanel.addVariantSelectionChangedListener(this);
    }

    @Override
    public String getName() {
        return "Comments";
    }

    @Override
    public JPanel getInfoPanel() {
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        this.existingCommentsPanel = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(this.existingCommentsPanel);
        p.add(ViewUtil.getClearBorderlessScrollPane(this.ta));
        JButton submit = new JButton("Submit");
        ViewUtil.makeSmall(submit);
        p.add(ViewUtil.alignRight(submit));
        final SocialVariantSubInspector instance = this;
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println("Commenting on " + SocialVariantSubInspector.this.selectedVariant);
                ArrayList<VariantComment> list = new ArrayList<VariantComment>();
                VariantComment sv = new VariantComment(ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), SocialVariantSubInspector.this.selectedVariant.getUploadID(), SocialVariantSubInspector.this.selectedVariant.getFileID(), SocialVariantSubInspector.this.selectedVariant.getVariantID(), LoginController.getInstance().getUserName(), SocialVariantSubInspector.this.ta.getText(), SQLUtils.getCurrentTimestamp());
                list.add(sv);
                try {
                    MedSavantClient.VariantManager.addVariantComments(LoginController.getSessionID(), list);
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Error adding variant comments: %s", ex);
                }
                SocialVariantSubInspector.this.ta.setText("");
                instance.updateComments();
            }
        });
        p.add(this.existingCommentsPanel);
        this.ta.setBorder(ViewUtil.getTinyLineBorder());
        this.ta.setRows(3);
        this.ta.setColumns(10);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        return p;
    }

    @Override
    public void handleEvent(VariantRecord r) {
        this.selectedVariant = r;
        this.ta.setText("");
        this.updateComments();
    }

    private void updateComments() {
        this.existingCommentsPanel.removeAll();
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        kvp.setKeysVisible(false);
        this.existingCommentsPanel.add(kvp);
        try {
            List<VariantComment> comments = MedSavantClient.VariantManager.getVariantComments(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), this.selectedVariant.getUploadID(), this.selectedVariant.getFileID(), this.selectedVariant.getVariantID());
            Collections.reverse(comments);
            this.parent.setTitle(this.getName() + (comments.isEmpty() ? "" : " (" + comments.size() + ")"));
            int row = 0;
            for (VariantComment sv : comments) {
                String key = row++ + "";
                if (row == 5) {
                    kvp.addMoreRow();
                }
                kvp.addKey(key);
                kvp.setValue(key, new StarredVariantCommentPanel(sv));
            }
            this.existingCommentsPanel.revalidate();
            this.existingCommentsPanel.repaint();
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error updating comments: %s", ex);
        }
    }

    class StarredVariantCommentPanel
    extends JPanel {
        private JLabel userLabel;
        private JLabel timeStampLabel;
        private JTextArea textArea;
        private final VariantComment comment;

        public StarredVariantCommentPanel(VariantComment v) {
            this.setOpaque(false);
            this.setBorder(ViewUtil.getSmallBorder());
            this.comment = v;
            this.initComponents();
            this.userLabel.setText(v.getUser());
            this.timeStampLabel.setText(v.getTimestamp().toLocaleString());
            this.textArea.setText(v.getDescription());
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 18;
            JPanel header = ViewUtil.getClearPanel();
            ViewUtil.applyHorizontalBoxLayout(header);
            JPanel h2 = ViewUtil.getClearPanel();
            ViewUtil.applyVerticalBoxLayout(h2);
            this.userLabel = new JLabel();
            this.userLabel.setFont(ViewUtil.getTinyTitleFont());
            this.timeStampLabel = new JLabel();
            h2.add(this.userLabel);
            h2.add(this.timeStampLabel);
            header.add(h2);
            header.add(Box.createHorizontalGlue());
            if (this.comment.getUser().equals(LoginController.getInstance().getUserName())) {
                JButton rem = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLEAR));
                header.add(rem);
                rem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ArrayList<VariantComment> list = new ArrayList<VariantComment>();
                        list.add(StarredVariantCommentPanel.this.comment);
                        try {
                            MedSavantClient.VariantManager.removeVariantComments(LoginController.getSessionID(), list);
                        }
                        catch (Exception ex) {
                            ClientMiscUtils.reportError("Error removing variant comments: %s", ex);
                        }
                        SocialVariantSubInspector.this.updateComments();
                    }
                });
            }
            this.textArea = new JTextArea("");
            this.textArea.setOpaque(false);
            this.textArea.setColumns(20);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setEditable(false);
            this.textArea.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            this.add((Component)header, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.fill = 3;
            this.add((Component)this.textArea, c);
            Font defaultFont = header.getFont();
            Font userFont = new Font(defaultFont.getFamily(), 1, 12);
            Font timeStampFont = new Font(defaultFont.getFamily(), 0, 9);
            this.userLabel.setFont(userFont);
            this.timeStampLabel.setFont(timeStampFont);
            this.timeStampLabel.setForeground(Color.gray);
            this.textArea.setForeground(Color.darkGray);
        }
    }
}

