/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OtherIndividualsTableModel;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SimpleVariant;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.VariantFrequencyAggregatePane;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public abstract class OtherIndividualsSubInspector
extends SubInspector {
    private static final Log LOG = LogFactory.getLog(OtherIndividualsSubInspector.class);
    protected static final int MAXIMIUM_VARIANTS_TO_FETCH = 1000;
    private static final int ROW_HEIGHT = 24;
    protected static final Dimension PREFERRED_SIZE = new Dimension(300, 300);
    protected Map<String, Set<VariantRecord>> dnaIDVariantMap;
    private Set<VariantRecord> variantRecords;
    private MedSavantWorker<Void> variantFetcherThread;
    private OtherIndividualsTableModel otherIndividualsTableModel = new OtherIndividualsTableModel();
    private HierarchicalTable hTable;
    private JPanel infoPanel;
    private Listener<Object> variantSelectionListener;
    private SimpleVariant simpleVariant;
    private JPanel innerPanel;
    private boolean aggregatePaneUpdated = false;
    private SplitScreenPanel splitScreenPanel;
    private VariantFrequencyAggregatePane aggregatePane;
    private String firstCol;

    protected final Set<VariantRecord> getVariantRecords(String dnaID) {
        if (this.dnaIDVariantMap != null) {
            return this.dnaIDVariantMap.get(dnaID);
        }
        return null;
    }

    private void openAggregatePane(String column) {
        if (!this.aggregatePaneUpdated) {
            this.aggregatePane.setVariantRecords(this.variantRecords);
        }
        this.aggregatePane.splitScreen();
        this.aggregatePaneUpdated = true;
        this.aggregatePane.groupBy(column);
        this.firstCol = column;
    }

    public OtherIndividualsSubInspector(SplitScreenPanel sp) {
        this.splitScreenPanel = sp;
    }

    protected final void init(VariantFrequencyAggregatePane ap) {
        this.aggregatePane = ap;
        ap.setSplitScreenPanel(this.splitScreenPanel);
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BoxLayout(this.innerPanel, 1));
        this.initHierarchicalTable();
        JScrollPane jsp = new JScrollPane((Component)this.hTable);
        jsp.setPreferredSize(PREFERRED_SIZE);
        this.innerPanel.add(jsp);
        this.innerPanel.setPreferredSize(PREFERRED_SIZE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JButton cohortButton = new JButton("\u2190 " + this.aggregatePane.getTitle("Cohort"));
        cohortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OtherIndividualsSubInspector.this.openAggregatePane("Cohort");
            }
        });
        JButton familyButton = new JButton("\u2190 " + this.aggregatePane.getTitle(BasicPatientColumns.FAMILY_ID.getAlias()));
        familyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OtherIndividualsSubInspector.this.openAggregatePane(BasicPatientColumns.FAMILY_ID.getAlias());
            }
        });
        buttonPanel.add(cohortButton);
        buttonPanel.add(familyButton);
        this.innerPanel.add(buttonPanel);
        this.firstCol = "Cohort";
    }

    protected void selectVariant(VariantRecord vr) {
        System.out.println("OtherIndividualsSubInspector.selectVariant");
        if (this.variantSelectionListener != null) {
            this.variantSelectionListener.handleEvent(vr);
        }
    }

    public void setVariantSelectionListener(Listener<Object> l) {
        this.variantSelectionListener = l;
        this.aggregatePane.setVariantSelectionListener(l);
    }

    protected abstract JPanel getIndividualSummaryPanel(String var1);

    private HierarchicalTable initHierarchicalTable() {
        this.hTable = new HierarchicalTable();
        this.hTable.setModel((TableModel)this.otherIndividualsTableModel);
        this.hTable.setHierarchicalColumn(-1);
        this.hTable.setName("Individuals");
        this.hTable.setRowHeight(24);
        this.hTable.setSingleExpansion(true);
        this.hTable.setShowGrid(false);
        this.hTable.setTableHeader(null);
        this.hTable.setSelectInsertedRows(false);
        this.hTable.setSelectionMode(0);
        this.hTable.setComponentFactory(new HierarchicalTableComponentFactory(){

            public Component createChildComponent(HierarchicalTable table, Object value, int row) {
                if (value instanceof String) {
                    return OtherIndividualsSubInspector.this.getIndividualSummaryPanel((String)value);
                }
                return null;
            }

            public void destroyChildComponent(HierarchicalTable table, Component component, int row) {
            }
        });
        this.hTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = OtherIndividualsSubInspector.this.hTable.getSelectedRow();
                if (row != -1) {
                    OtherIndividualsSubInspector.this.hTable.expandRow(row);
                }
            }
        });
        return this.hTable;
    }

    private synchronized void buildDnaIDVariantMap(List<Object[]> values) {
        this.dnaIDVariantMap = new HashMap<String, Set<VariantRecord>>();
        this.variantRecords = new HashSet<VariantRecord>();
        for (Object[] row : values) {
            String dnaID = (String)row[3];
            String ref = (String)row[8];
            String alt = (String)row[9];
            VariantRecord r = new VariantRecord((Integer)row[0], (Integer)row[1], (Integer)row[2], ReferenceController.getInstance().getCurrentReferenceID(), 0, (String)row[3], (String)row[4], ((Integer)row[5]).intValue(), ((Integer)row[6]).intValue(), (String)row[7], (String)row[8], (String)row[9], (Integer)row[10], ((Float)row[11]).floatValue(), (String)row[12], (String)row[16], new Object[0]);
            String type = (String)row[13];
            String zygosity = (String)row[14];
            String genotype = (String)row[15];
            r.setType(VariantRecord.VariantType.valueOf(type));
            try {
                r.setZygosity(VariantRecord.Zygosity.valueOf(zygosity));
            }
            catch (Exception ex) {
                // empty catch block
            }
            r.setGenotype(genotype);
            Set<VariantRecord> m = this.dnaIDVariantMap.get(dnaID);
            if (m == null) {
                m = new HashSet<VariantRecord>();
            }
            m.add(r);
            this.dnaIDVariantMap.put(dnaID, m);
            this.variantRecords.add(r);
        }
    }

    public void handleEvent(Object event) {
        if (this.setObject(event)) {
            this.updateSelection();
        } else if (this.aggregatePane.isSplit()) {
            this.openAggregatePane(this.firstCol);
        }
    }

    public abstract boolean setObject(Object var1);

    protected void updateSelection() {
        this.aggregatePaneUpdated = false;
        this.infoPanel.removeAll();
        this.infoPanel.add(new WaitPanel("Loading DNA IDs..."));
        if (this.aggregatePane.isSplit()) {
            this.aggregatePane.showWaitPanel("Loading DNA IDs...");
        }
        if (this.variantFetcherThread != null && this.variantFetcherThread.getState() == SwingWorker.StateValue.STARTED) {
            this.variantFetcherThread.cancel(true);
        }
        this.variantFetcherThread = new MedSavantWorker<Void>("SubInspector"){

            @Override
            protected void showSuccess(Void result) {
                OtherIndividualsSubInspector.this.otherIndividualsTableModel.setValues(OtherIndividualsSubInspector.this.dnaIDVariantMap.keySet());
                if (OtherIndividualsSubInspector.this.aggregatePane.isSplit()) {
                    OtherIndividualsSubInspector.this.openAggregatePane(OtherIndividualsSubInspector.this.firstCol);
                }
                OtherIndividualsSubInspector.this.hTable.clearSelection();
                OtherIndividualsSubInspector.this.hTable.revalidate();
                OtherIndividualsSubInspector.this.hTable.repaint();
                OtherIndividualsSubInspector.this.infoPanel.removeAll();
                OtherIndividualsSubInspector.this.infoPanel.add(OtherIndividualsSubInspector.this.innerPanel);
                OtherIndividualsSubInspector.this.infoPanel.revalidate();
                OtherIndividualsSubInspector.this.infoPanel.repaint();
            }

            @Override
            protected Void doInBackground() throws Exception {
                OtherIndividualsSubInspector.this.buildDnaIDVariantMap(OtherIndividualsSubInspector.this.getQueryResults());
                return null;
            }
        };
        this.variantFetcherThread.execute();
    }

    protected abstract List<Object[]> getQueryResults();

    @Override
    public JPanel getInfoPanel() {
        return this.infoPanel;
    }
}

