/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.BAMFileComm;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticGeneInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticInspectorPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;
import savant.controller.LocationController;
import savant.util.Range;

public class DetailedVariantSubInspector
extends SubInspector
implements BasicVariantColumns {
    private static final String KEY_DNAID = "DNA ID";
    private static final String KEY_QUAL = "Quality";
    private static final String KEY_DBSNP = "dbSNP ID";
    private static final String KEY_ZYGOSITY = "Zygosity";
    private static final String KEY_INFO = "Info";
    private static final String URL_CHARSET = "UTF-8";
    private KeyValuePairPanel p;
    private JComboBox geneBox;
    private VariantRecord selectedVariant;
    private static final Log LOG = LogFactory.getLog(DetailedVariantSubInspector.class);

    @Override
    public String getName() {
        return "Detailed Variant Information";
    }

    public boolean showHeader() {
        return false;
    }

    private String checkNull(Object o) {
        if (o == null) {
            return "<NONE>";
        }
        String s = o.toString();
        if (s.equals("")) {
            return "<NONE>";
        }
        return s;
    }

    private Component getFilterButton(String key) {
        JButton button = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FILTER));
        button.setToolTipText("Filter " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        return button;
    }

    private Component getChartButton(final String key) {
        JToggleButton button = ViewUtil.getTexturedToggleButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CHART_SMALL));
        button.setToolTipText("Chart " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DetailedVariantSubInspector.this.p.toggleDetailVisibility(key);
            }
        });
        return button;
    }

    private Component getNCBIButton(final String key) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " at NCBI");
        ncbiButton.addActionListener(new ActionListener(){
            String baseUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = new URL(this.baseUrl + URLEncoder.encode(DetailedVariantSubInspector.this.p.getValue(key), DetailedVariantSubInspector.URL_CHARSET));
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching NCBI website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    private KeyValuePairPanel getInfoKVPPanel(String customInfo) {
        String[] pairs = customInfo.split(";");
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        for (String pair : pairs) {
            String[] splitPair = pair.split("=");
            if (splitPair.length != 2) continue;
            kvp.addKey(splitPair[0]);
            kvp.setValue(splitPair[0], splitPair[1]);
        }
        return kvp;
    }

    public void setVariantID(int variantID) {
        DbColumn vIDCol = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(VARIANT_ID);
        Condition[][] conditions = new Condition[1][1];
        conditions[0][0] = BinaryConditionMS.equalTo(vIDCol, variantID);
        try {
            List<Object[]> rows = MedSavantClient.VariantManager.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditions, 0, 1);
            Object[] row = rows.get(0);
            VariantRecord r = new VariantRecord((Integer)row[0], (Integer)row[1], (Integer)row[2], ReferenceController.getInstance().getCurrentReferenceID(), 0, (String)row[3], (String)row[4], ((Integer)row[5]).intValue(), ((Integer)row[6]).intValue(), (String)row[7], (String)row[8], (String)row[9], (Integer)row[10], ((Float)row[11]).floatValue(), (String)row[12], (String)row[16], new Object[0]);
            String type = (String)row[13];
            String zygosity = (String)row[14];
            String genotype = (String)row[15];
            r.setType(VariantRecord.VariantType.valueOf(type));
            r.setZygosity(VariantRecord.Zygosity.valueOf(zygosity));
            r.setGenotype(genotype);
            this.setVariantRecord(r);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.p == null) {
            this.p = new KeyValuePairPanel(4);
            this.p.addKey(KEY_DNAID);
            this.p.addKey(KEY_ZYGOSITY);
            this.p.addKey(KEY_QUAL);
            this.p.addKey(KEY_DBSNP);
            this.p.addKey(KEY_INFO);
            JButton genomeBrowserButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BROWSER));
            genomeBrowserButton.setToolTipText("View region in genome browser");
            genomeBrowserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LocationController.getInstance().setLocation(DetailedVariantSubInspector.this.selectedVariant.getChrom(), new Range((int)(DetailedVariantSubInspector.this.selectedVariant.getStartPosition() - 20L), (int)(DetailedVariantSubInspector.this.selectedVariant.getEndPosition() + 21L)));
                    AppDirectory.launchApp(AppDirectory.BuiltInApp.GENOME_BROWSER);
                }
            });
            JButton bamButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BAMFILE));
            bamButton.setToolTipText("<html>Load read alignments for this<br/> sample in genome browser</html>");
            bamButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Set handlers = AppCommRegistry.getInstance().getHandlersForEvent(BAMFileComm.class);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    String dnaID = DetailedVariantSubInspector.this.selectedVariant.getDnaID();
                    try {
                        String bamPath = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), dnaID);
                        if (bamPath != null && !bamPath.equals("")) {
                            AppCommHandler handler = (AppCommHandler)handlers.iterator().next();
                            handler.handleCommEvent((Object)new BAMFileComm(null, new URL(bamPath)));
                        }
                    }
                    catch (Exception ex) {
                        ClientMiscUtils.reportError("Unable to load BAM file: %s", ex);
                    }
                }
            });
            JButton geneInspectorButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INSPECTOR));
            geneInspectorButton.setToolTipText("Inspect this gene");
            geneInspectorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    StaticGeneInspector.getInstance().setGene((Gene)DetailedVariantSubInspector.this.geneBox.getSelectedItem());
                    StaticInspectorPanel.getInstance().switchToGeneInspector();
                }
            });
            JLabel l = new JLabel("This will eventually show a chart");
            final JToggleButton button = ViewUtil.getTexturedToggleButton("SHOW");
            ViewUtil.makeSmall(button);
            button.setToolTipText("Toggle Info");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DetailedVariantSubInspector.this.p.toggleDetailVisibility(DetailedVariantSubInspector.KEY_INFO);
                    button.setText(button.isSelected() ? "HIDE" : "SHOW");
                }
            });
            this.p.setValue(KEY_INFO, button);
            int col = 0;
            this.p.setAdditionalColumn(KEY_DNAID, col, KeyValuePairPanel.getCopyButton(KEY_DNAID, this.p));
            this.p.setAdditionalColumn(KEY_DBSNP, col, KeyValuePairPanel.getCopyButton(KEY_DBSNP, this.p));
            this.p.setAdditionalColumn(KEY_DBSNP, ++col, this.getNCBIButton(KEY_DBSNP));
            this.p.setAdditionalColumn(KEY_DNAID, col, bamButton);
        }
        return this.p;
    }

    public void setVariantRecord(VariantRecord r) {
        if (this.p == null) {
            return;
        }
        if (r == null) {
            return;
        }
        this.selectedVariant = r;
        this.p.setValue(KEY_DNAID, r.getDnaID());
        this.p.setValue(KEY_ZYGOSITY, this.checkNull((Object)r.getZygosity()));
        this.p.setValue(KEY_QUAL, ViewUtil.numToString(r.getQual().floatValue()));
        this.p.setValue(KEY_DBSNP, this.checkNull(r.getDbSNPID()));
        this.p.simpleEllipsify();
        KeyValuePairPanel infoPanel = this.getInfoKVPPanel(r.getCustomInfo());
        infoPanel.ellipsifyValues(300);
        this.p.setDetailComponent(KEY_INFO, infoPanel);
        try {
            String bamPath = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), r.getDnaID());
            JButton bamButton = (JButton)this.p.getAdditionalColumn(KEY_DNAID, 1);
            if (bamPath != null && !bamPath.equals("")) {
                bamButton.setVisible(true);
            } else {
                bamButton.setVisible(false);
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to get BAM path for DNA ID: %s", ex);
        }
    }
}

