/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommHandler;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.AppCommRegistry;
import edu.toronto.cs.medsavant.medsavant.app.api.appcomm.BAMFileComm;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticGeneInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticInspectorPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticVariantInspector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;
import savant.controller.LocationController;
import savant.util.Range;

public class BasicVariantSubInspector
extends SubInspector
implements Listener<VariantRecord> {
    private static final String KEY_DNAID = "DNA ID";
    private static final String KEY_START_POSITION = "Start Position";
    private static final String KEY_GENES = "Genes";
    private static final String KEY_REF = "Reference";
    private static final String KEY_ALT = "Alternate";
    private static final String KEY_QUAL = "Quality";
    private static final String KEY_DBSNP = "dbSNP ID";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_ZYGOSITY = "Zygosity";
    private static final String KEY_INFO = "Info";
    private static final String URL_CHARSET = "UTF-8";
    private Collection<Gene> genes;
    private KeyValuePairPanel p;
    private JComboBox geneBox;
    private VariantRecord selectedVariant;

    public BasicVariantSubInspector() {
        StaticVariantInspector.addVariantSelectionChangedListener(this);
    }

    @Override
    public String getName() {
        return "Variant Details";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.p == null) {
            this.p = new KeyValuePairPanel(4);
            this.p.addKey(KEY_DNAID);
            this.p.addKey(KEY_START_POSITION);
            this.p.addKey(KEY_REF);
            this.p.addKey(KEY_ALT);
            this.p.addKey(KEY_TYPE);
            this.p.addKey(KEY_ZYGOSITY);
            this.p.addKey(KEY_QUAL);
            this.p.addKey(KEY_DBSNP);
            this.p.addKey(KEY_GENES);
            this.p.addKey(KEY_INFO);
            this.geneBox = new JComboBox();
            ViewUtil.makeSmall(this.geneBox);
            this.p.setValue(KEY_GENES, this.geneBox);
            JButton genomeBrowserButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BROWSER));
            genomeBrowserButton.setToolTipText("View region in genome browser");
            genomeBrowserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LocationController.getInstance().setLocation(BasicVariantSubInspector.this.selectedVariant.getChrom(), new Range((int)(BasicVariantSubInspector.this.selectedVariant.getStartPosition() - 20L), (int)(BasicVariantSubInspector.this.selectedVariant.getEndPosition() + 21L)));
                    AppDirectory.launchApp(AppDirectory.BuiltInApp.GENOME_BROWSER);
                }
            });
            JButton bamButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BAMFILE));
            bamButton.setToolTipText("<html>Load read alignments for this<br/> sample in genome browser</html>");
            bamButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Set handlers = AppCommRegistry.getInstance().getHandlersForEvent(BAMFileComm.class);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    String dnaID = BasicVariantSubInspector.this.selectedVariant.getDnaID();
                    try {
                        boolean response;
                        String bamPath = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), dnaID);
                        if (bamPath != null && !bamPath.equals("") && !(response = false)) {
                            AppCommHandler handler = (AppCommHandler)handlers.iterator().next();
                            handler.handleCommEvent((Object)new BAMFileComm(null, new URL(bamPath)));
                        }
                    }
                    catch (Exception ex) {
                        ClientMiscUtils.reportError("Unable to load BAM file: %s", ex);
                    }
                }
            });
            JButton geneInspectorButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INSPECTOR));
            geneInspectorButton.setToolTipText("Inspect this gene");
            geneInspectorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    StaticGeneInspector.getInstance().setGene((Gene)BasicVariantSubInspector.this.geneBox.getSelectedItem());
                    StaticInspectorPanel.getInstance().switchToGeneInspector();
                }
            });
            this.p.setAdditionalColumn(KEY_GENES, 0, geneInspectorButton);
            final JToggleButton button = ViewUtil.getTexturedToggleButton("SHOW");
            ViewUtil.makeSmall(button);
            button.setToolTipText("Toggle Info");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BasicVariantSubInspector.this.p.toggleDetailVisibility(BasicVariantSubInspector.KEY_INFO);
                    button.setText(button.isSelected() ? "HIDE" : "SHOW");
                }
            });
            this.p.setValue(KEY_INFO, button);
            int col = 0;
            this.p.setAdditionalColumn(KEY_DNAID, col, KeyValuePairPanel.getCopyButton(KEY_DNAID, this.p));
            this.p.setAdditionalColumn(KEY_DBSNP, col, KeyValuePairPanel.getCopyButton(KEY_DBSNP, this.p));
            this.p.setAdditionalColumn(KEY_START_POSITION, col, KeyValuePairPanel.getCopyButton(KEY_START_POSITION, this.p));
            this.p.setAdditionalColumn(KEY_DBSNP, ++col, this.getNCBIButton(KEY_DBSNP));
            this.p.setAdditionalColumn(KEY_START_POSITION, col, genomeBrowserButton);
            this.p.setAdditionalColumn(KEY_DNAID, col, bamButton);
        }
        return this.p;
    }

    public boolean showHeader() {
        return false;
    }

    private String checkNull(Object o) {
        if (o == null) {
            return "<NONE>";
        }
        String s = o.toString();
        if (s.equals("")) {
            return "<NONE>";
        }
        return s;
    }

    @Override
    public void handleEvent(VariantRecord r) {
        if (this.p == null) {
            return;
        }
        if (r == null) {
            return;
        }
        this.selectedVariant = r;
        this.p.setValue(KEY_DNAID, r.getDnaID());
        if (r.getStartPosition() == r.getEndPosition()) {
            this.p.setValue(KEY_START_POSITION, r.getChrom() + ":" + ViewUtil.numToString(r.getStartPosition()));
        } else {
            this.p.setValue(KEY_START_POSITION, r.getChrom() + ":" + ViewUtil.numToString(r.getStartPosition()));
        }
        this.p.setValue(KEY_REF, r.getRef());
        this.p.setValue(KEY_ALT, r.getAlt());
        this.p.setValue(KEY_TYPE, this.checkNull((Object)r.getType()));
        this.p.setValue(KEY_ZYGOSITY, this.checkNull((Object)r.getZygosity()));
        this.p.setValue(KEY_QUAL, ViewUtil.numToString(r.getQual().floatValue()));
        this.p.setValue(KEY_DBSNP, this.checkNull(r.getDbSNPID()));
        this.p.ellipsifyValues(300);
        KeyValuePairPanel infoPanel = this.getInfoKVPPanel(r.getCustomInfo());
        infoPanel.ellipsifyValues(300);
        this.p.setDetailComponent(KEY_INFO, infoPanel);
        try {
            String bamPath = MedSavantClient.PatientManager.getReadAlignmentPathForDNAID(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), r.getDnaID());
            JButton bamButton = (JButton)this.p.getAdditionalColumn(KEY_DNAID, 1);
            if (bamPath != null && !bamPath.equals("")) {
                bamButton.setVisible(true);
            } else {
                bamButton.setVisible(false);
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to get BAM path for DNA ID: %s", ex);
        }
        this.generateGeneIntersections(r);
    }

    private void generateGeneIntersections(VariantRecord r) {
        try {
            if (this.genes == null) {
                this.genes = GeneSetController.getInstance().getCurrentGenes();
            }
            Gene g0 = null;
            JComboBox b = this.geneBox;
            b.removeAllItems();
            for (Gene g : this.genes) {
                if (g0 == null) {
                    g0 = g;
                }
                if (!g.getChrom().equals(r.getChrom()) || !MiscUtils.doesIntersect(r.getStartPosition().intValue(), r.getEndPosition().intValue(), g.getStart(), g.getEnd())) continue;
                b.addItem(g);
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching genes: %s", ex);
        }
    }

    private Component getFilterButton(String key) {
        JButton button = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FILTER));
        button.setToolTipText("Filter " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        return button;
    }

    private Component getChartButton(final String key) {
        JToggleButton button = ViewUtil.getTexturedToggleButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CHART_SMALL));
        button.setToolTipText("Chart " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasicVariantSubInspector.this.p.toggleDetailVisibility(key);
            }
        });
        return button;
    }

    private Component getNCBIButton(final String key) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " at NCBI");
        ncbiButton.addActionListener(new ActionListener(){
            String baseUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = new URL(this.baseUrl + URLEncoder.encode(BasicVariantSubInspector.this.p.getValue(key), BasicVariantSubInspector.URL_CHARSET));
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching NCBI website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    private KeyValuePairPanel getInfoKVPPanel(String customInfo) {
        String[] pairs = customInfo.split(";");
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        for (String pair : pairs) {
            String[] splitPair = pair.split("=");
            if (splitPair.length != 2) continue;
            kvp.addKey(splitPair[0]);
            kvp.setValue(splitPair[0], splitPair[1]);
        }
        return kvp;
    }
}

