/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartFrequencyMap;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartMapGenerator;
import org.ut.biolab.medsavant.client.view.genetics.charts.FrequencyEntry;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class VariantFieldChartMapGenerator
implements ChartMapGenerator,
BasicPatientColumns,
BasicVariantColumns {
    private final CustomField field;
    private final WhichTable whichTable;
    Map<String, ChartFrequencyMap> unfilteredMapCache = new HashMap<String, ChartFrequencyMap>();
    Map<String, ChartFrequencyMap> filteredMapCache = new HashMap<String, ChartFrequencyMap>();

    private VariantFieldChartMapGenerator(CustomField field, WhichTable whichTable) {
        this.field = field;
        this.whichTable = whichTable;
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                if (!VariantFieldChartMapGenerator.this.filteredMapCache.isEmpty()) {
                    VariantFieldChartMapGenerator.this.filteredMapCache.clear();
                }
            }
        });
    }

    public static VariantFieldChartMapGenerator createVariantChart(CustomField field) {
        return new VariantFieldChartMapGenerator(field, WhichTable.VARIANT);
    }

    public static VariantFieldChartMapGenerator createPatientChart(CustomField field) {
        return new VariantFieldChartMapGenerator(field, WhichTable.PATIENT);
    }

    public CustomField getField() {
        return this.field;
    }

    public ChartFrequencyMap generateCategoricalChartMap(boolean useFilteredCounts, boolean isLogScaleX) throws InterruptedException, SQLException, RemoteException {
        ChartFrequencyMap chartMap = new ChartFrequencyMap();
        try {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Object filterConditions = useFilteredCounts ? FilterController.getInstance().getAllFilterConditions() : new Condition[][]{};
            if (this.whichTable == WhichTable.VARIANT) {
                Map<String, Integer> m = MedSavantClient.VariantManager.getFilteredFrequencyValuesForCategoricalColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), (Condition[][])filterConditions, this.field.getColumnName());
                chartMap.addAll(m);
            } else if (this.whichTable == WhichTable.PATIENT) {
                Map<Object, List<String>> map = MedSavantClient.PatientManager.getDNAIDsForValues(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.field.getColumnName());
                if (this.field.getColumnName().equals(GENDER.getColumnName())) {
                    map = ClientMiscUtils.modifyGenderMap(map);
                }
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                List<String> dnaIDs = this.getDNAIDs();
                Map<String, Integer> dnaIdToCount = MedSavantClient.VariantManager.getDNAIDHeatMap(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), (Condition[][])filterConditions, (Collection<String>)dnaIDs);
                for (Object key : map.keySet()) {
                    int numVariants = 0;
                    for (String dnaId : map.get(key)) {
                        Integer value = dnaIdToCount.get(dnaId);
                        if (value == null) continue;
                        numVariants += value.intValue();
                    }
                    if (numVariants <= 0) continue;
                    chartMap.addEntry(key.toString(), numVariants);
                }
            }
            if (this.whichTable == WhichTable.VARIANT && this.field.getColumnName().equals(CHROM.getColumnName())) {
                chartMap.sortKaryotypically();
            } else {
                chartMap.sort();
            }
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
        return chartMap;
    }

    private String checkInt(double d) {
        if ((double)Math.round(d) == d) {
            return ViewUtil.numToString((int)d);
        }
        return ViewUtil.numToString(d);
    }

    public ChartFrequencyMap generateNumericChartMap(boolean useFilteredCounts, boolean isLogScaleX) throws InterruptedException, SQLException, RemoteException {
        ChartFrequencyMap chartMap = new ChartFrequencyMap();
        try {
            Object conditions = useFilteredCounts ? FilterController.getInstance().getAllFilterConditions() : new Condition[][]{};
            if (this.whichTable == WhichTable.VARIANT) {
                Map<Range, Long> resultMap = MedSavantClient.VariantManager.getFilteredFrequencyValuesForNumericColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), (Condition[][])conditions, this.field, isLogScaleX);
                Object[] keySet = resultMap.keySet().toArray();
                if (!isLogScaleX) {
                    double startFirstRange = ((Range)keySet[0]).getMin();
                    double startLastRange = ((Range)keySet[keySet.length - 1]).getMin();
                    double binSize = ((Range)keySet[0]).getMax() - ((Range)keySet[0]).getMin();
                    for (double start = startFirstRange; start <= startLastRange; start += binSize) {
                        Long value = resultMap.get(new Range(start, start + binSize));
                        if (value == null) {
                            value = 0L;
                        }
                        chartMap.addEntry(this.checkInt(start) + " - " + this.checkInt(start + binSize), value);
                    }
                } else {
                    for (Object key : keySet) {
                        chartMap.addEntry(this.checkInt(((Range)key).getMin()) + " - " + this.checkInt(((Range)key).getMax()), resultMap.get((Range)key));
                    }
                }
            } else {
                Range r = MedSavantClient.DBUtils.getExtremeValuesForColumn(LoginController.getSessionID(), this.whichTable.getName(), this.field.getColumnName());
                double binSize = ClientMiscUtils.generateBins(this.field, r, isLogScaleX);
                Map<Object, List<String>> map = MedSavantClient.PatientManager.getDNAIDsForValues(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.field.getColumnName());
                int maxBin = 0;
                for (Object key : map.keySet()) {
                    double value = ClientMiscUtils.getDouble(key);
                    if ((int)(value / binSize) <= maxBin) continue;
                    maxBin = (int)(value / binSize);
                }
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                List<String> dnaIds = this.getDNAIDs();
                Map<String, Integer> dnaIDToCount = MedSavantClient.VariantManager.getDNAIDHeatMap(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), (Condition[][])conditions, (Collection<String>)dnaIds);
                int[] counts = new int[maxBin + 1];
                Arrays.fill(counts, 0);
                for (Object key : map.keySet()) {
                    double value = ClientMiscUtils.getDouble(key);
                    int bin = (int)(value / binSize);
                    for (String dnaId : map.get(key)) {
                        Integer count = dnaIDToCount.get(dnaId);
                        if (count == null) continue;
                        int n = bin;
                        counts[n] = counts[n] + count;
                    }
                }
                for (int i = 0; i < counts.length; ++i) {
                    double min = (double)i * binSize;
                    double max = min + binSize;
                    chartMap.addEntry(this.checkInt(min) + " - " + this.checkInt(max), counts[i]);
                }
            }
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
        return chartMap;
    }

    public ChartFrequencyMap generateChartMap(boolean isLogScaleX) throws InterruptedException, SQLException, RemoteException {
        return this.generateChartMap(true, isLogScaleX);
    }

    @Override
    public ChartFrequencyMap generateChartMap(boolean useFilteredCounts, boolean isLogScaleX) throws InterruptedException, SQLException, RemoteException {
        ChartFrequencyMap chartMap;
        boolean noConditions;
        String cacheKey = ProjectController.getInstance().getCurrentProjectID() + "_" + ReferenceController.getInstance().getCurrentReferenceID() + "_" + this.field.getColumnName() + "_" + isLogScaleX;
        boolean bl = noConditions = !useFilteredCounts || FilterController.getInstance().getAllFilterConditions().length == 0;
        if (!useFilteredCounts) {
            if (this.unfilteredMapCache.containsKey(cacheKey)) {
                return this.unfilteredMapCache.get(cacheKey);
            }
        } else if (this.filteredMapCache.containsKey(cacheKey)) {
            return this.filteredMapCache.get(cacheKey);
        }
        if (this.isNumeric() && !this.field.getColumnName().equals(BasicPatientColumns.GENDER.getColumnName())) {
            chartMap = this.generateNumericChartMap(useFilteredCounts, isLogScaleX);
        } else {
            chartMap = this.generateCategoricalChartMap(useFilteredCounts, isLogScaleX);
            if (this.field.getColumnType() == ColumnType.BOOLEAN) {
                for (FrequencyEntry fe : chartMap.getEntries()) {
                    if (fe.getKey().equals("0")) {
                        fe.setKey("False");
                        continue;
                    }
                    if (!fe.getKey().equals("1")) continue;
                    fe.setKey("True");
                }
            }
        }
        if (!useFilteredCounts) {
            this.unfilteredMapCache.put(cacheKey, chartMap);
        } else if (useFilteredCounts || noConditions) {
            this.filteredMapCache.put(cacheKey, chartMap);
        }
        return chartMap;
    }

    @Override
    public boolean isNumeric() {
        return this.field.getColumnType().isNumeric();
    }

    @Override
    public String getName() {
        return this.field.getAlias();
    }

    @Override
    public WhichTable getTable() {
        return this.whichTable;
    }

    @Override
    public String getFilterId() {
        return this.field.getColumnName();
    }

    private List<String> getDNAIDs() throws InterruptedException, SQLException, RemoteException {
        try {
            List<String> dnaIDs = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantTableName(), DNA_ID.getColumnName(), true);
            if (dnaIDs == null) {
                dnaIDs = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentVariantSubTableName(), DNA_ID.getColumnName(), false);
            }
            return dnaIDs;
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }
}

