/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import com.jidesoft.chart.model.ChartCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.client.view.genetics.charts.FrequencyEntry;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;

public class ChartFrequencyMap {
    private List<FrequencyEntry> entries = new ArrayList<FrequencyEntry>();
    private List<FrequencyEntry> originalEntries;

    public void addEntry(String key, long value) {
        if (!key.isEmpty()) {
            this.entries.add(new FrequencyEntry(key, value));
        }
    }

    public List<FrequencyEntry> getEntries() {
        return this.entries;
    }

    public void addAll(Map<String, Integer> map) {
        for (String s : map.keySet()) {
            this.addEntry(s, map.get(s).intValue());
        }
    }

    public void sort() {
        Collections.sort(this.entries);
    }

    public void sortNumerically() {
        if (this.originalEntries == null) {
            this.originalEntries = new ArrayList<FrequencyEntry>();
            this.originalEntries.addAll(this.entries);
        }
        Collections.sort(this.entries, new Comparator<FrequencyEntry>(){

            @Override
            public int compare(FrequencyEntry t, FrequencyEntry t1) {
                long diff = t.getFrequency() - t1.getFrequency();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        Collections.reverse(this.entries);
    }

    public void undoSortNumerically() {
        if (this.originalEntries != null) {
            this.entries = this.originalEntries;
            this.originalEntries = null;
        }
    }

    public void sortKaryotypically() {
        Collections.sort(this.entries, new Comparator<FrequencyEntry>(){
            private ChromosomeComparator comparator = new ChromosomeComparator();

            @Override
            public int compare(FrequencyEntry t, FrequencyEntry t1) {
                return this.comparator.compare(t.getKey(), t1.getKey());
            }
        });
    }

    static ChartFrequencyMap subtract(ChartFrequencyMap map1, ChartFrequencyMap map2, boolean logY) {
        ChartFrequencyMap result = new ChartFrequencyMap();
        for (FrequencyEntry fe1 : map1.entries) {
            FrequencyEntry fe2 = map2.getEntry(fe1.getKey());
            if (fe2 == null) {
                result.addEntry(fe1.getKey(), fe1.getFrequency());
                continue;
            }
            if (logY) {
                result.addEntry(fe1.getKey(), (long)Math.pow(10.0, Math.log10(fe1.getFrequency()) - Math.log10(fe2.getFrequency())));
                continue;
            }
            result.addEntry(fe1.getKey(), fe1.getFrequency() - fe2.getFrequency());
        }
        return result;
    }

    List<ChartCategory> getCategories() {
        ArrayList<ChartCategory> map = new ArrayList<ChartCategory>();
        for (FrequencyEntry fe : this.getEntries()) {
            ChartCategory cat = new ChartCategory((Object)fe.getKey());
            map.add(cat);
        }
        return map;
    }

    long getMax() {
        long max = Integer.MIN_VALUE;
        for (FrequencyEntry fe : this.getEntries()) {
            if (fe.getFrequency() <= max) continue;
            max = fe.getFrequency();
        }
        return max;
    }

    FrequencyEntry getEntry(String key) {
        for (FrequencyEntry fe : this.entries) {
            if (!fe.getKey().equals(key)) continue;
            return fe;
        }
        return null;
    }
}

