/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.client.controller.AnalyticsController;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;

public class AnalyticsPage
extends AppSubSection {
    private JPanel view;
    public static final String PAGE_NAME = "Analytics";
    private final AnalyticsController controller = AnalyticsController.getInstance();
    AnalyticsController.Analysis selectedAnalysis;

    public AnalyticsPage(MultiSectionApp parent) {
        super(parent, PAGE_NAME);
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<AnalyticsController.Analysis>("Analyses"){

                public AnalyticsController.Analysis[] getData() throws Exception {
                    List<AnalyticsController.Analysis> analytics = AnalyticsPage.this.controller.getVariantAnalytics();
                    AnalyticsController.Analysis[] a = new AnalyticsController.Analysis[analytics.size()];
                    for (int i = 0; i < analytics.size(); ++i) {
                        a[i] = analytics.get(i);
                    }
                    return a;
                }
            }, this.getDetailedView(), this.getListEditor());
        }
        return this.view;
    }

    private DetailedView getDetailedView() {
        return new DetailedView("Analyses"){

            @Override
            public void setSelectedItem(Object[] selectedRow) {
                AnalyticsPage.this.stopCurrentAnalysis();
                if (selectedRow == null) {
                    this.block("No analysis selected");
                    AnalyticsPage.this.selectedAnalysis = null;
                } else {
                    AnalyticsController.Analysis a;
                    AnalyticsPage.this.selectedAnalysis = a = (AnalyticsController.Analysis)selectedRow[0];
                    this.setContent(a.getContent());
                }
            }

            @Override
            public void setMultipleSelections(List<Object[]> selectedRows) {
                AnalyticsPage.this.stopCurrentAnalysis();
                if (selectedRows.isEmpty()) {
                    this.block("No analysis selected");
                } else {
                    this.block("Select one analysis");
                }
                AnalyticsPage.this.selectedAnalysis = null;
            }

            @Override
            public JPopupMenu createPopup() {
                return new JPopupMenu();
            }

            private void setContent(JPanel content) {
                this.removeAll();
                this.setLayout(new BorderLayout());
                this.add((Component)content, "Center");
                this.updateUI();
            }

            private void block(String msg) {
                this.removeAll();
                this.setLayout(new BorderLayout());
                BlockingPanel blockPanel = new BlockingPanel(msg, new JPanel());
                blockPanel.block();
                this.add((Component)blockPanel, "Center");
                this.updateUI();
            }
        };
    }

    private DetailedListEditor getListEditor() {
        return new DetailedListEditor();
    }

    public void update() {
    }

    private void stopCurrentAnalysis() {
        if (this.selectedAnalysis != null) {
            this.selectedAnalysis.stop();
        }
    }

    @Override
    public void viewWillLoad() {
        super.viewWillLoad();
        if (this.selectedAnalysis != null) {
            this.selectedAnalysis.restart();
        }
    }

    @Override
    public void viewDidUnload() {
        super.viewDidUnload();
        this.stopCurrentAnalysis();
    }
}

