/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class ProgressDialog
extends JDialog {
    protected static final Log LOG = LogFactory.getLog(ProgressDialog.class);
    protected ProgressWheel bar;
    protected Timer progressTimer;
    private Exception failure;

    public ProgressDialog(String title, String message) {
        this(title, message, false);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    ProgressDialog(String title, String message, boolean cancellable) {
        super(DialogUtils.getFrontWindow(), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        Container p = this.getContentPane();
        p.setLayout(new GridBagLayout());
        JLabel messageLabel = new JLabel(message);
        this.bar = ViewUtil.getIndeterminateProgressBar();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 45, 3, 45);
        p.add((Component)messageLabel, gbc);
        gbc.insets = new Insets(3, 45, cancellable ? 3 : 30, 45);
        p.add((Component)this.bar, gbc);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            new MedSavantWorker<Void>("Progress"){

                @Override
                public Void doInBackground() throws Exception {
                    ProgressDialog.this.run();
                    return null;
                }

                @Override
                protected void showProgress(double frac) {
                    if (frac >= 1.0) {
                        ProgressDialog.this.setVisible(false);
                    }
                }

                @Override
                protected void showSuccess(Void result) {
                }

                @Override
                protected void showFailure(Throwable x) {
                    if (x instanceof Exception && !(x instanceof InterruptedException)) {
                        ProgressDialog.this.failure = (Exception)x;
                    } else {
                        super.showFailure(x);
                    }
                }

                @Override
                public void done() {
                    if (this.progressTimer != null) {
                        this.progressTimer.stop();
                    }
                    super.done();
                }
            }.execute();
            if (this.progressTimer != null) {
                this.progressTimer.start();
            }
        }
        super.setVisible(flag);
    }

    public abstract void run() throws Exception;

    public void showDialog() throws Exception {
        this.setVisible(true);
        if (this.failure != null) {
            throw this.failure;
        }
    }
}

