/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;

public class PathField
extends JPanel {
    final JTextField f;
    final JButton b;
    final JFileChooser fc;

    public PathField(int JFileChooserDialogType) {
        this(JFileChooserDialogType, false);
    }

    public void setFileFilter(FileFilter filter) {
        this.fc.setFileFilter(filter);
    }

    public JTextField getTextField() {
        return this.f;
    }

    public PathField(final int JFileChooserDialogType, boolean directoriesOnly) {
        this.setOpaque(false);
        this.f = new JTextField();
        this.b = new JButton("...");
        this.fc = new JFileChooser();
        this.f.setMaximumSize(new Dimension(9999, 22));
        if (JFileChooserDialogType == 1) {
            this.fc.setDialogTitle("Save File");
            this.f.setToolTipText("Path to output file");
            this.b.setToolTipText("Set output file");
        } else {
            this.fc.setDialogTitle("Open File");
            this.f.setToolTipText("Path to input file");
            this.b.setToolTipText("Choose input file");
        }
        if (directoriesOnly) {
            this.fc.setFileSelectionMode(1);
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.f);
        this.add(this.b);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathField.this.fc.setDialogType(JFileChooserDialogType);
                int result = PathField.this.fc.showDialog(null, null);
                if (result == 1 || result == -1) {
                    return;
                }
                PathField.this.setPath(PathField.this.fc.getSelectedFile().getAbsolutePath());
            }
        });
    }

    public String getPath() {
        return this.f.getText();
    }

    public void setPath(String s) {
        this.f.setText(s);
    }

    public JFileChooser getFileChooser() {
        return this.fc;
    }

    public void setFileFilters(ExtensionFileFilter[] filters) {
        for (ExtensionFileFilter f : filters) {
            this.fc.addChoosableFileFilter(f);
        }
    }
}

