/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class NiceMenu
extends JPanel {
    private final MigLayout layout;
    private final JPanel leftComponent;
    private final JPanel centerComponent;
    private final JPanel rightComponent;

    public NiceMenu() {
        this(MenuLocation.TOP);
        this.setBackground(ViewUtil.getPrimaryMenuColor());
    }

    public NiceMenu(MenuLocation location) {
        if (location == MenuLocation.TOP) {
            this.setBorder(ViewUtil.getBottomLineBorder());
        } else {
            this.setBorder(ViewUtil.getTopLineBorder());
        }
        this.leftComponent = ViewUtil.getClearPanel();
        this.leftComponent.setLayout((LayoutManager)new MigLayout("insets 0, nogrid, gapx 10, hidemode 3, filly"));
        this.centerComponent = ViewUtil.getClearPanel();
        this.rightComponent = ViewUtil.getClearPanel();
        this.rightComponent.setLayout((LayoutManager)new MigLayout("insets 0, nogrid, alignx trailing, gapx 10, hidemode 3, filly"));
        this.layout = new MigLayout("gapx 0, gapy 0, fillx, filly " + (location == MenuLocation.TOP ? ", height 44, insets 5 15 5 15" : ", insets 5"));
        this.setLayout((LayoutManager)this.layout);
        this.add((Component)this.leftComponent, "width 20%");
        this.add((Component)this.centerComponent, "width 60%, center");
        this.add((Component)this.rightComponent, "width 20%");
    }

    public void addLeftComponent(JComponent c) {
        this.leftComponent.add((Component)c, "left");
    }

    public void addRightComponent(JComponent c) {
        this.rightComponent.add((Component)c, "right");
    }

    public void setCenterComponent(JComponent c) {
        this.centerComponent.removeAll();
        this.centerComponent.add((Component)c, "center");
    }

    public void setTitle(String title) {
        this.centerComponent.removeAll();
        JLabel titleLabel = new JLabel("");
        titleLabel.setText(title);
        titleLabel.setForeground(new Color(64, 64, 64));
        titleLabel.setFont(FontFactory.getMenuTitleFont());
        this.setCenterComponent(titleLabel);
        this.centerComponent.invalidate();
        this.centerComponent.updateUI();
    }

    public static enum MenuLocation {
        TOP,
        BOTTOM;

    }
}

