/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class MSTabbedPaneUI5
extends BasicTabbedPaneUI {
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private Color selectedColorSet;
    private Color defaultColorSet;
    private Color hoverColorSet;
    private Color lineColor = new Color(192, 192, 192);
    private Insets contentInsets = new Insets(10, 10, 10, 10);
    private int lastRollOverTab = -1;
    int underlineHeight = 4;
    int tabHeight = 35;

    public static ComponentUI createUI(JComponent c) {
        return new MSTabbedPaneUI5();
    }

    public MSTabbedPaneUI5() {
        Color selectedColor = ViewUtil.getMedSavantBlueColor();
        Color unselectedColor = Color.white;
        Color hoverColor = new Color(147, 176, 218);
        this.selectedColorSet = selectedColor;
        this.defaultColorSet = unselectedColor;
        this.hoverColorSet = hoverColor;
        this.setContentInsets(0);
    }

    public void setContentInsets(Insets i) {
        this.contentInsets = i;
    }

    public void setContentInsets(int i) {
        this.contentInsets = new Insets(i, i, i, i);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        RollOverListener l = new RollOverListener();
        this.tabPane.addMouseListener(l);
        this.tabPane.addMouseMotionListener(l);
        this.tabAreaInsets = NO_INSETS;
        this.tabInsets = new Insets(0, 0, 0, 1);
    }

    protected boolean scrollableTabLayoutEnabled() {
        return false;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentInsets;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return this.tabHeight;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int w = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        int wid = metrics.charWidth('M');
        return w += wid * 2;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return 35;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.defaultColorSet);
        g2d.fillRect(0, 0, this.tabPane.getWidth(), this.tabPane.getHeight());
        super.paintTabArea(g, tabPlacement, selectedIndex);
        g2d.setColor(this.lineColor);
        g2d.drawLine(0, this.tabHeight - 1, this.tabPane.getWidth() - 1, this.tabHeight);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = this.rects[tabIndex];
        Color colorSet = isSelected ? this.selectedColorSet : (this.getRolloverTab() == tabIndex ? this.hoverColorSet : this.defaultColorSet);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = rect.width;
        int xpos = rect.x;
        if (tabIndex > 0) {
            --width;
            ++xpos;
        }
        g2d.setColor(colorSet);
        g2d.fillRect(xpos, h - this.underlineHeight, width, this.underlineHeight);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    private class RollOverListener
    implements MouseMotionListener,
    MouseListener {
        private RollOverListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.checkRollOver();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.checkRollOver();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MSTabbedPaneUI5.this.tabPane.repaint();
        }

        private void checkRollOver() {
            int currentRollOver = MSTabbedPaneUI5.this.getRolloverTab();
            if (currentRollOver != MSTabbedPaneUI5.this.lastRollOverTab) {
                MSTabbedPaneUI5.this.lastRollOverTab = currentRollOver;
                Rectangle tabsRect = new Rectangle(0, 0, MSTabbedPaneUI5.this.tabPane.getWidth(), MSTabbedPaneUI5.this.tabPane.getHeight());
                MSTabbedPaneUI5.this.tabPane.repaint(tabsRect);
            }
        }
    }
}

