/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class MSTabbedPaneUI3
extends BasicTabbedPaneUI {
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private ColorSet selectedColorSet;
    private ColorSet defaultColorSet;
    private ColorSet hoverColorSet;
    private boolean contentTopBorderDrawn = true;
    private Color lineColor = new Color(192, 192, 192);
    private Color dividerColor = new Color(192, 192, 192);
    private Insets contentInsets = new Insets(10, 10, 10, 10);
    private int lastRollOverTab = -1;

    public static ComponentUI createUI(JComponent c) {
        return new MSTabbedPaneUI3();
    }

    public MSTabbedPaneUI3() {
        this.selectedColorSet = new ColorSet();
        Color selectedColor = ViewUtil.getMedSavantBlueColor();
        Color unselectedColor = new Color(222, 222, 222);
        Color hoverColor = new Color(235, 235, 235);
        this.selectedColorSet.topGradColor1 = selectedColor;
        this.selectedColorSet.topGradColor2 = selectedColor;
        this.selectedColorSet.bottomGradColor1 = selectedColor;
        this.selectedColorSet.bottomGradColor2 = selectedColor;
        this.defaultColorSet = new ColorSet();
        this.defaultColorSet.topGradColor1 = unselectedColor;
        this.defaultColorSet.topGradColor2 = unselectedColor;
        this.defaultColorSet.bottomGradColor1 = unselectedColor;
        this.defaultColorSet.bottomGradColor2 = unselectedColor;
        this.hoverColorSet = new ColorSet();
        this.hoverColorSet.topGradColor1 = hoverColor;
        this.hoverColorSet.topGradColor2 = hoverColor;
        this.hoverColorSet.bottomGradColor1 = hoverColor;
        this.hoverColorSet.bottomGradColor2 = hoverColor;
        this.maxTabHeight = 20;
        this.setContentInsets(0);
    }

    public void setContentTopBorderDrawn(boolean b) {
        this.contentTopBorderDrawn = b;
    }

    public void setContentInsets(Insets i) {
        this.contentInsets = i;
    }

    public void setContentInsets(int i) {
        this.contentInsets = new Insets(i, i, i, i);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        RollOverListener l = new RollOverListener();
        this.tabPane.addMouseListener(l);
        this.tabPane.addMouseMotionListener(l);
        this.tabAreaInsets = NO_INSETS;
        this.tabInsets = new Insets(0, 0, 0, 1);
    }

    protected boolean scrollableTabLayoutEnabled() {
        return false;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentInsets;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return 21;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int w = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        int wid = metrics.charWidth('M');
        return w += wid * 2;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return 21;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintTabArea(g, tabPlacement, selectedIndex);
        if (this.contentTopBorderDrawn) {
            g2d.setColor(this.lineColor);
            g2d.drawLine(0, 20, this.tabPane.getWidth() - 1, 20);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = this.rects[tabIndex];
        ColorSet colorSet = isSelected ? this.selectedColorSet : (this.getRolloverTab() == tabIndex ? this.hoverColorSet : this.defaultColorSet);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = rect.width;
        int xpos = rect.x;
        if (tabIndex > 0) {
            --width;
            ++xpos;
        }
        g2d.setPaint(new GradientPaint(xpos, 0.0f, colorSet.topGradColor1, xpos, 10.0f, colorSet.topGradColor2));
        g2d.fillRect(xpos, 0, width, 10);
        g2d.setPaint(new GradientPaint(0.0f, 10.0f, colorSet.bottomGradColor1, 0.0f, 21.0f, colorSet.bottomGradColor2));
        g2d.fillRect(xpos, 10, width, 11);
        if (this.contentTopBorderDrawn) {
            g2d.setColor(this.lineColor);
            g2d.drawLine(rect.x, 20, rect.x + rect.width - 1, 20);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Rectangle rect = this.getTabBounds(tabIndex, new Rectangle(x, y, w, h));
        g.setColor(this.dividerColor);
        g.drawLine(rect.x + rect.width, 0, rect.x + rect.width, 20);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    private class RollOverListener
    implements MouseMotionListener,
    MouseListener {
        private RollOverListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.checkRollOver();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.checkRollOver();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MSTabbedPaneUI3.this.tabPane.repaint();
        }

        private void checkRollOver() {
            int currentRollOver = MSTabbedPaneUI3.this.getRolloverTab();
            if (currentRollOver != MSTabbedPaneUI3.this.lastRollOverTab) {
                MSTabbedPaneUI3.this.lastRollOverTab = currentRollOver;
                Rectangle tabsRect = new Rectangle(0, 0, MSTabbedPaneUI3.this.tabPane.getWidth(), 20);
                MSTabbedPaneUI3.this.tabPane.repaint(tabsRect);
            }
        }
    }

    private class ColorSet {
        Color topGradColor1;
        Color topGradColor2;
        Color bottomGradColor1;
        Color bottomGradColor2;

        private ColorSet() {
        }
    }
}

