/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.ut.biolab.medsavant.client.view.images.IconFactory;

public class LinkButton
extends JButton {
    private static final String face = "Arial";
    private final Image image;
    private final Color bgcolor = Color.LIGHT_GRAY;
    private final Color textColorUnselected = Color.BLACK;
    private final Color disabledBGColor = new Color(210, 210, 210);
    private final int sidePadding = 3;
    private final int topPadding = 2;
    private final int iconWidth = 9;
    private Color textColor = this.textColorUnselected;
    private Font font;
    private int fontSize = 10;
    private int fontStyle = 0;
    private int totalWidth;
    private int totalHeight;
    private boolean over;

    public LinkButton(Image i) {
        this.image = i;
        this.setCursor(new Cursor(12));
        this.resize();
    }

    public LinkButton(String s) {
        super(s);
        this.image = null;
        this.resetFont();
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkButton.this.over = true;
                LinkButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkButton.this.over = false;
                LinkButton.this.repaint();
            }
        });
        this.setCursor(new Cursor(12));
    }

    public void setForeColor(Color c) {
        this.textColor = c;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.resetFont();
    }

    private boolean isImage() {
        return this.image != null;
    }

    public void setFontStyle(int style) {
        this.fontStyle = style;
        this.resetFont();
    }

    private void resize() {
        if (this.isImage()) {
            this.totalWidth = 15;
            this.totalHeight = 13;
        } else {
            String title = this.getText();
            Graphics2D g2d = (Graphics2D)this.getGraphics();
            if (g2d == null) {
                return;
            }
            g2d.setFont(this.font);
            int width = g2d.getFontMetrics().stringWidth(title);
            int height = g2d.getFontMetrics().getAscent();
            this.totalWidth = width + 6;
            this.totalHeight = height + 4;
            if (this.isEnabled()) {
                this.totalWidth += 12;
            }
        }
        this.setPreferredSize(new Dimension(this.totalWidth, this.totalHeight));
        this.setMinimumSize(new Dimension(this.totalWidth, this.totalHeight));
        this.setMaximumSize(new Dimension(this.totalWidth, this.totalHeight));
        this.invalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.totalWidth == 0) {
            this.resize();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.isEnabled()) {
            g2d.setColor(this.disabledBGColor);
            g2d.fillRoundRect(0, 0, this.totalWidth, this.totalHeight, 5, 5);
        } else {
            g2d.setColor(this.bgcolor);
            g2d.fillRoundRect(0, 0, this.totalWidth, this.totalHeight, 5, 5);
        }
        if (this.isImage()) {
            g2d.drawImage(this.image, 3, 2, null);
        } else {
            String title = this.getText();
            g2d.setFont(this.font);
            int width = g2d.getFontMetrics().stringWidth(title);
            int height = g2d.getFontMetrics().getAscent();
            if (this.isEnabled()) {
                this.totalWidth += 12;
            }
            if (this.isEnabled()) {
                g2d.drawImage(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT).getImage(), width + 3 + 3, 2, null);
            }
            if (this.over || this.isSelected()) {
                g2d.setColor(this.textColor);
            } else {
                g2d.setColor(this.textColorUnselected);
            }
            g2d.drawString(title, 3, 1 + height - 1);
        }
    }

    private void resetFont() {
        this.font = new Font(face, this.fontStyle, this.fontSize);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.resize();
        this.invalidate();
    }
}

