/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.component.ListViewTablePanel;
import org.ut.biolab.medsavant.shared.model.Gene;

public class GeneSelectionPanel
extends ListViewTablePanel {
    private static final Log LOG = LogFactory.getLog(GeneSelectionPanel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Chromosome", "Start", "End"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, Integer.class};
    private final DataFlavor geneSetFlavor;
    private final boolean exportEnabled;
    private final boolean importEnabled;

    public GeneSelectionPanel(boolean dragSource, boolean dragTarget) {
        super(new Object[0][0], COLUMN_NAMES, COLUMN_CLASSES, new int[0]);
        this.setFontSize(10.0f);
        this.geneSetFlavor = new DataFlavor(Set.class, "GeneSet");
        this.getTable().setDragEnabled(dragSource || dragTarget);
        this.getTable().setDropMode(DropMode.ON);
        this.exportEnabled = dragSource;
        this.importEnabled = dragTarget;
        if (dragSource || dragTarget) {
            this.getTable().setTransferHandler((TransferHandler)new GeneSetTransferHandler());
            this.getTable().setFillsViewportHeight(true);
        }
    }

    public Set<Gene> getSelectedGenes() {
        CopyOnWriteArraySet<Gene> selectedGenes = new CopyOnWriteArraySet<Gene>();
        for (int row : this.getSelectedRows()) {
            Object[] rowData = this.getRowData(row);
            String geneName = (String)rowData[0];
            String chrom = (String)rowData[1];
            int start = (Integer)rowData[2];
            int end = (Integer)rowData[3];
            Gene g = new Gene(geneName, chrom, start, end);
            selectedGenes.add(g);
        }
        return selectedGenes;
    }

    @Override
    protected Object getKey(Object[] row) {
        return row[0];
    }

    protected void dragAndDropAddGenes(Set<Gene> geneSet) {
        geneSet.removeAll(this.keyRowIndexMap.keySet());
        Object[][] newData = new Object[geneSet.size()][];
        int i = 0;
        for (Gene gene : geneSet) {
            newData[i++] = new Object[]{gene.getName(), gene.getChrom(), new Integer(gene.getStart()), new Integer(gene.getEnd())};
        }
        this.addRows(newData);
    }

    protected void dragAndDropRemoveKeys(Set<Object> keySet) {
        this.removeRows(keySet);
    }

    private class GeneSetTransferHandler
    extends TransferHandler {
        private GeneSetTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (GeneSelectionPanel.this.exportEnabled) {
                return 2;
            }
            return 0;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{GeneSelectionPanel.this.geneSetFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor df) {
                    return df.equals(GeneSelectionPanel.this.geneSetFlavor);
                }

                @Override
                public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                    if (!this.isDataFlavorSupported(df)) {
                        return false;
                    }
                    return GeneSelectionPanel.this.getSelectedGenes();
                }
            };
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            if (action == 2) {
                GeneSelectionPanel.this.dragAndDropRemoveKeys(GeneSelectionPanel.this.getSelectedKeys());
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return GeneSelectionPanel.this.importEnabled && support.isDataFlavorSupported(GeneSelectionPanel.this.geneSetFlavor) && (2 & support.getSourceDropActions()) == 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            try {
                Set genes = (Set)t.getTransferData(GeneSelectionPanel.this.geneSetFlavor);
                GeneSelectionPanel.this.dragAndDropAddGenes(genes);
                return true;
            }
            catch (UnsupportedFlavorException ex) {
                LOG.error((Object)("Unsupported drag-and-drop transfer flavor: " + ex));
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
            return false;
        }
    }
}

