/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.annotation.InstallAnnotationWizard;
import org.ut.biolab.medsavant.client.controller.ExternalAnnotationController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Annotation;

public class AnnotationsPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(AnnotationsPage.class);
    private SplitScreenView view;

    public AnnotationsPage(MultiSectionApp parent) {
        super(parent, "Annotations");
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<Annotation>("Program"){

                public Annotation[] getData() throws Exception {
                    return ExternalAnnotationController.getInstance().getExternalAnnotations();
                }
            }, new ExternalAnnotationDetailedView(), new ExternalAnnotationDetailedListEditor());
        }
        return this.view;
    }

    @Override
    public Component[] getSubSectionMenuComponents() {
        Component[] result = new Component[]{};
        return result;
    }

    public void referenceAdded(String name) {
        this.view.refresh();
    }

    public void referenceRemoved(String name) {
        this.view.refresh();
    }

    public void referenceChanged(String name) {
        this.view.refresh();
    }

    private static class ExternalAnnotationDetailedListEditor
    extends DetailedListEditor {
        private ExternalAnnotationDetailedListEditor() {
        }

        @Override
        public boolean doesImplementAdding() {
            return true;
        }

        @Override
        public boolean doesImplementDeleting() {
            return true;
        }

        @Override
        public void addItems() {
            try {
                new InstallAnnotationWizard().setVisible(true);
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error installing annotations", ex);
            }
        }

        @Override
        public void deleteItems(List<Object[]> items) {
            if (items != null && items.size() > 0) {
                final Annotation an = (Annotation)items.get(0)[0];
                ProgressDialog dialog = new ProgressDialog("Deleting annotation", "Checking for projects using this annotation..."){
                    private boolean inUse;
                    {
                        super(x0, x1);
                        this.inUse = false;
                    }

                    @Override
                    public void run() throws Exception {
                        String[] projectNames = ProjectController.getInstance().getProjectNames();
                        int referenceID = an.getReferenceID();
                        for (String projectName : projectNames) {
                            int projectID = ProjectController.getInstance().getProjectID(projectName);
                            int[] aid = ProjectController.getInstance().getAnnotationIDs(projectID, referenceID);
                            if (!ArrayUtils.contains((int[])aid, (int)an.getID())) continue;
                            this.inUse = true;
                            break;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.dispose();
                                if (!inUse) {
                                    int response = JOptionPane.showConfirmDialog(MedSavantFrame.getInstance().getRootPane(), "Are you sure you want to uninstall " + an.getProgram(), "Confirm", 0, 3);
                                    if (response == 0) {
                                        try {
                                            MedSavantClient.AnnotationManagerAdapter.uninstallAnnotation(LoginController.getSessionID(), an.getID());
                                            DialogUtils.displayMessage("Annotation " + an.getProgram() + " uninstalled");
                                        }
                                        catch (Exception ex) {
                                            ClientMiscUtils.reportError("Error uninstalling annotations", ex);
                                        }
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(MedSavantFrame.getInstance().getRootPane(), "This annotation is being used by other projects and cannot be uninstalled.  Please remove this annotation from these projects first.", "Notice", -1);
                                }
                            }
                        });
                    }
                };
                try {
                    dialog.showDialog();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    private class ExternalAnnotationDetailedView
    extends DetailedView {
        private final JPanel details;
        private final BlockingPanel blockPanel;
        private final StandardFixableWidthAppPanel canvas;

        public ExternalAnnotationDetailedView() {
            super(AnnotationsPage.this.pageName);
            this.canvas = new StandardFixableWidthAppPanel();
            this.blockPanel = new BlockingPanel("No annotation selected", this.canvas);
            this.details = this.canvas.addBlock();
            this.blockPanel.block();
            this.setLayout(new BorderLayout());
            this.add((Component)this.blockPanel, "Center");
        }

        @Override
        public void setSelectedItem(Object[] item) {
            if (item.length == 0) {
                this.blockPanel.block();
            } else {
                Annotation annotation = (Annotation)item[0];
                String title = annotation.toString();
                this.canvas.setTitle(title);
                this.details.removeAll();
                this.details.updateUI();
                ArrayList<String[]> infoList = new ArrayList<String[]>();
                infoList.add(new String[]{"Program", annotation.getProgram()});
                infoList.add(new String[]{"Version", annotation.getVersion()});
                infoList.add(new String[]{"Reference Genome", annotation.getReferenceName()});
                infoList.add(new String[]{"Type", annotation.getAnnotationType().toString()});
                this.setDetailsList(infoList);
            }
        }

        @Override
        public void setMultipleSelections(List<Object[]> selectedRows) {
            if (selectedRows.isEmpty()) {
                this.blockPanel.block();
            } else {
                if (selectedRows.isEmpty()) {
                    this.canvas.setTitle("");
                } else {
                    this.canvas.setTitle("Multiple annotations (" + selectedRows.size() + ")");
                }
                this.details.removeAll();
                this.details.updateUI();
            }
        }

        private synchronized void setDetailsList(List<String[]> info) {
            this.details.removeAll();
            ViewUtil.setBoxYLayout(this.details);
            String[][] values = new String[info.size()][2];
            for (int i = 0; i < info.size(); ++i) {
                values[i][0] = info.get(i)[0];
                values[i][1] = info.get(i)[1];
            }
            this.details.add(ViewUtil.getKeyValuePairList(values));
            this.details.updateUI();
            this.blockPanel.unblock();
        }
    }
}

