/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.animation;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import org.ut.biolab.medsavant.client.view.animation.AnimatablePanel;
import org.ut.biolab.medsavant.client.view.animation.Animation;

public class IconTranslatorAnimation
extends Animation {
    private Image img;
    private int srcX;
    private int srcY;
    private int dstX;
    private int dstY;
    private int currX;
    private int currY;

    public IconTranslatorAnimation(Image img, Point src, Point dst, long maxRunTime) {
        super(maxRunTime);
        this.srcX = this.currX = src.x;
        this.srcY = this.currY = src.y;
        this.dstX = dst.x;
        this.dstY = dst.y;
        this.img = img;
    }

    private double getCurrX(long t) {
        return (double)this.srcX + (double)t * ((double)(this.dstX - this.srcX) / (double)this.getMaxRunTime());
    }

    private double getCurrY(long t) {
        return (double)this.srcY + (double)t * ((double)(this.dstY - this.srcY) / (double)this.getMaxRunTime());
    }

    @Override
    public boolean tick(long t) {
        this.currX = (int)Math.round(this.getCurrX(t));
        this.currY = (int)Math.round(this.getCurrY(t));
        if (t >= this.getMaxRunTime()) {
            this.currX = this.dstX;
            this.currY = this.dstY;
        }
        return this.currX == this.dstX && this.currY == this.dstY;
    }

    @Override
    public void drawUpdate(Graphics2D g2d, AnimatablePanel ap) {
        g2d.drawImage(this.img, this.currX, this.currY, ap);
    }

    @Override
    public void done() {
    }
}

