/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import com.jidesoft.wizard.WizardDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.variant.PublicationWorker;

public abstract class VariantWorker
extends MedSavantWorker<Void> {
    private static final Log LOG = LogFactory.getLog(PublicationWorker.class);
    private final String activity;
    protected final WizardDialog wizard;
    private final JLabel progressLabel;
    private final JProgressBar progressBar;
    protected final JButton workButton;

    VariantWorker(String activity, WizardDialog wizard, JLabel progressLabel, JProgressBar progressBar, JButton workButton) {
        super(activity + "Variants");
        this.activity = activity;
        this.wizard = wizard;
        this.progressLabel = progressLabel;
        this.progressBar = progressBar;
        this.workButton = workButton;
        progressLabel.setText(String.format("%s ...", activity));
        workButton.setText("Cancel");
        if (workButton.getActionListeners().length > 0) {
            workButton.removeActionListener(workButton.getActionListeners()[0]);
        }
        workButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariantWorker.this.progressBar.setIndeterminate(true);
                VariantWorker.this.workButton.setText("Cancelling...");
                VariantWorker.this.workButton.setEnabled(false);
                VariantWorker.this.cancel(true);
            }
        });
        workButton.setEnabled(true);
        wizard.setDefaultCloseOperation(0);
    }

    @Override
    protected void showProgress(double fraction) {
    }

    @Override
    protected void showSuccess(Void result) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(100);
        this.progressLabel.setText(String.format("%s complete.", this.activity));
        this.workButton.setEnabled(false);
        this.wizard.setDefaultCloseOperation(2);
    }

    @Override
    protected void showFailure(Throwable ex) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.wizard.setDefaultCloseOperation(2);
        if (ex instanceof InterruptedException) {
            this.progressLabel.setText(String.format("%s cancelled.", this.activity));
            this.workButton.setText("Cancel");
        } else {
            ClientMiscUtils.checkSQLException(ex);
            this.progressLabel.setForeground(Color.RED);
            this.progressLabel.setText(ex.getMessage());
            LOG.error((Object)(this.activity + " failed."), ex);
        }
    }
}

