/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.variant.VariantFilesDetailedListEditor;
import org.ut.biolab.medsavant.client.variant.VariantFilesDetailedView;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.list.SimpleDetailedListModel;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;

public class VariantFilesPage
extends AppSubSection {
    static final Log LOG = LogFactory.getLog(VariantFilesPage.class);
    private SplitScreenView view;
    private boolean updateRequired = false;

    public VariantFilesPage(MultiSectionApp parent) {
        super(parent, "Variant Files");
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    if (VariantFilesPage.this.loaded) {
                        VariantFilesPage.this.update();
                    } else {
                        VariantFilesPage.this.updateRequired = true;
                    }
                }
            }
        });
    }

    @Override
    public JPanel getView() {
        if (this.view == null) {
            this.view = new SplitScreenView(new SimpleDetailedListModel<SimpleVariantFile>("Variant File"){

                public SimpleVariantFile[] getData() throws Exception {
                    SimpleVariantFile[] files = MedSavantClient.VariantManager.getUploadedFiles(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID());
                    return files;
                }
            }, new VariantFilesDetailedView(this.pageName), new VariantFilesDetailedListEditor());
            this.view.setSearchBarEnabled(true);
        }
        return this.view;
    }

    @Override
    public void viewWillLoad() {
        super.viewWillLoad();
        this.update();
    }

    @Override
    public void viewDidUnload() {
        super.viewDidUnload();
    }

    public void update() {
        this.view.refresh();
    }
}

